/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli;

import com.cloudera.hive.jdbc42.internal.apache.commons.cli.CommandLine;
import com.cloudera.hive.jdbc42.internal.apache.commons.cli.DefaultParser;
import com.cloudera.hive.jdbc42.internal.apache.commons.cli.Options;
import com.cloudera.hive.jdbc42.internal.apache.commons.cli.ParseException;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.KeeperException;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.CliCommand;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.CliException;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.CliParseException;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.CliWrapperException;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.MalformedPathException;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.StatPrinter;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.data.Stat;

public class StatCommand
extends CliCommand {
    private static final Options options = new Options();
    private String[] args;
    private CommandLine cl;

    public StatCommand() {
        super("stat", "[-w] path");
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws CliParseException {
        DefaultParser parser = new DefaultParser();
        try {
            this.cl = parser.parse(options, cmdArgs);
        }
        catch (ParseException ex) {
            throw new CliParseException(ex);
        }
        this.args = this.cl.getArgs();
        if (this.args.length < 2) {
            throw new CliParseException(this.getUsageStr());
        }
        this.retainCompatibility(cmdArgs);
        return this;
    }

    private void retainCompatibility(String[] cmdArgs) throws CliParseException {
        if (this.args.length > 2) {
            cmdArgs[2] = "-w";
            this.err.println("'stat path [watch]' has been deprecated. Please use 'stat [-w] path' instead.");
            DefaultParser parser = new DefaultParser();
            try {
                this.cl = parser.parse(options, cmdArgs);
            }
            catch (ParseException ex) {
                throw new CliParseException(ex);
            }
            this.args = this.cl.getArgs();
        }
    }

    @Override
    public boolean exec() throws CliException {
        Stat stat;
        String path = this.args[1];
        boolean watch = this.cl.hasOption("w");
        try {
            stat = this.zk.exists(path, watch);
        }
        catch (IllegalArgumentException ex) {
            throw new MalformedPathException(ex.getMessage());
        }
        catch (KeeperException | InterruptedException ex) {
            throw new CliWrapperException(ex);
        }
        if (stat == null) {
            throw new CliWrapperException(new KeeperException.NoNodeException(path));
        }
        new StatPrinter(this.out).print(stat);
        return watch;
    }

    static {
        options.addOption("w", false, "watch");
    }
}

