/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hive.jdbc42.internal.apache.zookeeper.server.auth;

import com.cloudera.hive.jdbc42.internal.apache.zookeeper.KeeperException;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.data.Id;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.data.Stat;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.server.ZKDatabase;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.server.ZooKeeperServer;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.server.auth.ServerAuthenticationProvider;
import com.cloudera.hive.jdbc42.internal.slf4j.Logger;
import com.cloudera.hive.jdbc42.internal.slf4j.LoggerFactory;
import java.nio.charset.StandardCharsets;

public class KeyAuthenticationProvider
extends ServerAuthenticationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(KeyAuthenticationProvider.class);

    @Override
    public String getScheme() {
        return "key";
    }

    private byte[] getKey(ZooKeeperServer zks) {
        ZKDatabase db = zks.getZKDatabase();
        if (db != null) {
            try {
                Stat stat = new Stat();
                return db.getData("/key", stat, null);
            }
            catch (KeeperException.NoNodeException e) {
                LOG.error("getData failed", e);
            }
        }
        return null;
    }

    private boolean validate(byte[] key, byte[] auth) {
        try {
            String keyStr = new String(key, StandardCharsets.UTF_8);
            String authStr = new String(auth, StandardCharsets.UTF_8);
            int keyVal = Integer.parseInt(keyStr);
            int authVal = Integer.parseInt(authStr);
            if (keyVal != 0 && authVal % keyVal != 0) {
                return false;
            }
        }
        catch (NumberFormatException nfe) {
            LOG.error("bad formatting", nfe);
            return false;
        }
        return true;
    }

    @Override
    public KeeperException.Code handleAuthentication(ServerAuthenticationProvider.ServerObjs serverObjs, byte[] authData) {
        byte[] key = this.getKey(serverObjs.getZks());
        String authStr = new String(authData, StandardCharsets.UTF_8);
        String keyStr = "";
        if (key != null && !this.validate(key, authData)) {
            keyStr = new String(key, StandardCharsets.UTF_8);
            LOG.debug("KeyAuthenticationProvider handleAuthentication ({}, {}) -> FAIL.\n", (Object)keyStr, (Object)authStr);
            return KeeperException.Code.AUTHFAILED;
        }
        LOG.debug("KeyAuthenticationProvider handleAuthentication -> OK.\n");
        serverObjs.getCnxn().addAuthInfo(new Id(this.getScheme(), keyStr));
        return KeeperException.Code.OK;
    }

    @Override
    public boolean matches(ServerAuthenticationProvider.ServerObjs serverObjs, ServerAuthenticationProvider.MatchValues matchValues) {
        return matchValues.getId().equals(matchValues.getAclExpr());
    }

    @Override
    public boolean isAuthenticated() {
        return true;
    }

    @Override
    public boolean isValid(String id) {
        return true;
    }
}

