/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.dsi.core.utilities.impl.future;

import com.cloudera.hiveserver1.dsi.core.utilities.future.NonTrivialJDBCConversions;
import com.cloudera.hiveserver1.dsi.core.utilities.impl.future.NumericJDBCDataSource;
import com.cloudera.hiveserver1.dsi.exceptions.ConversionFailed;
import com.cloudera.hiveserver1.dsi.exceptions.IncorrectTypeException;
import com.cloudera.hiveserver1.support.IWarningListener;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.sql.SQLException;

public abstract class SignedBigIntJDBCDataSource
extends NumericJDBCDataSource {
    public SignedBigIntJDBCDataSource(IWarningListener iWarningListener) {
        super(iWarningListener);
    }

    protected final void handleConversionResult(long l, String string) throws ConversionFailed {
        switch (this.getListener().getStatus()) {
            case SUCCESS: {
                break;
            }
            case FRACTIONAL_TRUNCATION: {
                throw new RuntimeException("Unexpected fractional truncation!");
            }
            case OVERFLOW: {
                this.onOverflow(l, string);
            }
        }
    }

    @Override
    public Long get() throws ErrorException {
        try {
            long l = this.getLong();
            if (l == 0L && this.wasNull()) {
                return null;
            }
            return l;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public String getString() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        long l = this.getLong();
        if (l == 0L && this.wasNull()) {
            return null;
        }
        return Long.toString(l);
    }

    @Override
    public boolean getBoolean() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        return this.getLong() != 0L;
    }

    @Override
    public byte getByte() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        long l = this.getLong();
        byte by = NonTrivialJDBCConversions.LongConverter.toByte(l, this.getAndClearListener());
        this.handleConversionResult(l, "getByte");
        return by;
    }

    @Override
    public short getShort() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        long l = this.getLong();
        short s = NonTrivialJDBCConversions.LongConverter.toShort(l, this.getAndClearListener());
        this.handleConversionResult(l, "getShort");
        return s;
    }

    @Override
    public int getInt() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        long l = this.getLong();
        int n = NonTrivialJDBCConversions.LongConverter.toInt(l, this.getAndClearListener());
        this.handleConversionResult(l, "getInt");
        return n;
    }

    @Override
    public abstract long getLong() throws ErrorException, SQLException;

    @Override
    public float getFloat() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        return this.getLong();
    }

    @Override
    public double getDouble() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        return this.getLong();
    }

    @Override
    public BigDecimal getBigDecimal() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        long l = this.getLong();
        if (l == 0L && this.wasNull()) {
            return null;
        }
        return BigDecimal.valueOf(l);
    }
}

