/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.hive.api;

import com.cloudera.hiveserver1.dsi.dataengine.utilities.DSITypeUtilities;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.hiveserver1.dsi.utilities.StringConverter;
import com.cloudera.hiveserver1.hivecommon.HiveJDBCSettings;
import com.cloudera.hiveserver1.hivecommon.api.IHiveServerBuffer;
import com.cloudera.hiveserver1.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.hiveserver1.hivecommon.dataengine.HiveJDBCQueryAnalyserUtils;
import com.cloudera.hiveserver1.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.List;

public class HS1Buffer
implements IHiveServerBuffer {
    private final String DESCRIBE_CASE = "DESCRIBE";
    protected int m_numRows;
    public List<String> m_hiveServer1Buffer = null;
    public String[] m_hiveServer1ParsedRow = null;

    @Override
    public void close() {
    }

    @Override
    public boolean getData(int n, long l, long l2, DataWrapper dataWrapper, int n2, short s, String string, HiveJDBCSettings hiveJDBCSettings) throws ErrorException {
        if (this.m_hiveServer1ParsedRow.length <= n) {
            return DSITypeUtilities.outputVarCharStringData("", dataWrapper, l, l2);
        }
        String string2 = this.m_hiveServer1ParsedRow[n];
        if ("NULL".equals(string2)) {
            dataWrapper.setNull(s);
            return false;
        }
        switch (s) {
            case 12: {
                if (HiveJDBCQueryAnalyserUtils.queryAnalysis(string).equalsIgnoreCase("DESCRIBE")) {
                    return DSITypeUtilities.outputVarCharStringData(string2.trim(), dataWrapper, l, l2);
                }
                return DSITypeUtilities.outputVarCharStringData(string2, dataWrapper, l, l2);
            }
            case 1: {
                dataWrapper.setChar(string2);
                return false;
            }
            case 16: {
                dataWrapper.setBoolean(Boolean.parseBoolean(string2));
                return false;
            }
            case -6: {
                dataWrapper.setTinyInt(Byte.parseByte(string2));
                return false;
            }
            case 5: {
                dataWrapper.setSmallInt(Short.parseShort(string2));
                return false;
            }
            case 4: {
                dataWrapper.setInteger(Integer.parseInt(string2));
                return false;
            }
            case -5: {
                dataWrapper.setInteger(Long.parseLong(string2));
                return false;
            }
            case 7: {
                dataWrapper.setReal(Float.parseFloat(string2));
                return false;
            }
            case 8: {
                dataWrapper.setDouble(Double.parseDouble(string2));
                return false;
            }
            case 93: {
                dataWrapper.setTimestamp(StringConverter.parseTimestamp(string2, null));
                return false;
            }
            case 3: {
                dataWrapper.setDecimal(new BigDecimal(string2));
                return false;
            }
            case 91: {
                dataWrapper.setDate(Date.valueOf(string2));
                return false;
            }
        }
        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_RESULTSET_DATA_RETRIEVING_ERR.name(), new String[]{"Data Type May Not Supported"});
        throw errorException;
    }

    @Override
    public int getNumRowsInBuffer() {
        return this.m_numRows;
    }

    @Override
    public void initializeBuffer() throws ErrorException {
        this.m_numRows = this.m_hiveServer1Buffer.size();
        this.parseRow(0);
    }

    @Override
    public boolean isGetNextBuffer(int n) {
        return n >= this.m_numRows;
    }

    @Override
    public void parseRow(int n) throws ErrorException {
        String string = this.m_hiveServer1Buffer.get(n);
        this.m_hiveServer1ParsedRow = string.split("\t");
    }

    @Override
    public Object[] getCurrentRowObjectArray() {
        return null;
    }

    @Override
    public DataWrapper getDataWrapper(int n) throws ErrorException {
        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.UNSUPPORTED_OPERATION_ERR.name(), new String[]{"The getDataWrapper method is not supported."});
        throw errorException;
    }
}

