/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.hive.api;

import com.cloudera.hive.jdbc42.internal.apache.hadoop.hive.service.FieldSchema;
import com.cloudera.hive.jdbc42.internal.apache.hadoop.hive.service.Schema;
import com.cloudera.hive.jdbc42.internal.apache.hadoop.hive.service.ThriftHive;
import com.cloudera.hive.jdbc42.internal.apache.thrift.protocol.TProtocol;
import com.cloudera.hive.jdbc42.internal.apache.thrift.transport.TTransportException;
import com.cloudera.hiveserver1.dsi.core.impl.DSIDriverSingleton;
import com.cloudera.hiveserver1.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.ColumnMetadata;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.Nullable;
import com.cloudera.hiveserver1.dsi.exceptions.OperationCanceledException;
import com.cloudera.hiveserver1.hive.api.HS1Buffer;
import com.cloudera.hiveserver1.hivecommon.DatabaseMetadataInfo;
import com.cloudera.hiveserver1.hivecommon.HiveJDBCSettings;
import com.cloudera.hiveserver1.hivecommon.IServerVersion;
import com.cloudera.hiveserver1.hivecommon.api.CurrentBufferContext;
import com.cloudera.hiveserver1.hivecommon.api.DataTypeUtilities;
import com.cloudera.hiveserver1.hivecommon.api.HiveClientBase;
import com.cloudera.hiveserver1.hivecommon.api.HiveExecutionContext;
import com.cloudera.hiveserver1.hivecommon.api.HiveOperationContext;
import com.cloudera.hiveserver1.hivecommon.api.IExecutorUtility;
import com.cloudera.hiveserver1.hivecommon.api.RowsetBuffer;
import com.cloudera.hiveserver1.hivecommon.core.CoreUtils;
import com.cloudera.hiveserver1.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.hiveserver1.hivecommon.core.HiveJDBCStatement;
import com.cloudera.hiveserver1.hivecommon.dataengine.HiveJDBCPlaceholderTable;
import com.cloudera.hiveserver1.hivecommon.dataengine.metadata.HiveCommonColumnMetadata;
import com.cloudera.hiveserver1.hivecommon.dataengine.metadata.HiveCommonFunctionsMetadataSourceRow;
import com.cloudera.hiveserver1.hivecommon.dataengine.metadata.HiveCommonSchemasMetadataSourceRow;
import com.cloudera.hiveserver1.hivecommon.dataengine.metadata.HiveCommonTablesMetadataSourceRow;
import com.cloudera.hiveserver1.hivecommon.exceptions.HiveJDBCExceptionUtils;
import com.cloudera.hiveserver1.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.hiveserver1.jdbc.utils.HivePkFkAPINotSupportedException;
import com.cloudera.hiveserver1.jdbc.utils.WarningsUtils;
import com.cloudera.hiveserver1.support.ILogger;
import com.cloudera.hiveserver1.support.IWarningListener;
import com.cloudera.hiveserver1.support.LogUtilities;
import com.cloudera.hiveserver1.support.WarningCode;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HS1Client
extends HiveClientBase<HS1Buffer> {
    private HiveJDBCSettings m_settings;
    private ThriftHive.Client m_client;
    private ILogger m_logger;
    private IWarningListener m_warningListener;
    private String currentProcessingQuery;
    protected IServerVersion m_serverVersionName;
    protected int m_serverVersionNum;
    protected DatabaseMetadataInfo dbmdInfo;
    private final String PlateformName = "Apache Hive";
    private static final HashMap<String, Integer> s_hiveToSqlTypeMap = new HashMap();

    public HS1Client(HiveJDBCSettings hiveJDBCSettings, TProtocol tProtocol, ILogger iLogger, IWarningListener iWarningListener) throws ErrorException {
        this.m_settings = hiveJDBCSettings;
        this.m_client = new ThriftHive.Client(tProtocol);
        this.m_logger = iLogger;
        this.m_warningListener = iWarningListener;
        this.openSession();
        try {
            String string = "USE " + this.m_settings.m_Schema;
            HiveExecutionContext hiveExecutionContext = this.executeStatement(string, null);
            this.closeOperation(hiveExecutionContext);
        }
        catch (Exception exception) {
            CoreUtils.postWarning(exception, this.m_warningListener, WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.DATABASE_TABLE_GENERAL_ERR.name(), this.m_logger, WarningsUtils.DO_NOT_SUPPRESS_WARNING_AS_DEBUG_LOG);
            this.m_settings.m_Schema = "default";
        }
    }

    @Override
    public void cancelOperation(HiveOperationContext hiveOperationContext) {
    }

    @Override
    public void checkFetchErrors(RowsetBuffer rowsetBuffer) throws ErrorException {
    }

    @Override
    public void closeOperation(HiveOperationContext hiveOperationContext) {
    }

    @Override
    public void closeSession() throws ErrorException {
        try {
            if (null != this.m_client && null != this.m_client.getInputProtocol() && null != this.m_client.getInputProtocol().getTransport()) {
                this.m_client.getInputProtocol().getTransport().close();
            }
            this.m_settings.m_isConnAlive = false;
        }
        catch (Exception exception) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_SESSION_ERR.name(), "Close Session Error");
            errorException.initCause(exception);
            throw errorException;
        }
    }

    @Override
    public void disconnect() throws ErrorException {
        try {
            this.closeSession();
        }
        catch (ErrorException errorException) {
            ErrorException errorException2 = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DICONNECT_ERR.name(), "Close Session Error");
            errorException2.initCause(errorException);
            throw errorException2;
        }
        try {
            if (null != this.m_client && null != this.m_client.getInputProtocol() && null != this.m_client.getInputProtocol().getTransport()) {
                this.m_client.getInputProtocol().getTransport().close();
            }
        }
        catch (Exception exception) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DICONNECT_ERR.name(), "Close socket Error");
            errorException.initCause(exception);
            throw errorException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HiveExecutionContext executeStatement(String string, IExecutorUtility iExecutorUtility) throws ErrorException {
        HS1Client hS1Client = this;
        synchronized (hS1Client) {
            return this.executeStatementInternal(string);
        }
    }

    @Override
    public void executeUpdate(String string, IExecutorUtility iExecutorUtility) throws ErrorException {
        this.executeStatement(string, iExecutorUtility);
    }

    @Override
    public void fetchRows(HiveOperationContext hiveOperationContext, RowsetBuffer<HS1Buffer> rowsetBuffer) throws ErrorException, OperationCanceledException {
        this.fetchNRows(hiveOperationContext, rowsetBuffer, this.m_settings.m_rowsFetchedPerBlock);
    }

    @Override
    public void fetchNRows(HiveOperationContext hiveOperationContext, RowsetBuffer<HS1Buffer> rowsetBuffer, int n) throws ErrorException, OperationCanceledException {
        try {
            RowsetBuffer<HS1Buffer> rowsetBuffer2 = rowsetBuffer;
            rowsetBuffer2.getBuffer().m_hiveServer1Buffer = this.m_client.fetchN(n);
            boolean bl = rowsetBuffer2.m_bufferHasMoreRows = null != rowsetBuffer2.getBuffer().m_hiveServer1Buffer && !rowsetBuffer2.getBuffer().m_hiveServer1Buffer.isEmpty();
            if (rowsetBuffer.m_bufferHasMoreRows) {
                rowsetBuffer.initializeBuffer();
            } else {
                hiveOperationContext.m_serverHasMoreRows = false;
            }
        }
        catch (Exception exception) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_ROW_FETCHING_ERR.name(), "Row Fetching Error");
            errorException.initCause(exception);
            throw errorException;
        }
    }

    @Override
    public boolean isSessionValid() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            Schema schema = this.m_client.getSchema();
        }
        catch (Exception exception) {
            HiveJDBCExceptionUtils.logException(exception, this.m_logger);
            return false;
        }
        return true;
    }

    @Override
    public int getBinaryColumnSize() {
        return this.m_settings.m_binaryColumnSize;
    }

    public ArrayList<String> getCatalogs() throws ErrorException {
        ArrayList<String> arrayList = new ArrayList<String>();
        HS1Client hS1Client = this;
        synchronized (hS1Client) {
            try {
                arrayList.add(this.m_settings.m_platformCatalog);
                return arrayList;
            }
            catch (Exception exception) {
                throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_METADATA_CATALOG_ERR.name(), "Catalog Metadata Error");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<HiveCommonColumnMetadata> getColumns(String string, String string2) {
        ArrayList<HiveCommonColumnMetadata> arrayList = new ArrayList();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (string == null || string.equals("")) {
            string = this.getCurrentSchema();
        }
        HS1Client hS1Client = this;
        synchronized (hS1Client) {
            try {
                HiveExecutionContext hiveExecutionContext = null;
                if (!this.m_settings.m_platformVersionUtils.supportsDescribeTable(this.m_settings.m_serverVersion)) {
                    hiveExecutionContext = this.executeStatement("SELECT * FROM " + string + "." + string2, null);
                    arrayList = this.getResultSetMetadataForHiveVersion_9(hiveExecutionContext, string, string2);
                    this.closeOperation(hiveExecutionContext);
                    return arrayList;
                }
                hiveExecutionContext = this.executeStatement("DESCRIBE " + string + "." + string2, null);
                RowsetBuffer<HS1Buffer> rowsetBuffer = this.makeRowsetBuffer(hiveExecutionContext);
                do {
                    this.fetchNRows((HiveOperationContext)hiveExecutionContext, rowsetBuffer, this.m_settings.m_rowsFetchedPerBlock);
                    this.checkFetchErrors((RowsetBuffer)rowsetBuffer);
                    if (null == rowsetBuffer.getBuffer().m_hiveServer1Buffer) continue;
                    for (String string3 : rowsetBuffer.getBuffer().m_hiveServer1Buffer) {
                        arrayList2.add(string3);
                    }
                } while (null == rowsetBuffer.getBuffer().m_hiveServer1Buffer || !rowsetBuffer.getBuffer().m_hiveServer1Buffer.isEmpty());
                this.closeOperation(hiveExecutionContext);
                for (String string3 : arrayList2) {
                    String[] stringArray = string3.split("\t");
                    if (null != stringArray && stringArray.length > 0 && null != stringArray[0] && 0 == stringArray[0].trim().length()) {
                        return arrayList;
                    }
                    String string4 = null;
                    if (stringArray.length == 3) {
                        string4 = stringArray[2].trim();
                    }
                    arrayList.add(DataTypeUtilities.createColumn(((HiveJDBCCommonDriver)DSIDriverSingleton.getInstance()).getCatalogName(), string, string2, stringArray[0].trim(), string4, DataTypeUtilities.mapHiveTypeNameToSqltype(stringArray[1].trim().toUpperCase(), 1, this.m_settings), stringArray[1].trim().toUpperCase(), 1, Nullable.NULLABLE.getIntValue(), this.m_settings));
                }
                return arrayList;
            }
            catch (Exception exception) {
                CoreUtils.postWarning(exception, this.m_warningListener, WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.DATABASE_TABLE_GENERAL_ERR.name(), this.m_logger, WarningsUtils.DO_NOT_SUPPRESS_WARNING_AS_DEBUG_LOG);
                return new ArrayList<HiveCommonColumnMetadata>();
            }
        }
    }

    public ArrayList<HiveCommonColumnMetadata> getColumns(Map<MetadataSourceColumnTag, String> map, ArrayList<String> arrayList) {
        return null;
    }

    public ArrayList<HiveCommonColumnMetadata> getColumns(String string, String string2, String string3) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.getColumns(string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCurrentCatalog() {
        HiveJDBCSettings hiveJDBCSettings = this.m_settings;
        synchronized (hiveJDBCSettings) {
            return this.m_settings.m_catalog;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCurrentSchema() {
        HiveJDBCSettings hiveJDBCSettings = this.m_settings;
        synchronized (hiveJDBCSettings) {
            return this.m_settings.m_Schema;
        }
    }

    @Override
    public DatabaseMetadataInfo getDatabaseMetadataInfo() {
        return this.dbmdInfo;
    }

    public HiveExecutionContext GetForeignKeys(ArrayList<String> arrayList, IColumn iColumn) throws HivePkFkAPINotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        throw new HivePkFkAPINotSupportedException();
    }

    public ArrayList<HiveCommonFunctionsMetadataSourceRow> getFunctions(Map<MetadataSourceColumnTag, String> map, ArrayList<String> arrayList) throws ErrorException {
        return null;
    }

    @Override
    public ILogger getLogger() {
        return this.m_logger;
    }

    public HiveExecutionContext GetPrimaryKeys(ArrayList<String> arrayList, IColumn iColumn) throws HivePkFkAPINotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        throw new HivePkFkAPINotSupportedException();
    }

    @Override
    public ArrayList<ColumnMetadata> getResultSetMetadata(HiveOperationContext hiveOperationContext) throws ErrorException {
        try {
            Schema schema = this.m_client.getSchema();
            ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>(schema.getFieldSchemasSize());
            if (null != schema.getFieldSchemas()) {
                for (FieldSchema fieldSchema : schema.getFieldSchemas()) {
                    String string;
                    int n;
                    if (fieldSchema.getType().toUpperCase().contains("ARRAY<") || fieldSchema.getType().toUpperCase().contains("STRUCT<") || fieldSchema.getType().toUpperCase().contains("MAP<") || fieldSchema.getType().toUpperCase().contains("UNIONTYPE<")) {
                        n = 12;
                        string = fieldSchema.getType().toUpperCase();
                    } else if (fieldSchema.getType().toUpperCase().contains("VARCHAR(")) {
                        n = 12;
                        string = fieldSchema.getType();
                    } else if (fieldSchema.getType().toUpperCase().contains("DECIMAL(")) {
                        n = 3;
                        string = fieldSchema.getType();
                    } else if (fieldSchema.getType().toUpperCase().contains("CHAR(")) {
                        n = 1;
                        string = fieldSchema.getType();
                    } else {
                        Integer n2 = s_hiveToSqlTypeMap.get(fieldSchema.getType());
                        n = null != n2 ? (int)n2.shortValue() : 12;
                        string = "";
                    }
                    arrayList.add(DataTypeUtilities.createColumn(((HiveJDBCCommonDriver)DSIDriverSingleton.getInstance()).getCatalogName(), null, null, fieldSchema.getName(), null, (short)n, string.toUpperCase(), 1, Nullable.NULLABLE.getIntValue(), this.m_settings));
                }
            }
            return arrayList;
        }
        catch (Exception exception) {
            throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_METADATA_RESULTSET_ERR.name(), "Metadata Result Set Error");
        }
    }

    @Override
    public short getStringColumnSize() {
        return this.m_settings.m_stringColumnSize;
    }

    public ArrayList<String> getSchemas() throws ErrorException {
        ArrayList<String> arrayList = new ArrayList<String>();
        HS1Client hS1Client = this;
        synchronized (hS1Client) {
            try {
                HiveExecutionContext hiveExecutionContext = this.executeStatement("SHOW DATABASES", null);
                RowsetBuffer<HS1Buffer> rowsetBuffer = this.makeRowsetBuffer(hiveExecutionContext);
                do {
                    this.fetchNRows((HiveOperationContext)hiveExecutionContext, rowsetBuffer, this.m_settings.m_rowsFetchedPerBlock);
                    this.checkFetchErrors((RowsetBuffer)rowsetBuffer);
                    if (null == rowsetBuffer.getBuffer().m_hiveServer1Buffer) continue;
                    for (String string : rowsetBuffer.getBuffer().m_hiveServer1Buffer) {
                        arrayList.add(string);
                    }
                } while (null == rowsetBuffer.getBuffer().m_hiveServer1Buffer || !rowsetBuffer.getBuffer().m_hiveServer1Buffer.isEmpty());
                this.closeOperation(hiveExecutionContext);
                Collections.sort(arrayList);
                return arrayList;
            }
            catch (Exception exception) {
                throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_METADATA_SCHEMA_ERR.name(), "Schema Metadata Error");
            }
        }
    }

    public ArrayList<HiveCommonSchemasMetadataSourceRow> getSchemas(Map<MetadataSourceColumnTag, String> map, ArrayList<String> arrayList) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        ArrayList<String> arrayList2 = this.getSchemas();
        ArrayList<HiveCommonSchemasMetadataSourceRow> arrayList3 = new ArrayList<HiveCommonSchemasMetadataSourceRow>();
        for (String string : arrayList2) {
            arrayList3.add(new HiveCommonSchemasMetadataSourceRow(this.getCurrentCatalog(), string));
        }
        return arrayList3;
    }

    public ArrayList<HiveCommonTablesMetadataSourceRow> getTables(String string) throws ErrorException {
        ArrayList<HiveCommonTablesMetadataSourceRow> arrayList = new ArrayList<HiveCommonTablesMetadataSourceRow>();
        if (string == null || "".equals(string)) {
            string = this.getCurrentSchema();
        }
        HS1Client hS1Client = this;
        synchronized (hS1Client) {
            try {
                HiveExecutionContext hiveExecutionContext = this.executeStatement("SHOW TABLES IN " + string, null);
                RowsetBuffer<HS1Buffer> rowsetBuffer = this.makeRowsetBuffer(hiveExecutionContext);
                do {
                    this.fetchNRows((HiveOperationContext)hiveExecutionContext, rowsetBuffer, this.m_settings.m_rowsFetchedPerBlock);
                    this.checkFetchErrors((RowsetBuffer)rowsetBuffer);
                    if (null == rowsetBuffer.getBuffer().m_hiveServer1Buffer) continue;
                    for (String string2 : rowsetBuffer.getBuffer().m_hiveServer1Buffer) {
                        arrayList.add(new HiveCommonTablesMetadataSourceRow(this.getCurrentCatalog(), string, string2, "TABLE", null));
                    }
                } while (null == rowsetBuffer.getBuffer().m_hiveServer1Buffer || !rowsetBuffer.getBuffer().m_hiveServer1Buffer.isEmpty());
                this.closeOperation(hiveExecutionContext);
                return arrayList;
            }
            catch (Exception exception) {
                throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_METADATA_TABLE_ERR.name(), "Table Metadata Error");
            }
        }
    }

    public ArrayList<HiveCommonTablesMetadataSourceRow> getTables(Map<MetadataSourceColumnTag, String> map, ArrayList<String> arrayList) throws ErrorException {
        return null;
    }

    @Override
    public ArrayList<HiveCommonTablesMetadataSourceRow> getTables(String string, String string2) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.getTables(string2);
    }

    public HiveJDBCPlaceholderTable getTable(String string, String string2, String string3) throws ErrorException {
        ArrayList<HiveCommonColumnMetadata> arrayList;
        if (string != null && !string.equalsIgnoreCase(this.m_settings.m_platformCatalog)) {
            return null;
        }
        if (string2 == null || string2.equals("")) {
            string2 = this.getCurrentSchema();
        }
        if (null == (arrayList = this.getColumns(string2, string3)) || arrayList.isEmpty()) {
            return null;
        }
        return new HiveJDBCPlaceholderTable(arrayList);
    }

    @Override
    public boolean getData(int n, long l, long l2, DataWrapper dataWrapper, HiveExecutionContext hiveExecutionContext, CurrentBufferContext currentBufferContext) throws ErrorException {
        short s = currentBufferContext.m_columnTypes[n];
        return currentBufferContext.m_currentBuffer.getBuffer().getData(n, l, l2, dataWrapper, currentBufferContext.m_currentRowInBuffer, s, this.currentProcessingQuery, this.m_settings);
    }

    @Override
    public IWarningListener getWarningListener() {
        return this.m_warningListener;
    }

    @Override
    public RowsetBuffer<HS1Buffer> makeRowsetBuffer(HiveOperationContext hiveOperationContext) {
        return new RowsetBuffer<HS1Buffer>(new HS1Buffer());
    }

    @Override
    public boolean isMultiCatalogEnabled() {
        return false;
    }

    public boolean IsSupportPrimaryKeysForeignKeys() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return false;
    }

    @Override
    public boolean isSwitchRestrict() {
        return this.m_settings.m_switchCataANDSchema;
    }

    @Override
    public void setCurrentCatalog(String string) throws ErrorException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCurrentSchema(String string) {
        HiveJDBCSettings hiveJDBCSettings = this.m_settings;
        synchronized (hiveJDBCSettings) {
            this.m_settings.m_Schema = string;
        }
    }

    @Override
    public void setWarningListener(IWarningListener iWarningListener) {
        this.m_warningListener = iWarningListener;
    }

    @Override
    protected TProtocol getProtocol() {
        return this.m_client.getOutputProtocol();
    }

    private HiveExecutionContext executeStatementInternal(String string) throws ErrorException {
        try {
            this.currentProcessingQuery = string;
            this.m_client.execute(string);
            HiveExecutionContext hiveExecutionContext = new HiveExecutionContext(this.m_settings);
            hiveExecutionContext.m_isExecutionComplete = true;
            hiveExecutionContext.m_operation = this.currentProcessingQuery;
            return hiveExecutionContext;
        }
        catch (Exception exception) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_QUERY_EXE_ERR_GENERAL.name(), new String[]{exception.getMessage(), "HY000", string});
            errorException.initCause(exception);
            throw errorException;
        }
    }

    private ArrayList<HiveCommonColumnMetadata> getResultSetMetadataForHiveVersion_9(HiveExecutionContext hiveExecutionContext, String string, String string2) throws ErrorException {
        try {
            Schema schema = this.m_client.getSchema();
            ArrayList<HiveCommonColumnMetadata> arrayList = new ArrayList<HiveCommonColumnMetadata>(schema.getFieldSchemasSize());
            if (null != schema.getFieldSchemas()) {
                for (FieldSchema fieldSchema : schema.getFieldSchemas()) {
                    String string3;
                    short s;
                    if (fieldSchema.getType().toUpperCase().contains("VARCHAR(")) {
                        s = 12;
                        string3 = fieldSchema.getType();
                    } else {
                        s = s_hiveToSqlTypeMap.get(fieldSchema.getType()).shortValue();
                        string3 = "";
                    }
                    arrayList.add(DataTypeUtilities.createColumn(((HiveJDBCCommonDriver)DSIDriverSingleton.getInstance()).getCatalogName(), string, string2, fieldSchema.getName(), null, s, string3, 1, Nullable.NULLABLE.getIntValue(), this.m_settings));
                }
            }
            return arrayList;
        }
        catch (Exception exception) {
            throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_METADATA_RESULTSET_ERR.name(), "Metadata Result Set Error");
        }
    }

    private void openSession() throws ErrorException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "";
        boolean bl = false;
        try {
            HiveExecutionContext hiveExecutionContext = null;
            try {
                hiveExecutionContext = this.executeStatement("SET -v", null);
                bl = true;
            }
            catch (Exception exception) {
                bl = false;
                throw exception;
            }
            RowsetBuffer<HS1Buffer> rowsetBuffer = this.makeRowsetBuffer(hiveExecutionContext);
            do {
                this.fetchNRows((HiveOperationContext)hiveExecutionContext, rowsetBuffer, this.m_settings.m_rowsFetchedPerBlock);
                this.checkFetchErrors((RowsetBuffer)rowsetBuffer);
                if (null == rowsetBuffer.getBuffer().m_hiveServer1Buffer) continue;
                for (String string2 : rowsetBuffer.getBuffer().m_hiveServer1Buffer) {
                    arrayList.add(string2);
                }
            } while (null == rowsetBuffer.getBuffer().m_hiveServer1Buffer || !rowsetBuffer.getBuffer().m_hiveServer1Buffer.isEmpty());
            String[] stringArray = new String[]{".*hive-exec-(\\d+\\.\\d+\\.\\d+).*", ".*hive-service-(\\d+\\.\\d+\\.\\d+).*", ".*hive-common-(\\d+\\.\\d+\\.\\d+).*", ".*hive-hwi-(\\d+\\.\\d+\\.\\d+).*"};
            block6: for (int i = 0; i < arrayList.size(); ++i) {
                for (int j = 0; j < stringArray.length; ++j) {
                    Pattern pattern = Pattern.compile(stringArray[j]);
                    Matcher matcher = pattern.matcher((CharSequence)arrayList.get(i));
                    if (!matcher.find()) continue;
                    string = matcher.group(1);
                    continue block6;
                }
            }
            this.m_settings.m_isConnAlive = true;
            this.m_settings.m_serverVersion = this.m_settings.m_platformVersionUtils.parseServerVersion(string, this.m_logger);
            this.dbmdInfo = new DatabaseMetadataInfo("Apache Hive", string);
            this.closeOperation(hiveExecutionContext);
        }
        catch (Exception exception) {
            if (!bl && null != exception.getCause() && exception.getCause() instanceof TTransportException && exception.getCause().getCause() instanceof SocketTimeoutException) {
                throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_HS1_CLIENT_SOCKET_ERR.name());
            }
            throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_SESSION_ERR.name(), "Server version error");
        }
    }

    @Override
    public void removeOperationHandleFromHeartbeatThread(HiveOperationContext hiveOperationContext) throws ErrorException {
    }

    @Override
    public List<String> getQueryLog(HiveOperationContext hiveOperationContext, boolean bl, int n) throws ErrorException {
        return Collections.emptyList();
    }

    @Override
    public boolean hasMoreLogs(HiveOperationContext hiveOperationContext) {
        return false;
    }

    @Override
    public HiveExecutionContext executeStatement(String string, IExecutorUtility iExecutorUtility, HiveJDBCStatement hiveJDBCStatement) throws ErrorException {
        return null;
    }

    @Override
    public ArrayList<String> getCatalogs(HiveJDBCStatement hiveJDBCStatement) throws ErrorException {
        return null;
    }

    @Override
    public ArrayList<HiveCommonSchemasMetadataSourceRow> getSchemas(Map<MetadataSourceColumnTag, String> map, ArrayList<String> arrayList, HiveJDBCStatement hiveJDBCStatement) throws ErrorException {
        return null;
    }

    @Override
    public ArrayList<HiveCommonTablesMetadataSourceRow> getTables(Map<MetadataSourceColumnTag, String> map, ArrayList<String> arrayList, HiveJDBCStatement hiveJDBCStatement) throws ErrorException {
        return null;
    }

    @Override
    public ArrayList<HiveCommonColumnMetadata> getColumns(String string, String string2, String string3, HiveJDBCStatement hiveJDBCStatement) throws ErrorException {
        return null;
    }

    @Override
    public ArrayList<HiveCommonColumnMetadata> getColumns(Map<MetadataSourceColumnTag, String> map, ArrayList<String> arrayList, HiveJDBCStatement hiveJDBCStatement) throws Exception {
        return null;
    }

    @Override
    public ArrayList<HiveCommonFunctionsMetadataSourceRow> getFunctions(Map<MetadataSourceColumnTag, String> map, ArrayList<String> arrayList, HiveJDBCStatement hiveJDBCStatement) throws ErrorException {
        return null;
    }

    @Override
    public HiveJDBCPlaceholderTable getTable(String string, String string2, String string3, HiveJDBCStatement hiveJDBCStatement) throws ErrorException {
        return null;
    }

    static {
        s_hiveToSqlTypeMap.put("void", 12);
        s_hiveToSqlTypeMap.put("string", 12);
        s_hiveToSqlTypeMap.put("boolean", 16);
        s_hiveToSqlTypeMap.put("double", 8);
        s_hiveToSqlTypeMap.put("float", 7);
        s_hiveToSqlTypeMap.put("tinyint", -6);
        s_hiveToSqlTypeMap.put("smallint", 5);
        s_hiveToSqlTypeMap.put("int", 4);
        s_hiveToSqlTypeMap.put("bigint", -5);
        s_hiveToSqlTypeMap.put("timestamp", 93);
        s_hiveToSqlTypeMap.put("binary", -3);
        s_hiveToSqlTypeMap.put("decimal", 3);
        s_hiveToSqlTypeMap.put("date", 91);
    }
}

