/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.hivecommon;

import com.cloudera.hiveserver1.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.hiveserver1.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;

public enum AuthMech {
    NOAUTH(0),
    SASL_KERBEROS(1),
    SASL_PLAIN_UID(2),
    UIDPWD(3),
    SASL_PLAIN_UIDPWD_SSL(4),
    NOAUTH_SSL(5),
    DELEGATION_TOKEN(6),
    OAUTH_CLIENT_CREDENTIALS(7),
    OAUTH_2(11),
    SAML_2_0(12),
    MAPRSASL(13),
    JWT(14);

    private int mechVal;

    private AuthMech(int n2) {
        this.mechVal = n2;
    }

    public static AuthMech getAuthMech(int n) {
        for (AuthMech authMech : AuthMech.values()) {
            if (authMech.getAuthMechValue() != n) continue;
            return authMech;
        }
        return null;
    }

    public int getAuthMechValue() {
        return this.mechVal;
    }

    public String getDisplayName() throws ErrorException {
        AuthMech authMech = AuthMech.getAuthMech(this.mechVal);
        if (authMech != null) {
            switch (authMech) {
                case SAML_2_0: {
                    return "SAML 2.0";
                }
            }
            return this.toString();
        }
        String string = "Invalid Authentication mechanism value specified - " + this.mechVal;
        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.UNSUPPORTED_AUTH_MECH_ERR.name(), string);
        throw errorException;
    }
}

