/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.jdbc.http.extention;

import com.cloudera.hive.jdbc42.internal.apache.http.conn.ssl.SSLConnectionSocketFactory;
import com.cloudera.hive.jdbc42.internal.apache.http.protocol.HttpContext;
import com.cloudera.hiveserver1.support.ILogger;
import com.cloudera.hiveserver1.support.LogUtilities;
import java.io.IOException;
import java.net.Socket;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;

public class ExtentedSSLConnectionSocketFactory
extends SSLConnectionSocketFactory {
    private SocketFactory m_socketFactory;
    private ILogger m_logger;

    public ExtentedSSLConnectionSocketFactory(SSLContext sSLContext, ILogger iLogger) {
        super(sSLContext);
        LogUtilities.logFunctionEntrance(iLogger, sSLContext);
        this.m_logger = iLogger;
    }

    public ExtentedSSLConnectionSocketFactory(SSLContext sSLContext, HostnameVerifier hostnameVerifier, ILogger iLogger) {
        super(sSLContext, hostnameVerifier);
        LogUtilities.logFunctionEntrance(iLogger, sSLContext);
        this.m_logger = iLogger;
    }

    public ExtentedSSLConnectionSocketFactory(SSLContext sSLContext, SocketFactory socketFactory, ILogger iLogger) {
        super(sSLContext);
        LogUtilities.logFunctionEntrance(iLogger, sSLContext, socketFactory);
        this.m_logger = iLogger;
        this.m_socketFactory = socketFactory;
    }

    public ExtentedSSLConnectionSocketFactory(SSLContext sSLContext, HostnameVerifier hostnameVerifier, SocketFactory socketFactory, ILogger iLogger) {
        super(sSLContext, hostnameVerifier);
        LogUtilities.logFunctionEntrance(iLogger, sSLContext, hostnameVerifier, socketFactory);
        this.m_logger = iLogger;
        this.m_socketFactory = socketFactory;
    }

    @Override
    public Socket createSocket(HttpContext httpContext) throws IOException {
        LogUtilities.logFunctionEntrance(this.m_logger, httpContext);
        return this.m_socketFactory.createSocket();
    }
}

