/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.value;

import com.cloudera.hiveserver1.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.ColumnMetadata;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.Nullable;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.TypeMetadata;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.AEQColumnName;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.AEQTableName;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.IAENode;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.metadatautil.MetadataUtilities;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;

public abstract class AEValueExpr
implements IAENode {
    private IAENode m_parent = null;

    protected AEValueExpr() {
    }

    protected AEValueExpr(AEValueExpr aEValueExpr) {
    }

    public abstract IColumn getColumn();

    @Override
    public IAENode getParent() {
        return this.m_parent;
    }

    @Override
    public void setParent(IAENode iAENode) {
        this.m_parent = iAENode;
    }

    @Override
    public abstract AEValueExpr copy();

    public String getCatalogName() {
        return this.getColumn().getCatalogName();
    }

    public String getLabel() {
        return this.getColumn().getLabel();
    }

    public String getName() {
        return this.getColumn().getName();
    }

    public Nullable getNullable() {
        return this.getColumn().getNullable();
    }

    public AEQColumnName getQColumnName() {
        return new AEQColumnName(new AEQTableName(this.getCatalogName(), this.getSchemaName(), this.getTableName()), this.getName());
    }

    public String getSchemaName() {
        return this.getColumn().getSchemaName();
    }

    public String getTableName() {
        return this.getColumn().getTableName();
    }

    public TypeMetadata getTypeMetadata() {
        return this.getColumn().getTypeMetadata();
    }

    public boolean isSortable() {
        return this.getColumn().getTypeMetadata().isSortable();
    }

    public boolean isUnnamed() {
        return this.getColumn().isUnnamed();
    }

    public boolean matchesName(AEQColumnName aEQColumnName, boolean bl) {
        if (null == this.getName() || "".equals(this.getName()) || !AEValueExpr.stringEquals(this.getName(), aEQColumnName.getColName(), bl)) {
            return false;
        }
        if (!"".equals(aEQColumnName.getTableName()) && !AEValueExpr.stringEquals(this.getTableName(), aEQColumnName.getTableName(), bl)) {
            return false;
        }
        if (!"".equals(aEQColumnName.getSchemaName()) && !AEValueExpr.stringEquals(this.getSchemaName(), aEQColumnName.getSchemaName(), bl)) {
            return false;
        }
        return "".equals(aEQColumnName.getCatalogName()) || AEValueExpr.stringEquals(this.getCatalogName(), aEQColumnName.getCatalogName(), bl);
    }

    public boolean matchesNameCaseInsensitive(AEQColumnName aEQColumnName) {
        return this.matchesName(aEQColumnName, false);
    }

    public boolean matchesNameCaseSensitive(AEQColumnName aEQColumnName) {
        return this.matchesName(aEQColumnName, true);
    }

    public abstract void updateColumn() throws ErrorException;

    @Override
    public String getLogString() {
        return this.getClass().getSimpleName();
    }

    public String toString() {
        return this.getLogString();
    }

    protected static ColumnMetadata createColumnMetadata() {
        return MetadataUtilities.defaultColumnMetadata();
    }

    protected static ColumnMetadata createColumnMetadata(IColumn iColumn) {
        return ColumnMetadata.copyOf(iColumn);
    }

    protected static TypeMetadata createTypeMetadata(TypeMetadata typeMetadata) {
        return TypeMetadata.copyOf(typeMetadata);
    }

    private static boolean stringEquals(String string, String string2, boolean bl) {
        return bl ? string.equals(string2) : string.equalsIgnoreCase(string2);
    }

    public static enum AEValueExprOperator {
        BINARY_PLUS,
        BINARY_MINUS,
        MULTIPLY,
        DIVIDE,
        CONCAT,
        INSERT,
        UNARY_PLUS,
        UNARY_MINUS,
        UNION,
        EXCEPT,
        INTERSECT,
        IN,
        NO_OP;

    }
}

