/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.aeprocessor.metadatautil;

import com.cloudera.hiveserver1.dsi.dataengine.utilities.ColumnMetadata;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.TypeMetadata;
import com.cloudera.hiveserver1.dsi.exceptions.NumericOverflowException;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.AEUtils;
import com.cloudera.hiveserver1.sqlengine.dsiext.dataengine.IColumnInfo;
import com.cloudera.hiveserver1.sqlengine.dsiext.dataengine.utils.ScalarFunctionArgType;
import com.cloudera.hiveserver1.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;

public class MetadataUtilities {
    private MetadataUtilities() {
        throw new UnsupportedOperationException("Not instantiable.");
    }

    public static ColumnMetadata defaultColumnMetadata() {
        try {
            TypeMetadata typeMetadata = TypeMetadata.createTypeMetadata(4);
            return new ColumnMetadata(typeMetadata);
        }
        catch (ErrorException errorException) {
            throw new RuntimeException(errorException);
        }
    }

    public static TypeMetadata createTypeMetadata(IColumnInfo iColumnInfo) throws ErrorException {
        TypeMetadata typeMetadata = TypeMetadata.createTypeMetadata(iColumnInfo.getType(), iColumnInfo.isSigned());
        typeMetadata.setPrecision(iColumnInfo.getPrecision());
        typeMetadata.setScale(iColumnInfo.getScale());
        typeMetadata.setIntervalPrecision(iColumnInfo.getIntervalPrecision());
        typeMetadata.setIsCurrency(iColumnInfo.isCurrency());
        typeMetadata.setIsSortable(iColumnInfo.isSortable());
        return typeMetadata;
    }

    public static ColumnMetadata createColumnMetadata(IColumnInfo iColumnInfo) throws ErrorException {
        TypeMetadata typeMetadata = MetadataUtilities.createTypeMetadata(iColumnInfo);
        ColumnMetadata columnMetadata = new ColumnMetadata(typeMetadata);
        columnMetadata.setAutoUnique(iColumnInfo.isAutoUnique());
        columnMetadata.setCaseSensitive(iColumnInfo.isCaseSensitive());
        try {
            columnMetadata.setColumnLength(iColumnInfo.getColumnLength());
        }
        catch (NumericOverflowException numericOverflowException) {
            throw SQLEngineExceptionFactory.numericOverflowException("Column length is too long.");
        }
        columnMetadata.setNullable(iColumnInfo.getNullable());
        columnMetadata.setSearchable(iColumnInfo.getSearchable());
        columnMetadata.setUpdatable(iColumnInfo.getUpdatable());
        return columnMetadata;
    }

    public static boolean isConversionLegal(int n, ScalarFunctionArgType scalarFunctionArgType) throws ErrorException {
        switch (scalarFunctionArgType) {
            case FN_ARG_ANY: {
                return true;
            }
            case FN_ARG_DATE: {
                return AEUtils.isAnyConversionLegal(n, 91, 93, 1, 12, -8, -9);
            }
            case FN_ARG_FLOAT: {
                return AEUtils.isAnyConversionLegal(n, 6, 7);
            }
            case FN_ARG_INTEGER: {
                return AEUtils.isAnyConversionLegal(n, 4, -6, 5, -5);
            }
            case FN_ARG_INTERVAL: {
                return AEUtils.isAnyConversionLegal(n, 103, 108, 109, 110, 104, 111, 112, 105, 113, 102, 106, 101, 107, 1, 12, -8, -9);
            }
            case FN_ARG_NUMERIC: {
                return AEUtils.isAnyConversionLegal(n, 2, 3);
            }
            case FN_ARG_SLC: {
                return AEUtils.isAnyConversionLegal(n, 2, -6, 5, 4);
            }
            case FN_ARG_STRING: {
                return AEUtils.isAnyConversionLegal(n, 1, 12, -1, -8, -9, -10);
            }
            case FN_ARG_TIME: {
                return AEUtils.isAnyConversionLegal(n, 92, 93, 1, 12, -8, -9);
            }
            case FN_ARG_TIMESTAMP: {
                return AEUtils.isAnyConversionLegal(n, 93, 92, 91, 1, 12, -8, -9);
            }
        }
        throw new IllegalArgumentException("" + n);
    }
}

