/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.dsiext.dataengine;

import com.cloudera.hiveserver1.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.ColumnMetadata;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.Nullable;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.TypeMetadata;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.TypeUtilities;
import com.cloudera.hiveserver1.dsi.exceptions.NumericOverflowException;
import com.cloudera.hiveserver1.sqlengine.dsiext.dataengine.IColumnFactory;
import com.cloudera.hiveserver1.sqlengine.dsiext.dataengine.SqlDataEngine;
import com.cloudera.hiveserver1.sqlengine.exceptions.SQLEngineException;
import com.cloudera.hiveserver1.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.hiveserver1.sqlengine.utilities.SQLEngineMessageKey;
import com.cloudera.hiveserver1.support.exceptions.DiagState;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import java.util.List;

public class DSIExtColumnFactory
implements IColumnFactory {
    private SqlDataEngine m_dataEngine;

    public DSIExtColumnFactory(SqlDataEngine sqlDataEngine) {
        this.m_dataEngine = sqlDataEngine;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public IColumn createColumn(String string, String string2, String string3, String string4, String string5, List<String> list, Nullable nullable) throws ErrorException {
        Integer n = this.m_dataEngine.getContext().getSqlTypeForTypeName(string5);
        if (n == 0 && null == (n = TypeUtilities.getTypeForSqlTypeString(string5))) {
            throw new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.INVALID_SQL_TYPE_SPECIFIED.name(), new String[]{string5});
        }
        TypeMetadata typeMetadata = TypeMetadata.createTypeMetadata(n);
        ColumnMetadata columnMetadata = new ColumnMetadata(typeMetadata);
        columnMetadata.setName(string4);
        columnMetadata.setSchemaName(string2);
        columnMetadata.setCatalogName(string);
        columnMetadata.setLabel(string4);
        columnMetadata.setNullable(nullable);
        if (typeMetadata.isCharacterOrBinaryType()) {
            if (list.size() > 1) {
                throw new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.INVALID_TYPE_PARAMS.name(), new String[]{string5});
            }
            if (list.size() != 1) return columnMetadata;
            try {
                long l = Long.parseLong(list.get(0));
                columnMetadata.setColumnLength(l);
                return columnMetadata;
            }
            catch (NumberFormatException numberFormatException) {
                throw SQLEngineExceptionFactory.invalidTypeParameterException(string5);
            }
            catch (NumericOverflowException numericOverflowException) {
                throw SQLEngineExceptionFactory.invalidTypeParameterException(string5);
            }
        } else if (n == 92 || n == 93) {
            if (list.size() > 1) {
                SQLEngineExceptionFactory.invalidTypeParameterException(string5);
            }
            if (list.size() != 1) return columnMetadata;
            try {
                short s = Short.parseShort(list.get(0));
                typeMetadata.setPrecision(s);
                return columnMetadata;
            }
            catch (NumberFormatException numberFormatException) {
                throw SQLEngineExceptionFactory.invalidTypeParameterException(string5);
            }
        } else if (typeMetadata.isExactNumericType()) {
            if (list.size() > 2) {
                throw SQLEngineExceptionFactory.invalidTypeParameterException(string5);
            }
            try {
                if (list.size() > 1) {
                    short s = Short.parseShort(list.get(0));
                    typeMetadata.setPrecision(s);
                    short s2 = Short.parseShort(list.get(1));
                    typeMetadata.setScale(s2);
                    return columnMetadata;
                }
                if (list.size() <= 0) return columnMetadata;
                short s = Short.parseShort(list.get(0));
                typeMetadata.setPrecision(s);
                return columnMetadata;
            }
            catch (NumberFormatException numberFormatException) {
                throw SQLEngineExceptionFactory.invalidTypeParameterException(string5);
            }
        } else {
            if (list.size() == 0) return columnMetadata;
            throw SQLEngineExceptionFactory.invalidTypeParameterException(string5);
        }
    }
}

