/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.executor.etree;

import com.cloudera.hiveserver1.sqlengine.executor.etree.IETResource;
import com.cloudera.hiveserver1.support.ILogger;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import java.util.LinkedList;
import java.util.List;

public class ETResourceManager {
    private static final String PACKAGE_NAME = "com.cloudera.sqlengine.executor.etree";
    private static final String CLASS_NAME = "ETResourceManager";
    private List<IETResource> m_resources = new LinkedList<IETResource>();
    private boolean m_allocated = false;
    private ILogger m_logger;

    public ETResourceManager(ILogger iLogger) {
        this.m_logger = iLogger;
    }

    public void registerResource(IETResource iETResource) throws ErrorException {
        if (this.m_allocated) {
            iETResource.allocate();
        }
        this.m_resources.add(iETResource);
    }

    public void allocate() throws ErrorException {
        for (IETResource iETResource : this.m_resources) {
            iETResource.allocate();
        }
        this.m_allocated = true;
    }

    public void free() {
        for (IETResource iETResource : this.m_resources) {
            try {
                iETResource.free();
            }
            catch (ErrorException errorException) {
                if (this.m_logger == null) continue;
                this.m_logger.logError(PACKAGE_NAME, CLASS_NAME, "free", errorException);
            }
            catch (Exception exception) {
                if (this.m_logger == null) continue;
                this.m_logger.logError(PACKAGE_NAME, CLASS_NAME, "free", exception.getLocalizedMessage());
            }
            catch (Error error) {
                if (this.m_logger == null) continue;
                this.m_logger.logError(PACKAGE_NAME, CLASS_NAME, "free", error.getLocalizedMessage());
            }
        }
        this.m_allocated = false;
    }
}

