/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.executor.etree.relation;

import com.cloudera.hiveserver1.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.CursorType;
import com.cloudera.hiveserver1.sqlengine.executor.etree.ETDataRequest;
import com.cloudera.hiveserver1.sqlengine.executor.etree.IETNode;
import com.cloudera.hiveserver1.sqlengine.executor.etree.IETNodeVisitor;
import com.cloudera.hiveserver1.sqlengine.executor.etree.IMemManagerAgent;
import com.cloudera.hiveserver1.sqlengine.executor.etree.IMemoryConsumer;
import com.cloudera.hiveserver1.sqlengine.executor.etree.hash.HashAggrPartition;
import com.cloudera.hiveserver1.sqlengine.executor.etree.hash.HashAggrPartitionManager;
import com.cloudera.hiveserver1.sqlengine.executor.etree.hash.HashPartitionProperties;
import com.cloudera.hiveserver1.sqlengine.executor.etree.relation.ETAggregate;
import com.cloudera.hiveserver1.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.cloudera.hiveserver1.sqlengine.executor.etree.relation.join.RelationalRowBlock;
import com.cloudera.hiveserver1.sqlengine.executor.etree.temptable.DataStore;
import com.cloudera.hiveserver1.sqlengine.executor.etree.temptable.IRowBlock;
import com.cloudera.hiveserver1.sqlengine.executor.etree.temptable.IRowView;
import com.cloudera.hiveserver1.sqlengine.executor.etree.temptable.TemporaryFile;
import com.cloudera.hiveserver1.sqlengine.executor.etree.temptable.column.ColumnSizeCalculator;
import com.cloudera.hiveserver1.sqlengine.executor.etree.value.aggregatefn.IAggregator;
import com.cloudera.hiveserver1.sqlengine.executor.etree.value.aggregatefn.IAggregatorFactory;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ETHashAggregate
extends ETAggregate
implements IMemoryConsumer {
    private static long PARTITION_SIZE_HINT = 8192L;
    private static int MAX_RECURSION = 1;
    private LinkedList<FetchState> m_fetchStates = new LinkedList();
    private HashPartitionProperties m_properties;
    private AggregateProjectionInfo m_aggregateProjection;
    private OperandProjectionInfo m_operandProjection;
    private IColumn[] m_scalarMeta;
    private TemporaryFile m_longDataStore;
    private boolean[] m_longDataColumns;
    private long m_allocatedMemory = 10000000L;

    public ETHashAggregate(ETRelationalExpr eTRelationalExpr, HashPartitionProperties hashPartitionProperties) {
        super(ETHashAggregate.extractDataNeeded(eTRelationalExpr.getColumnCount()), eTRelationalExpr);
        this.m_properties = hashPartitionProperties;
        this.m_aggregateProjection = hashPartitionProperties.getAggregateProjection();
        this.m_operandProjection = hashPartitionProperties.getOperandProjection();
        this.m_longDataColumns = new boolean[this.m_operandProjection.getNumColumns()];
        for (int i = 0; i < this.m_longDataColumns.length; ++i) {
            this.m_longDataColumns[i] = ColumnSizeCalculator.isLongData(this.m_operandProjection.getMetadata()[i], hashPartitionProperties.getMaxDataLen());
        }
        int[] nArray = this.m_operandProjection.getScalarValueColumns();
        this.m_scalarMeta = new IColumn[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            this.m_scalarMeta[i] = this.m_operandProjection.getMetadata()[nArray[i]];
        }
    }

    @Override
    public <T> T acceptVisitor(IETNodeVisitor<T> iETNodeVisitor) throws ErrorException {
        return iETNodeVisitor.visit(this);
    }

    @Override
    public IColumn getColumn(int n) {
        return this.m_aggregateProjection.getColumnMetadata()[n];
    }

    @Override
    public int getColumnCount() {
        return this.m_aggregateProjection.getNumColumns();
    }

    @Override
    public long getRowCount() throws ErrorException {
        return -1L;
    }

    @Override
    public void open(CursorType cursorType) throws ErrorException {
        this.getOperand().open(cursorType);
        this.m_fetchStates.clear();
        if (null != this.m_longDataStore) {
            this.m_longDataStore.destroy();
        }
        for (boolean bl : this.m_longDataColumns) {
            if (!bl) continue;
            this.m_longDataStore = new TemporaryFile(this.m_properties.getStorageDir(), this.m_properties.getLogger());
            break;
        }
        int n = this.calculateNumPartitions(this.m_allocatedMemory);
        FetchState fetchState = new FetchState(new HashAggrPartitionManager(n, this.m_longDataStore, this.m_longDataColumns, this.m_properties, this.m_dataNeeded));
        fetchState.m_inputRows = this.getOperandRows();
        this.m_fetchStates.add(fetchState);
    }

    @Override
    public void close(boolean bl) {
        this.getOperand().close(bl);
        if (null != this.m_longDataStore) {
            this.m_longDataStore.destroy();
            this.m_longDataStore = null;
        }
    }

    @Override
    public int getNumChildren() {
        return 1;
    }

    @Override
    protected IETNode getChild(int n) throws IndexOutOfBoundsException {
        if (0 == n) {
            return this.getOperand();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public boolean retrieveData(int n, ETDataRequest eTDataRequest) throws ErrorException {
        FetchState fetchState = this.m_fetchStates.peek();
        HashAggrPartition hashAggrPartition = fetchState.m_partitions.getPartition(fetchState.m_currentPartition);
        if (this.m_aggregateProjection.isAggregateFnColumn(n)) {
            n = this.m_aggregateProjection.mapColumnToAggregateIndex(n);
            return hashAggrPartition.retrieveAggregate(n, eTDataRequest);
        }
        n = this.m_aggregateProjection.mapToOperandColumn(n);
        return hashAggrPartition.retrieveScalar(n, eTDataRequest);
    }

    @Override
    protected boolean doMove() throws ErrorException {
        while (!this.m_fetchStates.isEmpty()) {
            HashAggrPartition hashAggrPartition;
            if (this.m_fetchStates.size() - 1 > MAX_RECURSION) assert (false) : "Max recursion";
            FetchState fetchState = this.m_fetchStates.peek();
            if (null != fetchState.m_spilledPartials) {
                this.addPartials(fetchState, fetchState.m_spilledPartials);
                fetchState.m_spilledPartials = null;
            }
            if (null != fetchState.m_inputRows) {
                this.scanRows(fetchState, fetchState.m_inputRows);
                fetchState.m_inputRows = null;
            }
            if (fetchState.m_inMemoryFetch) {
                int n = fetchState.m_partitions.getNumPartitions();
                while (fetchState.m_currentPartition < n) {
                    hashAggrPartition = fetchState.m_partitions.getPartition(fetchState.m_currentPartition);
                    if (!hashAggrPartition.isFinishedRetrieving() && hashAggrPartition.moveToNextRow()) {
                        return true;
                    }
                    ++fetchState.m_currentPartition;
                }
                fetchState.m_currentPartition = 0;
                fetchState.m_inMemoryFetch = false;
                fetchState.m_memoryUsage = 0L;
                fetchState.m_spillCandidates.clear();
            }
            FetchState fetchState2 = null;
            while (fetchState.m_currentPartition < fetchState.m_partitions.getNumPartitions()) {
                if (!(hashAggrPartition = fetchState.m_partitions.getPartition(fetchState.m_currentPartition++)).hasFlushedRows()) continue;
                fetchState2 = this.transferResults(hashAggrPartition);
                break;
            }
            if (null != fetchState2) {
                this.m_fetchStates.add(fetchState2);
                continue;
            }
            this.m_fetchStates.poll();
        }
        return false;
    }

    private void addPartials(FetchState fetchState, DataStore dataStore) throws ErrorException {
        dataStore.giveBlock();
        while (dataStore.moveToNextRow()) {
            int n = fetchState.m_partitions.partition(dataStore);
            HashAggrPartition hashAggrPartition = fetchState.m_partitions.getPartition(n);
            long l = hashAggrPartition.getMemoryUsage();
            hashAggrPartition.addPartialAggregation(dataStore);
            long l2 = hashAggrPartition.getMemoryUsage();
            if (l2 > this.m_allocatedMemory / (long)fetchState.m_partitions.getNumPartitions()) {
                fetchState.m_spillCandidates.add(n);
            }
            fetchState.m_memoryUsage += l2 - l;
            long l3 = this.m_allocatedMemory / (long)fetchState.m_partitions.getNumPartitions();
            while (fetchState.m_memoryUsage - this.m_allocatedMemory >= l3 && this.spillPartition(fetchState)) {
            }
        }
        dataStore.destroy();
    }

    private int calculateNumPartitions(long l) {
        int n = (int)(l / PARTITION_SIZE_HINT);
        n = Integer.highestOneBit(Math.max(n, 1));
        return n;
    }

    private IRowBlock getOperandRows() throws ErrorException {
        return new RelationalRowBlock(this.getOperand(), this.m_longDataStore, this.m_properties.getMaxDataLen(), this.m_dataNeeded);
    }

    private void scanRows(FetchState fetchState, IRowBlock iRowBlock) throws ErrorException {
        while (iRowBlock.moveToNextRow()) {
            int n = fetchState.m_partitions.partition(iRowBlock);
            this.updatePartition(fetchState, n, iRowBlock);
        }
    }

    private boolean spillPartition(FetchState fetchState) throws ErrorException {
        Iterator<Integer> iterator = fetchState.m_spillCandidates.iterator();
        if (iterator.hasNext()) {
            Integer n = iterator.next();
            HashAggrPartition hashAggrPartition = fetchState.m_partitions.getPartition(n);
            long l = hashAggrPartition.getMemoryUsage();
            int n2 = 1 == fetchState.m_spillCandidates.size() ? 1 : 0;
            hashAggrPartition.spillPartialRows(Math.min(PARTITION_SIZE_HINT, this.m_allocatedMemory / (long)fetchState.m_partitions.getNumPartitions()), n2);
            long l2 = hashAggrPartition.getMemoryUsage();
            if (l2 <= this.m_allocatedMemory / (long)fetchState.m_partitions.getNumPartitions()) {
                iterator.remove();
            }
            fetchState.m_memoryUsage -= l - l2;
            return true;
        }
        return false;
    }

    private FetchState transferResults(HashAggrPartition hashAggrPartition) throws ErrorException {
        HashAggrPartitionManager hashAggrPartitionManager = new HashAggrPartitionManager(this.m_fetchStates.peek().m_partitions.getNumPartitions(), this.m_longDataStore, this.m_longDataColumns, this.m_properties, this.m_dataNeeded);
        FetchState fetchState = new FetchState(hashAggrPartitionManager);
        fetchState.m_spilledPartials = hashAggrPartition.unspillPartial();
        fetchState.m_inputRows = hashAggrPartition.unspillInputRows();
        return fetchState;
    }

    private void updatePartition(FetchState fetchState, int n, IRowView iRowView) throws ErrorException {
        HashAggrPartition hashAggrPartition = fetchState.m_partitions.getPartition(n);
        long l = hashAggrPartition.getMemoryUsage();
        hashAggrPartition.update(iRowView);
        long l2 = hashAggrPartition.getMemoryUsage();
        if (l2 > this.m_allocatedMemory / (long)fetchState.m_partitions.getNumPartitions()) {
            fetchState.m_spillCandidates.add(n);
        }
        fetchState.m_memoryUsage += l2 - l;
        long l3 = this.m_allocatedMemory / (long)fetchState.m_partitions.getNumPartitions();
        while (fetchState.m_memoryUsage - this.m_allocatedMemory >= l3 && this.spillPartition(fetchState)) {
        }
    }

    private static boolean[] extractDataNeeded(int n) {
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            blArray[i] = true;
        }
        return blArray;
    }

    @Override
    public void registerManagerAgent(IMemManagerAgent iMemManagerAgent) {
    }

    @Override
    public long assign(long l) {
        return 0L;
    }

    @Override
    public long getRequiredMemory() {
        return 0L;
    }

    public static class OperandProjectionInfo {
        private IColumn[] m_metadata;
        private int[] m_scalarValueColumns;
        private int[] m_groupingColumns;

        public OperandProjectionInfo(IColumn[] iColumnArray, int[] nArray, int[] nArray2) {
            this.m_metadata = iColumnArray;
            this.m_scalarValueColumns = nArray;
            this.m_groupingColumns = nArray2;
        }

        public int getNumColumns() {
            return this.m_metadata.length;
        }

        public int[] getScalarValueColumns() {
            return this.m_scalarValueColumns;
        }

        public IColumn[] getMetadata() {
            return this.m_metadata;
        }

        public int[] getGroupingColumns() {
            return this.m_groupingColumns;
        }
    }

    private static class FetchState {
        public HashAggrPartitionManager m_partitions;
        public long m_memoryUsage;
        public int m_currentPartition;
        public boolean m_inMemoryFetch;
        public DataStore m_spilledPartials;
        public IRowBlock m_inputRows;
        public HashSet<Integer> m_spillCandidates;

        public FetchState(HashAggrPartitionManager hashAggrPartitionManager) {
            this.m_partitions = hashAggrPartitionManager;
            this.m_currentPartition = 0;
            this.m_inMemoryFetch = true;
            this.m_memoryUsage = 0L;
            this.m_spilledPartials = null;
            this.m_inputRows = null;
            this.m_spillCandidates = new HashSet();
        }
    }

    public static class AggregateProjectionInfo {
        private int m_numColumns;
        private IColumn[] m_columnMetadata;
        private int[] m_aggregateFnColumns;
        private int[] m_aggregateFnIndexMap;
        private List<int[]> m_aggregateFnArguments;
        private List<IColumn[]> m_aggregateFnArgumentMetadata;
        private IAggregatorFactory[] m_aggregatorFactories;
        private int[] m_operandColumnMap;

        public AggregateProjectionInfo(int n, IColumn[] iColumnArray, int[] nArray, int[] nArray2, List<int[]> list, List<IColumn[]> list2, IAggregatorFactory[] iAggregatorFactoryArray) {
            this.m_numColumns = n;
            this.m_columnMetadata = iColumnArray;
            this.m_operandColumnMap = nArray;
            this.m_aggregateFnColumns = nArray2;
            this.m_aggregateFnArguments = list;
            this.m_aggregateFnArgumentMetadata = list2;
            this.m_aggregatorFactories = iAggregatorFactoryArray;
            this.m_aggregateFnIndexMap = new int[n];
            Arrays.fill(this.m_aggregateFnIndexMap, -1);
            for (int i = 0; i < nArray2.length; ++i) {
                this.m_aggregateFnIndexMap[nArray2[i]] = i;
            }
        }

        public int getNumColumns() {
            return this.m_numColumns;
        }

        public IColumn[] getColumnMetadata() {
            return this.m_columnMetadata;
        }

        public int[] getAggregateFnColumns() {
            return this.m_aggregateFnColumns;
        }

        public boolean isAggregateFnColumn(int n) {
            return 0 <= this.m_aggregateFnIndexMap[n];
        }

        public int mapColumnToAggregateIndex(int n) {
            assert (this.isAggregateFnColumn(n)) : "" + n;
            return this.m_aggregateFnIndexMap[n];
        }

        public IAggregator createAggregator(int n) throws ErrorException {
            return this.m_aggregatorFactories[n].createAggregator();
        }

        public IColumn getAggregateFnMetadata(int n) {
            return this.m_columnMetadata[this.m_aggregateFnColumns[n]];
        }

        public int[] getAggregateFnArguments(int n) {
            return this.m_aggregateFnArguments.get(n);
        }

        public IColumn[] getAggregateFnArgumentMetadata(int n) {
            return this.m_aggregateFnArgumentMetadata.get(n);
        }

        public int mapToOperandColumn(int n) {
            assert (!this.isAggregateFnColumn(n)) : "" + n;
            return this.m_operandColumnMap[n];
        }
    }
}

