/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.executor.etree.temptable.column;

import com.cloudera.hiveserver1.sqlengine.executor.etree.temptable.column.BitsUtil;
import com.cloudera.hiveserver1.sqlengine.executor.etree.temptable.column.ColumnSizeCalculator;
import com.cloudera.hiveserver1.sqlengine.executor.etree.temptable.column.DefaultColumnSlice;
import com.cloudera.hiveserver1.sqlengine.executor.etree.temptable.column.IColumnSlice;
import com.cloudera.hiveserver1.sqlengine.executor.etree.util.CompressionUtil;

public final class IntegerColumnSlice
extends DefaultColumnSlice {
    private static final long serialVersionUID = -3626818452823112157L;
    private int[] m_data;
    private byte[] m_nullInd;
    private final int m_columnNumber;
    private final boolean m_isSigned;

    public IntegerColumnSlice(int n, int n2, boolean bl) {
        this.m_data = new int[n];
        this.m_nullInd = new byte[(n + 8 - 1) / 8];
        this.m_columnNumber = n2;
        this.m_isSigned = bl;
    }

    @Override
    public int columnNumber() {
        return this.m_columnNumber;
    }

    @Override
    public boolean isNull(int n) {
        return BitsUtil.isSet(this.m_nullInd, n);
    }

    @Override
    public int getInteger(int n) {
        return this.m_data[n];
    }

    @Override
    public long getBigInt(int n) {
        return CompressionUtil.getIntAsLong(this.m_data[n], this.m_isSigned);
    }

    @Override
    public double getDouble(int n) {
        return CompressionUtil.getIntAsLong(this.m_data[n], this.m_isSigned);
    }

    @Override
    public IColumnSlice.ColumnSliceType getType() {
        return IColumnSlice.ColumnSliceType.INTEGER;
    }

    @Override
    public void setInteger(int n, int n2) {
        this.m_data[n] = n2;
        BitsUtil.clearBit(this.m_nullInd, n);
    }

    @Override
    public void setNull(int n) {
        BitsUtil.setBit(this.m_nullInd, n);
    }

    @Override
    public int size() {
        return this.m_data.length;
    }

    @Override
    public void copy(IColumnSlice iColumnSlice, int n, int n2, int n3) {
        if (!(iColumnSlice instanceof IntegerColumnSlice)) {
            throw new IllegalArgumentException("Unknown column slice type");
        }
        IntegerColumnSlice integerColumnSlice = (IntegerColumnSlice)iColumnSlice;
        System.arraycopy(integerColumnSlice.m_data, n, this.m_data, n3, n2);
        BitsUtil.copy(this.m_nullInd, n3, n2, integerColumnSlice.m_nullInd, n);
    }

    static double estimateRowSize(ColumnSizeCalculator.JavaSize javaSize) {
        return 0.0;
    }

    static double estimateRowOverhead(ColumnSizeCalculator.JavaSize javaSize) {
        return (double)javaSize.getIntSize() + (double)javaSize.getByteSize() / 8.0;
    }
}

