/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.executor.etree.value.scalar;

import com.cloudera.hiveserver1.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver1.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.cloudera.hiveserver1.sqlengine.executor.etree.ETDataRequest;
import com.cloudera.hiveserver1.sqlengine.executor.etree.value.ETValueExpr;
import com.cloudera.hiveserver1.sqlengine.executor.etree.value.scalar.ETScalarFn;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import java.util.List;

public class ETCharFn
extends ETScalarFn {
    public ETCharFn(IColumn iColumn, List<ETValueExpr> list, List<IColumn> list2) throws ErrorException {
        super(iColumn, list, list2);
        assert (1 == list.size() && 1 == list2.size());
        assert (list2.get(0).getTypeMetadata().isIntegerType());
        assert (iColumn.getTypeMetadata().isCharacterType());
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        ISqlDataWrapper iSqlDataWrapper = this.getArgumentData(0);
        if (iSqlDataWrapper.isNull()) {
            eTDataRequest.getData().setNull();
        } else {
            long l = iSqlDataWrapper.getInteger();
            if (l > 255L || l < 0L) {
                eTDataRequest.getData().setNull();
            } else {
                eTDataRequest.getData().setChar(String.valueOf((char)l));
            }
        }
        return false;
    }
}

