/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.streams.resultsetinput;

import com.cloudera.hiveserver1.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.hiveserver1.exceptions.ExceptionConverter;
import com.cloudera.hiveserver1.exceptions.JDBCMessageKey;
import com.cloudera.hiveserver1.support.IWarningListener;
import com.cloudera.hiveserver1.support.Pair;
import com.cloudera.hiveserver1.support.exceptions.ExceptionType;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;

public abstract class AbstractDataStream {
    protected static final int MAX_FETCH_SIZE = 4000;
    protected static final int UNKNOWN_SIZE = -1;
    protected int m_numRead = 0;
    protected long m_streamLength = 0L;
    protected long m_lastChunkReadSize = 0L;
    protected InputStream m_stream = null;
    protected int m_type;
    protected IWarningListener m_warningListener = null;

    protected AbstractDataStream(InputStream inputStream, long l, int n, IWarningListener iWarningListener) {
        this.m_stream = inputStream;
        this.m_streamLength = l;
        this.m_type = n;
        this.m_warningListener = iWarningListener;
    }

    public void close() {
        if (this.m_stream != null) {
            try {
                this.m_stream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_stream = null;
        }
    }

    public boolean canGetAsReader() {
        return false;
    }

    public Reader getAsReader() {
        throw new UnsupportedOperationException();
    }

    public boolean canGetAsInputStream() {
        return false;
    }

    public InputStream getAsInputStream() {
        throw new UnsupportedOperationException();
    }

    public abstract Pair<DataWrapper, Long> getNextValue() throws SQLException;

    public boolean hasMoreData() throws SQLException {
        if (this.isClosed()) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.STREAM_CLOSED, this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        if (-1L != this.m_streamLength) {
            return (long)this.m_numRead < this.m_streamLength;
        }
        return -1L != this.m_lastChunkReadSize;
    }

    protected int getNumToFetch() {
        if (-1L != this.m_streamLength) {
            long l = this.m_streamLength - (long)this.m_numRead;
            return (int)Math.min(4000L, l);
        }
        return 4000;
    }

    protected boolean isClosed() {
        return null == this.m_stream;
    }
}

