/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.dsi.core.utilities.impl.future;

import com.cloudera.hiveserver2.dsi.core.utilities.future.NonTrivialJDBCConversions;
import com.cloudera.hiveserver2.dsi.core.utilities.impl.future.NumberJDBCDataSink;
import com.cloudera.hiveserver2.dsi.exceptions.ConversionFailed;
import com.cloudera.hiveserver2.dsi.exceptions.IncorrectTypeException;
import com.cloudera.hiveserver2.support.IWarningListener;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.sql.SQLException;

public abstract class SignedBigIntJDBCDataSink
extends NumberJDBCDataSink<Long> {
    public SignedBigIntJDBCDataSink(IWarningListener iWarningListener) {
        super(iWarningListener);
    }

    @Override
    public void set(Object object) throws IncorrectTypeException, ConversionFailed, ErrorException {
        if (object == null || object instanceof Long) {
            this.doSet((Long)object);
        } else {
            long l = NonTrivialJDBCConversions.objectToLong(object, this.getAndClearListener());
            this.handleConversionResult(object, "set");
            this.doSet(l);
        }
    }

    @Override
    public void setByte(byte by) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        this.setLong(by);
    }

    @Override
    public void setShort(short s) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        this.setLong(s);
    }

    @Override
    public void setInt(int n) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        this.setLong(n);
    }

    @Override
    public void setLong(long l) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        this.doSet(l);
    }

    @Override
    public void setFloat(float f) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        long l = NonTrivialJDBCConversions.DoubleConverter.toLong(f, this.getAndClearListener());
        if (!this.conversionSuccessful()) {
            this.handleConversionResult(Float.valueOf(f), "setFloat");
        }
        this.setLong(l);
    }

    @Override
    public void setDouble(double d) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        long l = NonTrivialJDBCConversions.DoubleConverter.toLong(d, this.getAndClearListener());
        if (!this.conversionSuccessful()) {
            this.handleConversionResult(d, "setDouble");
        }
        this.setLong(l);
    }

    @Override
    public void setBigDecimal(BigDecimal bigDecimal) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        if (bigDecimal == null) {
            this.setNull(3);
        } else {
            long l = NonTrivialJDBCConversions.DecimalConverter.toLong(bigDecimal, this.getAndClearListener());
            this.handleConversionResult(bigDecimal, "setBigDecimal");
            this.setLong(l);
        }
    }

    @Override
    public void setString(String string) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        if (string == null) {
            this.setNull(1);
        } else {
            string = string.trim();
            try {
                this.setLong(Long.parseLong(string));
            }
            catch (NumberFormatException numberFormatException) {
                long l = NonTrivialJDBCConversions.DecimalConverter.toLong(NonTrivialJDBCConversions.stringToBigDecimal(string), this.getAndClearListener());
                this.handleConversionResult(string, "setString");
                this.setLong(l);
            }
        }
    }
}

