/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.hive.core;

import com.cloudera.hiveserver2.hive.core.HiveJDBCServerVersion;
import com.cloudera.hiveserver2.hivecommon.AbstractServerVersionUtils;
import com.cloudera.hiveserver2.hivecommon.AuthMech;
import com.cloudera.hiveserver2.hivecommon.HiveJDBCCasePreservingAlias;
import com.cloudera.hiveserver2.hivecommon.HiveJDBCSettings;
import com.cloudera.hiveserver2.hivecommon.IServerVersion;
import com.cloudera.hiveserver2.hivecommon.TransportMode;
import com.cloudera.hiveserver2.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.hiveserver2.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.hiveserver2.jdbc.common.OAuthFlow;
import com.cloudera.hiveserver2.support.ILogger;
import com.cloudera.hiveserver2.support.LogUtilities;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;

public class HiveJDBCServerVersionUtils
extends AbstractServerVersionUtils {
    @Override
    public boolean isServerVersionSet(IServerVersion iServerVersion) {
        switch ((HiveJDBCServerVersion)iServerVersion) {
            case AUTO: {
                return false;
            }
        }
        return true;
    }

    @Override
    public OAuthFlow getDefaultOAuthFlow() {
        return OAuthFlow.CLIENT_CREDENTIALS;
    }

    @Override
    public int getIsTemporaryColIndex(IServerVersion iServerVersion) {
        return 1;
    }

    @Override
    public int getTableNameColIndex(IServerVersion iServerVersion) {
        return 0;
    }

    @Override
    public IServerVersion getHighestServerVersion() {
        HiveJDBCServerVersion[] hiveJDBCServerVersionArray = HiveJDBCServerVersion.values();
        return hiveJDBCServerVersionArray[hiveJDBCServerVersionArray.length - 1];
    }

    @Override
    public IServerVersion parseServerVersion(String string, ILogger iLogger) {
        try {
            if (string == "AUTO") {
                return HiveJDBCServerVersion.AUTO;
            }
            String[] stringArray = string.split("\\.");
            if (stringArray.length >= 1) {
                int n = new Integer(stringArray[0]);
                int n2 = 0;
                if (stringArray.length >= 1) {
                    n2 = new Integer(stringArray[1]);
                }
                if (0 == n) {
                    if (9 >= n2) {
                        return HiveJDBCServerVersion.H_0_9;
                    }
                    if (10 == n2) {
                        return HiveJDBCServerVersion.H_0_10;
                    }
                    if (11 == n2) {
                        return HiveJDBCServerVersion.H_0_11;
                    }
                    if (12 == n2) {
                        return HiveJDBCServerVersion.H_0_12;
                    }
                    if (13 == n2) {
                        return HiveJDBCServerVersion.H_0_13;
                    }
                    return HiveJDBCServerVersion.H_0_14;
                }
                if (1 == n) {
                    if (2 > n2) {
                        return HiveJDBCServerVersion.H_0_14;
                    }
                    return HiveJDBCServerVersion.H_1_2;
                }
                if (2 == n) {
                    return HiveJDBCServerVersion.H_1_2;
                }
                if (3 == n) {
                    if (1 > n2) {
                        return HiveJDBCServerVersion.H_1_2;
                    }
                    return HiveJDBCServerVersion.H_3_1;
                }
                return this.getHighestServerVersion();
            }
        }
        catch (Exception exception) {
            HiveJDBCServerVersion hiveJDBCServerVersion = (HiveJDBCServerVersion)this.getHighestServerVersion();
            if (null != iLogger) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_SERVER_VERSION_SET_HIGHEST_ERR.name(), new String[]{hiveJDBCServerVersion.name(), exception.getMessage()});
                LogUtilities.logWarning(errorException, iLogger);
            }
            return hiveJDBCServerVersion;
        }
        return HiveJDBCServerVersion.H_0_9;
    }

    @Override
    public boolean reportsTypeChar(HiveJDBCSettings hiveJDBCSettings) {
        return this.greaterThanOrEqualTo(hiveJDBCSettings.m_serverVersion, HiveJDBCServerVersion.H_0_13);
    }

    @Override
    public boolean reportsTypeVarchar(HiveJDBCSettings hiveJDBCSettings) {
        return this.greaterThanOrEqualTo(hiveJDBCSettings.m_serverVersion, HiveJDBCServerVersion.H_0_12);
    }

    @Override
    public AuthMech resolveDefaultAuthMech(HiveJDBCSettings hiveJDBCSettings) {
        switch (hiveJDBCSettings.m_hiveServerType) {
            case HiveServer1: {
                return AuthMech.NOAUTH;
            }
        }
        if (TransportMode.BINARY == hiveJDBCSettings.m_transportMode) {
            return AuthMech.NOAUTH;
        }
        if (TransportMode.HTTP == hiveJDBCSettings.m_transportMode) {
            return AuthMech.UIDPWD;
        }
        return AuthMech.SASL_PLAIN_UID;
    }

    @Override
    public boolean supportsComplexTypesInResults() {
        return true;
    }

    @Override
    public boolean supportsDescribeTable(IServerVersion iServerVersion) {
        switch ((HiveJDBCServerVersion)iServerVersion) {
            case H_0_9: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean supportsV3Protocol(IServerVersion iServerVersion) {
        switch ((HiveJDBCServerVersion)iServerVersion) {
            case H_0_12: 
            case H_0_13: 
            case H_0_14: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsV6Protocol(IServerVersion iServerVersion) {
        switch ((HiveJDBCServerVersion)iServerVersion) {
            case H_0_13: 
            case H_0_14: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsV8Protocol(IServerVersion iServerVersion) {
        return this.greaterThanOrEqualTo(iServerVersion, HiveJDBCServerVersion.H_1_2);
    }

    @Override
    public boolean supportsAsynchronousOperations(IServerVersion iServerVersion) {
        return this.greaterThanOrEqualTo(iServerVersion, HiveJDBCServerVersion.H_0_13);
    }

    @Override
    public boolean supportsCharLength(IServerVersion iServerVersion) {
        return this.greaterThanOrEqualTo(iServerVersion, HiveJDBCServerVersion.H_0_13);
    }

    @Override
    public boolean supportsGetColumnsAPINullability(IServerVersion iServerVersion) {
        return false;
    }

    @Override
    public boolean supportsVarcharLength(IServerVersion iServerVersion) {
        return this.greaterThanOrEqualTo(iServerVersion, HiveJDBCServerVersion.H_0_12);
    }

    @Override
    public boolean supportsDecimalPrecisionAndScale(IServerVersion iServerVersion) {
        return this.greaterThanOrEqualTo(iServerVersion, HiveJDBCServerVersion.H_0_13);
    }

    @Override
    public boolean supportsTypeBinary(IServerVersion iServerVersion) {
        return this.greaterThanOrEqualTo(iServerVersion, HiveJDBCServerVersion.H_0_8);
    }

    @Override
    public boolean supportsTypeChar(HiveJDBCSettings hiveJDBCSettings) {
        return this.greaterThanOrEqualTo(hiveJDBCSettings.m_serverVersion, HiveJDBCServerVersion.H_0_13);
    }

    @Override
    public boolean supportsTypeDate(IServerVersion iServerVersion) {
        return this.greaterThanOrEqualTo(iServerVersion, HiveJDBCServerVersion.H_0_12);
    }

    @Override
    public boolean supportsTypeDecimal(IServerVersion iServerVersion) {
        return this.greaterThanOrEqualTo(iServerVersion, HiveJDBCServerVersion.H_0_11);
    }

    @Override
    public boolean supportSTypeReal(IServerVersion iServerVersion) {
        return false;
    }

    @Override
    public boolean supportsTypeTimestamp(IServerVersion iServerVersion) {
        return this.greaterThanOrEqualTo(iServerVersion, HiveJDBCServerVersion.H_0_8);
    }

    @Override
    public boolean supportsTypeVarchar(HiveJDBCSettings hiveJDBCSettings) {
        return this.greaterThanOrEqualTo(hiveJDBCSettings.m_serverVersion, HiveJDBCServerVersion.H_0_12);
    }

    @Override
    public boolean supportsNestedDataTypes(IServerVersion iServerVersion) {
        return true;
    }

    @Override
    public boolean supportsUnionDataTypes(IServerVersion iServerVersion) {
        return true;
    }

    @Override
    public boolean supportsDMLstatement(IServerVersion iServerVersion) {
        return this.greaterThanOrEqualTo(iServerVersion, HiveJDBCServerVersion.H_0_14);
    }

    @Override
    public boolean hqlSupportsDefaultOuterJoin(IServerVersion iServerVersion) {
        return HiveJDBCServerVersion.H_0_9.equals(iServerVersion) || this.greaterThanOrEqualTo(iServerVersion, HiveJDBCServerVersion.H_0_12);
    }

    @Override
    public boolean hqlSupportsDefaultOrderBy(IServerVersion iServerVersion) {
        return this.greaterThanOrEqualTo(iServerVersion, HiveJDBCServerVersion.H_3_1);
    }

    @Override
    public String supportsBackTickedAliases(IServerVersion iServerVersion, String string) {
        return "`" + string + "`";
    }

    @Override
    public boolean supportI16BufferForSmallInt(IServerVersion iServerVersion) {
        return true;
    }

    @Override
    public boolean supportPushdownCatalogFilter(IServerVersion iServerVersion) {
        return true;
    }

    @Override
    public boolean supportsAliasingInScalarFun(IServerVersion iServerVersion) {
        return true;
    }

    @Override
    public boolean supportsGetColumnsAPI(IServerVersion iServerVersion) {
        return true;
    }

    @Override
    public boolean supportsQueryCommentHints(IServerVersion iServerVersion) {
        return false;
    }

    @Override
    public boolean isDisableLimitZeroForSimpleQuery() {
        return false;
    }

    @Override
    public boolean hasIssueWithNullTypeMetadata(IServerVersion iServerVersion) {
        return false;
    }

    @Override
    public boolean hasIssueWithNullTypeData(IServerVersion iServerVersion) {
        return false;
    }

    @Override
    public boolean supportsGetSchemasAPI(IServerVersion iServerVersion) {
        return true;
    }

    @Override
    public boolean supportsGetTablesAPI(IServerVersion iServerVersion) {
        return true;
    }

    @Override
    public boolean supportsGetPrimaryForeignKeyAPI(HiveJDBCSettings hiveJDBCSettings) {
        return this.greaterThanOrEqualTo(hiveJDBCSettings.m_serverVersion, HiveJDBCServerVersion.H_2_1);
    }

    @Override
    public boolean needsColumnTypeCastForInsert(IServerVersion iServerVersion) {
        return false;
    }

    @Override
    public boolean needsInsertOptimization(IServerVersion iServerVersion) {
        return false;
    }

    @Override
    public boolean preservesAliasCase(HiveJDBCSettings hiveJDBCSettings) {
        return HiveJDBCCasePreservingAlias.PRESERVE_CASE == hiveJDBCSettings.m_columnNameAliaseCase;
    }

    @Override
    public boolean supportsTimeOnlyTimestamp(IServerVersion iServerVersion) {
        return false;
    }

    @Override
    public boolean supportsDateOnlyTimestamp(IServerVersion iServerVersion) {
        return false;
    }

    @Override
    public boolean supportsNewLineCharacter(IServerVersion iServerVersion) {
        return true;
    }

    @Override
    public boolean supportsAuthMech(AuthMech authMech) {
        return true;
    }

    @Override
    public boolean sendUidViaOpenSessionReq(AuthMech authMech) {
        return false;
    }

    @Override
    public boolean supportsHttp(AuthMech authMech) {
        switch (authMech) {
            case UIDPWD: 
            case SASL_KERBEROS: 
            case OAUTH_2: 
            case SAML_2_0: 
            case JWT: {
                return true;
            }
        }
        return false;
    }
}

