/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.sqlengine.aeprocessor.aebuilder.value;

import com.cloudera.hiveserver2.sqlengine.aeprocessor.aebuilder.AEBuilderBase;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aebuilder.AEQueryScope;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aebuilder.value.AEValueExprBuilder;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.AEDefaultVisitor;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.AESemantics;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.IAENode;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.value.AECountStarAggrFn;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.value.AEGeneralAggrFn;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.value.AELiteral;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.value.AEParameter;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.value.AEValueExprList;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.value.AEValueSubQuery;
import com.cloudera.hiveserver2.sqlengine.exceptions.SQLEngineException;
import com.cloudera.hiveserver2.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.hiveserver2.sqlengine.parser.parsetree.IPTNode;
import com.cloudera.hiveserver2.sqlengine.parser.parsetree.PTListNode;
import com.cloudera.hiveserver2.sqlengine.parser.parsetree.PTNonterminalNode;
import com.cloudera.hiveserver2.sqlengine.parser.type.PTListType;
import com.cloudera.hiveserver2.sqlengine.parser.type.PTLiteralType;
import com.cloudera.hiveserver2.sqlengine.parser.type.PTPositionalType;
import com.cloudera.hiveserver2.sqlengine.utilities.SQLEngineMessageKey;
import com.cloudera.hiveserver2.support.exceptions.DiagState;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class AEGroupByListBuilder
extends AEBuilderBase<AEValueExprList> {
    private static final int INVALID_COLUMN_NUMBER = -1;
    boolean m_hasStarInSelectList = false;
    private ArrayList<IPTNode> m_selectListValExprs = new ArrayList();
    private HashMap<Integer, Integer> m_refMap = new HashMap();

    public AEGroupByListBuilder(AEQueryScope aEQueryScope, PTListNode pTListNode) throws ErrorException {
        super(aEQueryScope);
        this.preProcessSelectList(pTListNode);
    }

    @Override
    public AEValueExprList visit(PTListNode pTListNode) throws ErrorException {
        assert (pTListNode != null);
        if (pTListNode.getListType() != PTListType.GROUPBY_EXPRESSION_LIST) {
            throw SQLEngineExceptionFactory.invalidParseTreeException();
        }
        this.m_refMap.clear();
        AEValueExprList aEValueExprList = new AEValueExprList();
        for (IPTNode iPTNode : pTListNode.getImmutableChildList()) {
            Object object;
            AEValueExpr aEValueExpr = (AEValueExpr)new AEValueExprBuilder(this.getQueryScope()).build(iPTNode);
            int n = this.getColumnNumber(aEValueExpr);
            if (-1 != n) {
                if (this.m_hasStarInSelectList) {
                    throw new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.GROUP_BY_POS_NUM_WITH_STAR.name());
                }
                if (n >= this.m_selectListValExprs.size()) {
                    throw new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.GROUP_BY_POS_NUM_OUT_OF_RANGE.name(), new String[]{Integer.toString(n)});
                }
                object = this.m_selectListValExprs.get(n);
                aEValueExpr = (AEValueExpr)new AEValueExprBuilder(this.getQueryScope()).build((IPTNode)object);
            }
            if (aEValueExpr instanceof AEParameter) {
                throw new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.DYN_PARAM_NOT_ALLOWED.name(), new String[]{"GROUP BY"});
            }
            object = new AEDefaultVisitor<Void>(){

                @Override
                public Void visit(AECountStarAggrFn aECountStarAggrFn) throws ErrorException {
                    throw SQLEngineExceptionFactory.aggrFnSemanticsException(SQLEngineMessageKey.AGGR_FN_N_SUBQUERY_IN_GROUPBY);
                }

                @Override
                public Void visit(AEGeneralAggrFn aEGeneralAggrFn) throws ErrorException {
                    throw SQLEngineExceptionFactory.aggrFnSemanticsException(SQLEngineMessageKey.AGGR_FN_N_SUBQUERY_IN_GROUPBY);
                }

                @Override
                public Void visit(AEValueSubQuery aEValueSubQuery) throws ErrorException {
                    throw SQLEngineExceptionFactory.aggrFnSemanticsException(SQLEngineMessageKey.AGGR_FN_N_SUBQUERY_IN_GROUPBY);
                }

                @Override
                protected Void defaultVisit(IAENode iAENode) throws ErrorException {
                    Iterator<? extends IAENode> iterator = iAENode.getChildItr();
                    while (iterator.hasNext()) {
                        iterator.next().acceptVisitor(this);
                    }
                    return null;
                }
            };
            aEValueExpr.acceptVisitor(object);
            if (AESemantics.findUniqueQueryScope(aEValueExpr, true) != this.getQueryScope()) {
                throw new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.EXPR_IN_GROUP_BY_NOT_ROW_BASED.name());
            }
            AEValueExpr aEValueExpr2 = this.getQueryScope().addGroupingExpr(aEValueExpr);
            if (null == aEValueExpr2) continue;
            aEValueExprList.addNode(aEValueExpr2);
            if (-1 == n) continue;
            this.m_refMap.put(aEValueExprList.getNumChildren() - 1, n);
        }
        assert (0 < aEValueExprList.getNumChildren());
        return aEValueExprList;
    }

    private int getColumnNumber(AEValueExpr aEValueExpr) throws ErrorException {
        AELiteral aELiteral;
        int n = -1;
        if (aEValueExpr instanceof AELiteral && PTLiteralType.USINT == (aELiteral = (AELiteral)aEValueExpr).getLiteralType()) {
            try {
                n = Integer.parseInt(aELiteral.getStringValue()) - 1;
                if (0 > n) {
                    throw new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.GROUP_BY_POS_NUM_OUT_OF_RANGE.name(), new String[]{Integer.toString(n)});
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.GROUP_BY_POS_NUM_OUT_OF_RANGE.name(), new String[]{"UNKNOWN"});
            }
        }
        return n;
    }

    private void preProcessSelectList(PTListNode pTListNode) throws ErrorException {
        Iterator<IPTNode> iterator = pTListNode.getChildItr();
        block4: while (iterator.hasNext()) {
            IPTNode iPTNode = iterator.next();
            if (iPTNode.isTerminalNode()) continue;
            PTNonterminalNode pTNonterminalNode = (PTNonterminalNode)iPTNode;
            switch (pTNonterminalNode.getNonterminalType()) {
                case COLUMN_REFERENCE: {
                    this.m_hasStarInSelectList = true;
                    return;
                }
                case DERIVED_COLUMN: {
                    this.m_selectListValExprs.add(pTNonterminalNode.getChild(PTPositionalType.VALUE_EXPRESSION_GENERAL));
                    continue block4;
                }
            }
            throw SQLEngineExceptionFactory.invalidParseTreeException();
        }
    }

    public Map<Integer, Integer> getGroupingListOrdinalReferenceMap() {
        return this.m_refMap;
    }
}

