/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.sqlengine.executor.datawrapper;

import com.cloudera.hiveserver2.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.hiveserver2.dsi.exceptions.IncorrectTypeException;
import com.cloudera.hiveserver2.sqlengine.exceptions.SQLEngineException;
import com.cloudera.hiveserver2.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.hiveserver2.sqlengine.executor.datawrapper.DefaultSqlDataWrapper;
import com.cloudera.hiveserver2.sqlengine.utilities.SQLEngineMessageKey;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;
import java.math.BigInteger;

public final class SqlBooleanDataWrapper
extends DefaultSqlDataWrapper {
    private boolean m_data;
    private boolean m_isSet = false;
    private boolean m_isNull = false;
    private final int m_type;

    public SqlBooleanDataWrapper(int n) {
        assert (n == -7 || n == 16);
        this.m_type = n;
    }

    @Override
    public BigInteger getBigInt() throws ErrorException, NullPointerException {
        this.checkValidRetrieval();
        if (this.m_data) {
            return BigInteger.ONE;
        }
        return BigInteger.ZERO;
    }

    @Override
    public boolean getBoolean() throws ErrorException, NullPointerException {
        this.checkValidRetrieval();
        return this.m_data;
    }

    @Override
    public double getDouble() throws ErrorException, NullPointerException {
        this.checkValidRetrieval();
        if (this.m_data) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public float getReal() throws ErrorException, NullPointerException {
        this.checkValidRetrieval();
        if (this.m_data) {
            return 1.0f;
        }
        return 0.0f;
    }

    @Override
    public long getInteger() throws ErrorException, NullPointerException {
        this.checkValidRetrieval();
        if (this.m_data) {
            return 1L;
        }
        return 0L;
    }

    @Override
    public int getSmallInt() throws ErrorException, NullPointerException {
        this.checkValidRetrieval();
        if (this.m_data) {
            return 1;
        }
        return 0;
    }

    @Override
    public short getTinyInt() throws ErrorException, NullPointerException {
        this.checkValidRetrieval();
        if (this.m_data) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getType() {
        return this.m_type;
    }

    @Override
    public boolean isNull() {
        return this.m_isNull;
    }

    @Override
    public boolean isSet() {
        return this.m_isSet;
    }

    @Override
    public void setBoolean(boolean bl) {
        this.m_isSet = true;
        this.m_data = bl;
        this.m_isNull = false;
    }

    @Override
    public void setNull() {
        this.m_isSet = true;
        this.m_isNull = true;
    }

    @Override
    public void setValue(DataWrapper dataWrapper) throws ErrorException {
        if (dataWrapper.isNull()) {
            this.setNull();
        } else {
            try {
                switch (dataWrapper.getType()) {
                    case 16: {
                        this.setBoolean(dataWrapper.getBoolean());
                        break;
                    }
                    case -7: {
                        this.setBoolean(dataWrapper.getBit());
                        break;
                    }
                    default: {
                        throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(dataWrapper.getType());
                    }
                }
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw new SQLEngineException(SQLEngineMessageKey.INVALID_OPERATION.name(), incorrectTypeException);
            }
        }
    }

    @Override
    public void retrieveData(DataWrapper dataWrapper) throws ErrorException {
        if (!this.m_isSet) {
            throw new IllegalStateException("ISqlDataWrapper is not set with data for retrieval");
        }
        if (this.m_isNull) {
            dataWrapper.setNull(this.m_type);
            return;
        }
        switch (this.m_type) {
            case 16: {
                dataWrapper.setBoolean(this.m_data);
                break;
            }
            case -7: {
                dataWrapper.setBit(this.m_data);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void checkValidRetrieval() throws ErrorException {
        if (!this.m_isSet) {
            throw SQLEngineExceptionFactory.requestedDataNotSet();
        }
        if (this.m_isNull) {
            throw new NullPointerException("Data requested, but the data is null.");
        }
    }
}

