/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.sqlengine.executor.datawrapper;

import com.cloudera.hiveserver2.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.hiveserver2.dsi.exceptions.IncorrectTypeException;
import com.cloudera.hiveserver2.sqlengine.exceptions.SQLEngineException;
import com.cloudera.hiveserver2.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.hiveserver2.sqlengine.executor.datawrapper.DefaultSqlDataWrapper;
import com.cloudera.hiveserver2.sqlengine.utilities.SQLEngineMessageKey;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;
import java.sql.Time;
import java.util.Date;

public final class SqlTimeDataWrapper
extends DefaultSqlDataWrapper {
    private Time m_data;
    private boolean m_isSet = false;

    @Override
    public Date getJavaUtilDate() throws ErrorException {
        this.checkIsSet();
        return this.m_data;
    }

    @Override
    public Time getTime() throws ErrorException {
        this.checkIsSet();
        return this.m_data;
    }

    @Override
    public int getType() {
        return 92;
    }

    @Override
    public boolean isNull() throws ErrorException {
        this.checkIsSet();
        return null == this.m_data;
    }

    @Override
    public boolean isSet() {
        return this.m_isSet;
    }

    @Override
    public void setTime(Time time) {
        this.m_isSet = true;
        this.m_data = time;
    }

    @Override
    public void setNull() {
        this.m_isSet = true;
        this.m_data = null;
    }

    @Override
    public void setValue(DataWrapper dataWrapper) throws ErrorException {
        try {
            switch (dataWrapper.getType()) {
                case 92: {
                    this.setTime(dataWrapper.getTime());
                    break;
                }
                case 0: {
                    if (dataWrapper.isNull()) {
                        this.setNull();
                        break;
                    }
                }
                default: {
                    throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(dataWrapper.getType());
                }
            }
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw new SQLEngineException(SQLEngineMessageKey.INVALID_OPERATION.name(), incorrectTypeException);
        }
    }

    @Override
    public void retrieveData(DataWrapper dataWrapper) throws ErrorException {
        this.checkIsSet();
        dataWrapper.setTime(this.m_data);
    }

    private void checkIsSet() throws ErrorException {
        if (!this.m_isSet) {
            throw SQLEngineExceptionFactory.requestedDataNotSet();
        }
    }
}

