/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.sqlengine.executor.etree.value;

import com.cloudera.hiveserver2.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.CursorType;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.AESortSpec;
import com.cloudera.hiveserver2.sqlengine.dsiext.dataengine.SqlDataEngine;
import com.cloudera.hiveserver2.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.cloudera.hiveserver2.sqlengine.executor.etree.ETCancelState;
import com.cloudera.hiveserver2.sqlengine.executor.etree.ETDataRequest;
import com.cloudera.hiveserver2.sqlengine.executor.etree.IETNode;
import com.cloudera.hiveserver2.sqlengine.executor.etree.IETNodeVisitor;
import com.cloudera.hiveserver2.sqlengine.executor.etree.relation.ETDistinctMove;
import com.cloudera.hiveserver2.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.cloudera.hiveserver2.sqlengine.executor.etree.relation.ETTemporaryTableWrapper;
import com.cloudera.hiveserver2.sqlengine.executor.etree.temptable.SortedTemporaryTable;
import com.cloudera.hiveserver2.sqlengine.executor.etree.temptable.TemporaryTableBuilder;
import com.cloudera.hiveserver2.sqlengine.utilities.ExternalAlgorithmUtil;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.List;

public class ETDistinctValueStore
extends ETRelationalExpr {
    private boolean m_isSorted = false;
    private boolean m_isInitialized = false;
    private final SortedTemporaryTable m_sortedTemporaryTable;
    private final ETDistinctMove m_distinctMove;

    public ETDistinctValueStore(List<IColumn> list, ETCancelState eTCancelState, SqlDataEngine sqlDataEngine, ExternalAlgorithmUtil.ExternalAlgorithmProperties externalAlgorithmProperties, boolean[] blArray) throws ErrorException {
        super(blArray);
        ArrayList<AESortSpec> arrayList = new ArrayList<AESortSpec>();
        for (int i = 0; i < blArray.length; ++i) {
            arrayList.add(new AESortSpec(i, true));
        }
        this.m_sortedTemporaryTable = new TemporaryTableBuilder(list, sqlDataEngine, externalAlgorithmProperties, eTCancelState, blArray).sortSpec(arrayList).buildSorted();
        ETTemporaryTableWrapper eTTemporaryTableWrapper = new ETTemporaryTableWrapper(blArray, this.m_sortedTemporaryTable, list);
        this.m_distinctMove = new ETDistinctMove(eTTemporaryTableWrapper, list, this.m_sortedTemporaryTable.getRowComparator(), externalAlgorithmProperties, blArray);
    }

    public void appendCell() throws ErrorException {
        if (!this.m_isInitialized) {
            this.m_sortedTemporaryTable.initialize(true);
            this.m_isInitialized = true;
        }
        this.m_sortedTemporaryTable.addRow();
        this.m_isSorted = false;
    }

    public void writeFromDataWrapper(int n, ISqlDataWrapper iSqlDataWrapper) throws ErrorException {
        assert (this.m_isInitialized);
        this.m_sortedTemporaryTable.writeFromDataWrapper(n, iSqlDataWrapper);
    }

    public void finishAppending() {
        this.m_sortedTemporaryTable.finishAppending();
    }

    @Override
    public boolean retrieveData(int n, ETDataRequest eTDataRequest) throws ErrorException {
        return this.m_distinctMove.retrieveData(n, eTDataRequest);
    }

    @Override
    public <T> T acceptVisitor(IETNodeVisitor<T> iETNodeVisitor) throws ErrorException {
        return iETNodeVisitor.visit(this);
    }

    @Override
    public void close(boolean bl) {
        if (this.m_isInitialized) {
            this.m_isInitialized = false;
            this.m_isSorted = false;
        }
        this.m_distinctMove.close(bl);
    }

    @Override
    public boolean isOpen() {
        return this.m_distinctMove.isOpen();
    }

    @Override
    public void reset() throws ErrorException {
        this.m_distinctMove.reset();
    }

    @Override
    public int getNumChildren() {
        return 1;
    }

    @Override
    public IColumn getColumn(int n) {
        return this.m_distinctMove.getColumn(n);
    }

    @Override
    public int getColumnCount() {
        return this.m_distinctMove.getColumnCount();
    }

    @Override
    public long getRowCount() throws ErrorException {
        return this.m_distinctMove.getRowCount();
    }

    @Override
    public void open(CursorType cursorType) throws ErrorException {
        if (!this.m_isInitialized) {
            this.m_sortedTemporaryTable.initialize(true);
            this.m_isInitialized = true;
        }
        if (!this.m_isSorted && this.m_sortedTemporaryTable.getRowCount() > 0L) {
            this.m_sortedTemporaryTable.sort();
            this.m_isSorted = true;
        }
        this.m_distinctMove.open(cursorType);
    }

    @Override
    protected IETNode getChild(int n) throws IndexOutOfBoundsException {
        switch (n) {
            case 0: {
                return this.m_distinctMove;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    protected boolean doMove() throws ErrorException {
        return this.m_distinctMove.move();
    }
}

