/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hive.jdbc42.internal.io.netty.handler.codec.string;

import com.cloudera.hive.jdbc42.internal.io.netty.buffer.ByteBufAllocator;
import com.cloudera.hive.jdbc42.internal.io.netty.buffer.ByteBufUtil;
import com.cloudera.hive.jdbc42.internal.io.netty.channel.ChannelHandler;
import com.cloudera.hive.jdbc42.internal.io.netty.channel.ChannelHandlerContext;
import com.cloudera.hive.jdbc42.internal.io.netty.handler.codec.MessageToMessageEncoder;
import com.cloudera.hive.jdbc42.internal.io.netty.util.internal.ObjectUtil;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.List;

@ChannelHandler.Sharable
public class StringEncoder
extends MessageToMessageEncoder<CharSequence> {
    private final Charset charset;

    public StringEncoder() {
        this(Charset.defaultCharset());
    }

    public StringEncoder(Charset charset) {
        this.charset = (Charset)ObjectUtil.checkNotNull((Object)charset, (String)"charset");
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, CharSequence msg, List<Object> out) throws Exception {
        if (msg.length() == 0) {
            return;
        }
        out.add(ByteBufUtil.encodeString((ByteBufAllocator)ctx.alloc(), (CharBuffer)CharBuffer.wrap(msg), (Charset)this.charset));
    }
}

