/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hive.jdbc42.internal.io.netty.handler.ipfilter;

import com.cloudera.hive.jdbc42.internal.io.netty.channel.ChannelFuture;
import com.cloudera.hive.jdbc42.internal.io.netty.channel.ChannelFutureListener;
import com.cloudera.hive.jdbc42.internal.io.netty.channel.ChannelHandler;
import com.cloudera.hive.jdbc42.internal.io.netty.channel.ChannelHandlerContext;
import com.cloudera.hive.jdbc42.internal.io.netty.channel.ChannelInboundHandlerAdapter;
import com.cloudera.hive.jdbc42.internal.io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;

public abstract class AbstractRemoteAddressFilter<T extends SocketAddress>
extends ChannelInboundHandlerAdapter {
    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        this.handleNewChannel(ctx);
        ctx.fireChannelRegistered();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (!this.handleNewChannel(ctx)) {
            throw new IllegalStateException("cannot determine to accept or reject a channel: " + ctx.channel());
        }
        ctx.fireChannelActive();
    }

    private boolean handleNewChannel(ChannelHandlerContext ctx) throws Exception {
        SocketAddress remoteAddress = ctx.channel().remoteAddress();
        if (remoteAddress == null) {
            return false;
        }
        ctx.pipeline().remove((ChannelHandler)this);
        if (this.accept(ctx, remoteAddress)) {
            this.channelAccepted(ctx, remoteAddress);
        } else {
            ChannelFuture rejectedFuture = this.channelRejected(ctx, remoteAddress);
            if (rejectedFuture != null) {
                rejectedFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            } else {
                ctx.close();
            }
        }
        return true;
    }

    protected abstract boolean accept(ChannelHandlerContext var1, T var2) throws Exception;

    protected void channelAccepted(ChannelHandlerContext ctx, T remoteAddress) {
    }

    protected ChannelFuture channelRejected(ChannelHandlerContext ctx, T remoteAddress) {
        return null;
    }
}

