/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.dsi.dataengine.interfaces.future;

import com.cloudera.hiveserver1.dsi.dataengine.interfaces.future.IBatchResult;
import com.cloudera.hiveserver1.dsi.dataengine.interfaces.future.IQueryExecutor;
import com.cloudera.hiveserver1.dsi.dataengine.interfaces.future.IResultSet;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.MetadataSourceID;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.OrderType;
import com.cloudera.hiveserver1.dsi.exceptions.ParsingException;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import java.io.Closeable;
import java.util.List;

public interface IDataEngine
extends Closeable {
    @Override
    public void close();

    public IResultSet makeNewMetadataResult(MetadataParameters var1) throws ErrorException;

    public IQueryExecutor prepareQuery(PrepareParameters var1) throws ParsingException, ErrorException;

    public IBatchResult executeBatch(List<String> var1) throws ErrorException;

    public static final class PrepareParameters {
        private final String m_query;
        private boolean m_isExecDirect = false;
        private boolean m_metadataNeeded = true;

        public PrepareParameters(String string) {
            this.m_query = string;
        }

        public void setDirectExecute() {
            this.m_isExecDirect = true;
        }

        public void setMetadataNeeded(boolean bl) {
            this.m_metadataNeeded = bl;
        }

        public String getQuery() {
            return this.m_query;
        }

        public boolean isExecDirect() {
            return this.m_isExecDirect;
        }

        public boolean isMetadataNeeded() {
            return this.m_metadataNeeded;
        }

        public String toString() {
            return String.format("Query=\"%s\" IsExecDirect=%s IsMetadataNeeded=%s", this.m_query, this.m_isExecDirect, this.m_metadataNeeded);
        }
    }

    public static final class MetadataParameters {
        private final MetadataSourceID m_metadataSourceId;
        private final List<String> m_filterValues;
        private final String m_escapeChar;
        private final String m_identifierQuoteChar;
        private final boolean m_filterAsIdentifier;
        private final OrderType m_orderType;

        public MetadataParameters(MetadataSourceID metadataSourceID, List<String> list, String string, String string2, boolean bl, OrderType orderType) {
            this.m_metadataSourceId = metadataSourceID;
            this.m_filterValues = list;
            this.m_escapeChar = string;
            this.m_identifierQuoteChar = string2;
            this.m_filterAsIdentifier = bl;
            this.m_orderType = orderType;
        }

        public MetadataSourceID GetID() {
            return this.m_metadataSourceId;
        }

        public List<String> GetFilterValues() {
            return this.m_filterValues;
        }

        public String getEscapeChar() {
            return this.m_escapeChar;
        }

        public boolean getFilterAsIdentifier() {
            return this.m_filterAsIdentifier;
        }

        public String getIdentifierQuoteChar() {
            return this.m_identifierQuoteChar;
        }

        public OrderType getOrderType() {
            return this.m_orderType;
        }

        public String toString() {
            return String.format("Source=%s Filters=%s EscapeChar=%s IdentifierQuoteChar=%s FilterAsIdentifier=%s OrderType=%s", new Object[]{this.m_metadataSourceId, this.m_filterValues, this.m_escapeChar, this.m_identifierQuoteChar, this.m_filterAsIdentifier, this.m_orderType});
        }
    }
}

