/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.aeprocessor.aebuilder;

import com.cloudera.hiveserver1.sqlengine.aeprocessor.AEColumnInfo;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.AEQColumnName;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.AEQTableName;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aebuilder.AESymbolTable;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.AESortSpec;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.relation.AEJoin;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.relation.AENamedRelationalExpr;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.value.AEAggrFn;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.value.AEProxyColumn;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.value.AEValueExprList;
import com.cloudera.hiveserver1.sqlengine.dsiext.dataengine.OpenTableType;
import com.cloudera.hiveserver1.sqlengine.dsiext.dataengine.SqlDataEngine;
import com.cloudera.hiveserver1.sqlengine.exceptions.SQLEngineException;
import com.cloudera.hiveserver1.sqlengine.parser.parsetree.PTListNode;
import com.cloudera.hiveserver1.sqlengine.utilities.SQLEngineMessageKey;
import com.cloudera.hiveserver1.support.exceptions.DiagState;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AEQueryScope {
    private ClauseType m_currentClause;
    private AEQueryScope m_parent;
    private AESymbolTable m_symbolTable;
    private SqlDataEngine m_dataEngine;
    private OpenTableType m_openTableType;
    private boolean m_isCorrelated;
    private boolean m_hasOrderBy = false;
    private PTListNode m_ptSortSpecList = null;
    private AEJoin m_currentJoinExpr = null;
    private boolean m_hasDistinct = false;
    private boolean m_hasSetOperation = false;
    private int m_selItemCount = 0;
    private boolean m_shouldCombineEquivGroupByColumns;
    private AEValueExprList m_aggregateList = new AEValueExprList();
    private ArrayList<AEProxyColumn> m_proxyCols = new ArrayList();
    private boolean m_hasImpliedGroupBy = false;
    private boolean m_hasGroupingExpression = false;
    private List<AESortSpec> m_sortSpecs = null;

    public AEQueryScope(SqlDataEngine sqlDataEngine) throws ErrorException {
        if (null == sqlDataEngine) {
            throw new NullPointerException("DataEngine cannot be null.");
        }
        this.m_parent = null;
        this.m_dataEngine = sqlDataEngine;
        this.m_shouldCombineEquivGroupByColumns = sqlDataEngine.getProperty(5).getString().equals("Y");
        this.init();
    }

    private AEQueryScope(AEQueryScope aEQueryScope) throws ErrorException {
        if (null == aEQueryScope) {
            throw new NullPointerException("Parent scope cannot be null.");
        }
        this.m_parent = aEQueryScope;
        this.m_dataEngine = this.m_parent.getDataEngine();
        this.m_shouldCombineEquivGroupByColumns = aEQueryScope.m_shouldCombineEquivGroupByColumns;
        this.init();
    }

    private void init() throws ErrorException {
        this.m_currentClause = ClauseType.NONE;
        this.m_openTableType = OpenTableType.READ_ONLY;
        this.m_isCorrelated = false;
        this.m_symbolTable = new AESymbolTable(this.isCaseSensitive());
    }

    public AEQueryScope createChildScope() throws ErrorException {
        return new AEQueryScope(this);
    }

    public boolean isCaseSensitive() {
        return this.m_dataEngine.getContext().isSqlCaseSensitive();
    }

    public boolean isTopMost() {
        return null == this.m_parent;
    }

    public boolean hasOrderBy() {
        return this.m_hasOrderBy;
    }

    public void setHasOrderBy() {
        this.m_hasOrderBy = true;
    }

    public void addTableSymbol(AENamedRelationalExpr aENamedRelationalExpr) throws ErrorException {
        this.m_symbolTable.addTable(aENamedRelationalExpr);
    }

    public ClauseType getCurrentClause() {
        return this.m_currentClause;
    }

    public Iterator<AEColumnInfo> getColumnItr() {
        return this.m_symbolTable.getColumnItr();
    }

    public Iterator<AEColumnInfo> getColumnItr(AEQTableName aEQTableName) throws SQLEngineException {
        return this.m_symbolTable.getColumnItr(aEQTableName);
    }

    public SqlDataEngine getDataEngine() {
        return this.m_dataEngine;
    }

    public AEQueryScope getParentScope() {
        return this.m_parent;
    }

    public OpenTableType getOpenTableType() {
        return this.m_openTableType;
    }

    public PTListNode getPtSortSpecList() {
        return this.m_ptSortSpecList;
    }

    public int getSelectItemCount() {
        return this.m_selItemCount;
    }

    public List<AESortSpec> getSortSpecs() {
        return this.m_sortSpecs;
    }

    public void setPtSortSpecList(PTListNode pTListNode) {
        this.m_ptSortSpecList = pTListNode;
    }

    public boolean hasDistinct() {
        return this.m_hasDistinct;
    }

    public void setHasDistinct(boolean bl) {
        this.m_hasDistinct = bl;
    }

    public void setHasSetOperation(boolean bl) {
        this.m_hasSetOperation = bl;
    }

    public void setSelectItemCount(int n) {
        this.m_selItemCount = n;
    }

    public void setSortSpec(List<AESortSpec> list) {
        this.m_sortSpecs = list;
    }

    public boolean hasSetOperation() {
        return this.m_hasSetOperation;
    }

    public AEColumnInfo resolveColumn(AEQColumnName aEQColumnName) throws ErrorException {
        return this.findColumn(aEQColumnName, false);
    }

    public void setCurrentClause(ClauseType clauseType) {
        this.m_currentClause = clauseType;
    }

    public void setCurrentJoinExpr(AEJoin aEJoin) {
        this.m_currentJoinExpr = aEJoin;
    }

    public boolean isQueryCorrelated() {
        return this.m_isCorrelated;
    }

    public AEValueExpr addAggregateFunction(AEAggrFn aEAggrFn) {
        if (this.m_currentClause == ClauseType.GROUP_BY) {
            throw new IllegalArgumentException("Aggregate functions are not added to the query in the correct order for execution.");
        }
        int n = this.m_aggregateList.findNode(aEAggrFn);
        if (-1 == n) {
            if (this.m_currentClause != ClauseType.SELECT_LIST && this.m_currentClause != ClauseType.HAVING && this.m_currentClause != ClauseType.ORDER_BY) {
                throw new IllegalArgumentException("Aggregate functions are not added to the query in the correct order for execution.");
            }
            this.m_aggregateList.addNode(aEAggrFn);
            n = this.m_aggregateList.getNumChildren() - 1;
        }
        AEProxyColumn aEProxyColumn = new AEProxyColumn((AEValueExpr)this.m_aggregateList.getChild(n), this, n);
        this.registerProxyColumn(aEProxyColumn);
        return aEProxyColumn;
    }

    public AEValueExpr addGroupingExpr(AEValueExpr aEValueExpr) {
        assert (null != aEValueExpr);
        assert (ClauseType.GROUP_BY == this.m_currentClause);
        if (this.m_shouldCombineEquivGroupByColumns && 0 <= this.m_aggregateList.findNode(aEValueExpr)) {
            return null;
        }
        this.m_aggregateList.addNode(aEValueExpr);
        this.m_hasGroupingExpression = true;
        AEProxyColumn aEProxyColumn = new AEProxyColumn(aEValueExpr, this, this.m_aggregateList.getNumChildren() - 1);
        this.registerProxyColumn(aEProxyColumn);
        return aEProxyColumn;
    }

    public AEValueExpr proxyToAggregateExpr(AEValueExpr aEValueExpr) {
        int n = this.m_aggregateList.findNode(aEValueExpr);
        if (-1 != n) {
            AEValueExpr aEValueExpr2 = (AEValueExpr)this.m_aggregateList.getChild(n);
            AEProxyColumn aEProxyColumn = new AEProxyColumn(aEValueExpr2, this, n);
            this.registerProxyColumn(aEProxyColumn);
            return aEProxyColumn;
        }
        return null;
    }

    private void registerProxyColumn(AEProxyColumn aEProxyColumn) {
        this.m_proxyCols.add(aEProxyColumn);
    }

    public AEValueExprList getAggregateList() {
        return this.m_aggregateList;
    }

    public List<? extends AEProxyColumn> getProxyColumns() {
        return this.m_proxyCols;
    }

    public boolean hasGroupingExpression() {
        return this.m_hasGroupingExpression;
    }

    private void setQueryIsCorrelated() {
        this.m_isCorrelated = true;
    }

    public boolean hasAggregate() {
        return this.m_aggregateList.getNumChildren() > 0 || this.m_hasImpliedGroupBy;
    }

    public void setImpliedGroupBy(boolean bl) {
        this.m_hasImpliedGroupBy = bl;
    }

    public void setOpenTableType(OpenTableType openTableType) {
        this.m_openTableType = openTableType;
    }

    private AEColumnInfo findColumn(AEQColumnName aEQColumnName, boolean bl) throws ErrorException {
        AEColumnInfo aEColumnInfo = null;
        if (ClauseType.FROM == this.m_currentClause) {
            if (null != this.m_currentJoinExpr && null != (aEColumnInfo = this.m_currentJoinExpr.findQColumn(aEQColumnName, this.isCaseSensitive()))) {
                AEColumnInfo aEColumnInfo2 = new AEColumnInfo(aEColumnInfo.getNamedRelationalExpr(), aEColumnInfo.getColumnNum(), bl);
                aEColumnInfo2.setResolvedQueryScope(this);
                return aEColumnInfo2;
            }
        } else {
            aEColumnInfo = this.m_symbolTable.findColumn(aEQColumnName);
            if (null != aEColumnInfo) {
                AEColumnInfo aEColumnInfo3 = new AEColumnInfo(aEColumnInfo.getNamedRelationalExpr(), aEColumnInfo.getColumnNum(), bl);
                aEColumnInfo3.setResolvedQueryScope(this);
                return aEColumnInfo3;
            }
        }
        if (null == aEColumnInfo && this.shouldSearchParent() && null != (aEColumnInfo = this.m_parent.findColumn(aEQColumnName, true))) {
            for (AEQueryScope aEQueryScope = this; aEQueryScope != aEColumnInfo.getResolvedQueryScope(); aEQueryScope = aEQueryScope.getParentScope()) {
                aEQueryScope.setQueryIsCorrelated();
                assert (null != aEQueryScope);
            }
            return aEColumnInfo;
        }
        throw new SQLEngineException(DiagState.DIAG_COLUMN_MISSING, SQLEngineMessageKey.COLUMN_NOT_FOUND.name(), new String[]{aEQColumnName.toString()});
    }

    private boolean shouldSearchParent() {
        return !this.isTopMost() && ClauseType.GROUP_BY != this.m_currentClause;
    }

    public boolean shouldHandleSortOuter() {
        return this.isTopMost() && this.hasOrderBy() && this.hasSetOperation();
    }

    public static enum ClauseType {
        NONE,
        FROM,
        WHERE,
        GROUP_BY,
        HAVING,
        SELECT_LIST,
        ORDER_BY;

    }
}

