/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.executor.etree.temptable.column;

import com.cloudera.hiveserver1.sqlengine.executor.etree.temptable.column.BitsUtil;
import com.cloudera.hiveserver1.sqlengine.executor.etree.temptable.column.ColumnSizeCalculator;
import com.cloudera.hiveserver1.sqlengine.executor.etree.temptable.column.DefaultColumnSlice;
import com.cloudera.hiveserver1.sqlengine.executor.etree.temptable.column.IColumnSlice;

public final class BigIntColumnSlice
extends DefaultColumnSlice {
    private static final long serialVersionUID = -4060993706225601688L;
    private long[] m_data;
    private byte[] m_nullIndicators;
    private final int m_columnNumber;

    public BigIntColumnSlice(int n, int n2) {
        this.m_data = new long[n];
        this.m_nullIndicators = new byte[(n + 7) / 8];
        this.m_columnNumber = n2;
    }

    @Override
    public boolean isNull(int n) {
        return BitsUtil.isSet(this.m_nullIndicators, n);
    }

    @Override
    public void setNull(int n) {
        BitsUtil.setBit(this.m_nullIndicators, n);
    }

    @Override
    public long getBigInt(int n) {
        return this.m_data[n];
    }

    @Override
    public IColumnSlice.ColumnSliceType getType() {
        return IColumnSlice.ColumnSliceType.BIGINT;
    }

    @Override
    public void setBigInt(int n, long l) {
        this.m_data[n] = l;
        BitsUtil.clearBit(this.m_nullIndicators, n);
    }

    @Override
    public int size() {
        return this.m_data.length;
    }

    @Override
    public void copy(IColumnSlice iColumnSlice, int n, int n2, int n3) {
        if (!(iColumnSlice instanceof BigIntColumnSlice)) {
            throw new IllegalArgumentException("Unknown column slice type");
        }
        BigIntColumnSlice bigIntColumnSlice = (BigIntColumnSlice)iColumnSlice;
        System.arraycopy(bigIntColumnSlice.m_data, n, this.m_data, n3, n2);
        BitsUtil.copy(this.m_nullIndicators, n3, n2, bigIntColumnSlice.m_nullIndicators, n);
    }

    static double estimateRowSize(ColumnSizeCalculator.JavaSize javaSize) {
        return 0.0;
    }

    static double estimateRowOverhead(ColumnSizeCalculator.JavaSize javaSize) {
        return (double)javaSize.getLongSize() + (double)javaSize.getByteSize() / 8.0;
    }

    @Override
    public int columnNumber() {
        return this.m_columnNumber;
    }
}

