/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.executor.etree.temptable.column;

import com.cloudera.hiveserver1.sqlengine.executor.etree.temptable.column.IColumnSlice;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ColumnSliceArray
implements Iterable<IColumnSlice>,
Serializable {
    private static final long serialVersionUID = -1645573716418355541L;
    private final IColumnSlice[] m_data;
    private final int[] m_columnMapping;
    private final int m_numRows;

    public ColumnSliceArray(IColumnSlice[] iColumnSliceArray, int[] nArray, int n) {
        this.m_data = iColumnSliceArray;
        this.m_numRows = n;
        this.m_columnMapping = nArray;
    }

    public IColumnSlice get(int n) {
        return this.m_data[this.m_columnMapping[n]];
    }

    @Override
    public Iterator<IColumnSlice> iterator() {
        return new DataIterator();
    }

    public int numRows() {
        return this.m_numRows;
    }

    public int simulatedNumColumns() {
        return this.m_columnMapping.length;
    }

    public int trueNumColumns() {
        return this.m_data.length;
    }

    private class DataIterator
    implements Iterator<IColumnSlice> {
        int m_currentIndex = 0;

        private DataIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.m_currentIndex < ColumnSliceArray.this.m_data.length;
        }

        @Override
        public IColumnSlice next() {
            if (this.m_currentIndex >= ColumnSliceArray.this.m_data.length) {
                throw new NoSuchElementException();
            }
            IColumnSlice iColumnSlice = ColumnSliceArray.this.m_data[this.m_currentIndex];
            ++this.m_currentIndex;
            return iColumnSlice;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

