/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.executor.etree.value;

import java.math.BigInteger;

public class SqlDataIntegrityChecker {
    public static final long UNSIGNED_INT_MAX = 0xFFFFFFFFL;
    public static final long SIGNED_INT_MAX = Integer.MAX_VALUE;
    public static final long SIGNED_INT_MIN = Integer.MIN_VALUE;
    public static final int UNSIGNED_SMALLINT_MAX = 65535;
    public static final int SIGNED_SMALLINT_MAX = Short.MAX_VALUE;
    public static final int SIGNED_SMALLINT_MIN = Short.MIN_VALUE;
    public static final short UNSIGNED_TINYINT_MAX = 255;
    public static final short SIGNED_TINYINT_MAX = 127;
    public static final short SIGNED_TINYINT_MIN = -128;
    public static final BigInteger UNSIGNED_BIGINT_MAX = BigInteger.valueOf(Long.MAX_VALUE).multiply(BigInteger.valueOf(2L)).add(BigInteger.ONE);
    public static final BigInteger SIGNED_BIGINT_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    public static final BigInteger SIGNED_BIGINT_MIN = BigInteger.valueOf(Long.MIN_VALUE);

    public static boolean checkInteger(long l, boolean bl) {
        if (bl) {
            return l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE;
        }
        return l >= 0L && l <= 0xFFFFFFFFL;
    }

    public static boolean checkSmallInt(int n, boolean bl) {
        if (bl) {
            return n <= Short.MAX_VALUE && n >= Short.MIN_VALUE;
        }
        return n >= 0 && n <= 65535;
    }

    public static boolean checkTinyInt(short s, boolean bl) {
        if (bl) {
            return s <= 127 && s >= -128;
        }
        return s >= 0 && s <= 255;
    }

    public static boolean checkBigInt(BigInteger bigInteger, boolean bl) {
        if (bl) {
            return bigInteger.compareTo(SIGNED_BIGINT_MAX) <= 0 && bigInteger.compareTo(SIGNED_BIGINT_MIN) >= 0;
        }
        return bigInteger.compareTo(BigInteger.ZERO) >= 0 && bigInteger.compareTo(UNSIGNED_BIGINT_MAX) <= 0;
    }
}

