/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.support.security;

import com.cloudera.hiveserver1.support.ILogger;
import com.cloudera.hiveserver1.support.LogUtilities;
import com.cloudera.hiveserver1.support.security.ISecurityContext;
import com.cloudera.hiveserver1.support.security.SimbaCredentials;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

class SimbaSecurityContext
implements ISecurityContext {
    private final SimbaCredentials m_credentials;
    private final GSSManager m_manager;
    private final String m_spn;
    private final ILogger m_logger;
    private GSSContext m_context;
    private static Oid GSS_KRB5_MECH_OID;
    private boolean m_requestMutualAuthentication = false;
    private boolean m_requestDelegation = false;

    public SimbaSecurityContext(SimbaCredentials simbaCredentials, ILogger iLogger, String string, GSSManager gSSManager) throws GSSException {
        if (null == GSS_KRB5_MECH_OID) {
            GSS_KRB5_MECH_OID = new Oid("1.2.840.113554.1.2.2");
        }
        this.m_manager = gSSManager;
        this.m_credentials = simbaCredentials;
        this.m_spn = string;
        this.m_logger = iLogger;
        LogUtilities.logFunctionEntrance(this.m_logger, simbaCredentials, iLogger, string, gSSManager);
    }

    @Override
    public byte[] getToken() throws GSSException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.updateToken(null);
    }

    @Override
    public byte[] updateToken(byte[] byArray) throws GSSException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{byArray});
        if (null == byArray) {
            GSSName gSSName = this.m_manager.createName(this.m_spn, null, GSS_KRB5_MECH_OID);
            this.m_context = this.m_manager.createContext(gSSName, GSS_KRB5_MECH_OID, this.m_credentials.getCredentialHandle(), 0);
            this.m_context.requestMutualAuth(this.m_requestMutualAuthentication);
            this.m_context.requestCredDeleg(this.m_requestDelegation);
            byArray = new byte[]{};
        }
        return this.m_context.initSecContext(byArray, 0, byArray.length);
    }

    @Override
    public void setRequestMutualAuthentication(boolean bl) throws Exception {
        if (null != this.m_context) {
            this.m_context.requestMutualAuth(bl);
        }
        this.m_requestMutualAuthentication = bl;
    }

    @Override
    public boolean getRequestMutualAuthentication() {
        return this.m_requestMutualAuthentication;
    }

    @Override
    public void setRequestDelegation(boolean bl) throws Exception {
        if (null != this.m_context) {
            this.m_context.requestCredDeleg(bl);
        }
        this.m_requestDelegation = bl;
    }

    @Override
    public boolean getRequestDelegation() {
        return this.m_requestDelegation;
    }
}

