/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.hivecommon.api;

import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TColumnDesc;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TExecuteStatementResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TFetchResultsReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TFetchResultsResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetResultSetMetadataReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetResultSetMetadataResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TOperationHandle;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TSparkDirectResults;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.ColumnMetadata;
import com.cloudera.hiveserver2.hivecommon.HiveJDBCSettings;
import com.cloudera.hiveserver2.hivecommon.api.HiveMultiSocketFetchContext;
import com.cloudera.hiveserver2.hivecommon.core.HiveJDBCStatement;
import com.cloudera.hiveserver2.support.ILogger;
import com.cloudera.hiveserver2.support.LogUtilities;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class HiveOperationContext {
    public TExecuteStatementResp m_executeResponse = null;
    private static final long HC_ROW_COUNT_UNKNOWN = -1L;
    static final boolean HC_DEFAULT_HAS_ROWCOUNT_RESULT = false;
    public TFetchResultsReq m_fetchResultsReq = null;
    public short[] m_columnTypes = null;
    public boolean m_hasOpenOperation = false;
    public AtomicBoolean m_isManualCanceled = new AtomicBoolean(false);
    public Throwable m_backgroundFetcherError = null;
    public Semaphore m_fetchEndSemaphore = new Semaphore(0);
    public long m_foregroundThreadID = -1L;
    public long m_backgroundThreadID = -1L;
    public long m_startTime = 0L;
    public long m_timeoutVal = 0L;
    public String m_operation = null;
    public ArrayList<ColumnMetadata> m_sencolumns = null;
    public boolean m_isExecutionComplete = false;
    public boolean m_serverHasMoreRows = true;
    public boolean m_hasDROperationStatusResp = false;
    public boolean m_hasDRGetRsmdResp = false;
    public boolean m_hasDRFetchResp = false;
    public boolean m_hasDRCloseOpResp = false;
    public boolean m_isLz4Compressed = false;
    public TSparkDirectResults m_directResults = null;
    public boolean m_hasArrowResults = false;
    public List<TColumnDesc> m_rsMdColumns = null;
    public HiveJDBCStatement m_statement;
    public int m_fetchSize = 0;
    public long m_rowCount = -1L;
    public boolean m_hasRowcountResult = false;
    public long m_driverSideStartRowOffset;
    public HiveJDBCSettings m_settings;
    public boolean m_isServerReturnedResultLinks = false;
    public boolean m_heartbeatRegistered = false;
    public TGetResultSetMetadataReq m_RsMdReq;
    public TGetResultSetMetadataResp m_RsMdResp;
    public HiveMultiSocketFetchContext m_multiSocketFetchCtx;
    public TFetchResultsResp queryLogResultsResp;

    public HiveOperationContext(HiveJDBCSettings hiveJDBCSettings) {
        this.m_settings = hiveJDBCSettings;
        this.m_multiSocketFetchCtx = new HiveMultiSocketFetchContext();
    }

    public ILogger getLogger() {
        if (null != this.m_statement) {
            return this.m_statement.getLog();
        }
        return null;
    }

    public HiveJDBCStatement getStatement() {
        return this.m_statement;
    }

    public boolean isCanceled() {
        if (null != this.m_statement) {
            return this.m_statement.isCanceled();
        }
        return false;
    }

    public void setStatement(HiveJDBCStatement hiveJDBCStatement) {
        this.m_statement = hiveJDBCStatement;
    }

    protected void handleDirectResultsResp(ILogger iLogger, TSparkDirectResults tSparkDirectResults) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        this.m_directResults = tSparkDirectResults;
        this.m_hasDROperationStatusResp = tSparkDirectResults.isSetOperationStatus();
        this.m_hasDRGetRsmdResp = tSparkDirectResults.isSetResultSetMetadata();
        this.m_hasDRFetchResp = tSparkDirectResults.isSetResultSet();
        this.m_hasDRCloseOpResp = tSparkDirectResults.isSetCloseOperation();
        String string = "Received: operationStatus=" + (this.m_hasDROperationStatusResp ? "true" : "false") + ", resultSetMetadata=" + (this.m_hasDRGetRsmdResp ? "true" : "false") + ", resultSet=" + (this.m_hasDRFetchResp ? "true" : "false") + ", closeOperation=" + (this.m_hasDRCloseOpResp ? "true" : "false");
        LogUtilities.logDebug(string, iLogger);
    }

    public abstract TOperationHandle getOperationHandle();
}

