/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.hivecommon.jdbc42;

import com.cloudera.hiveserver2.dsi.dataengine.utilities.ExecutionResult;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.ParameterMetadata;
import com.cloudera.hiveserver2.hivecommon.HiveJDBCSettings;
import com.cloudera.hiveserver2.hivecommon.core.CoreUtils;
import com.cloudera.hiveserver2.hivecommon.core.HiveJDBCCommonConnection;
import com.cloudera.hiveserver2.hivecommon.core.HiveJDBCStatement;
import com.cloudera.hiveserver2.hivecommon.dataengine.HiveJDBCResultSet;
import com.cloudera.hiveserver2.hivecommon.jdbc42.Hive42ForwardMaterializedResultSet;
import com.cloudera.hiveserver2.hivecommon.jdbc42.Hive42ForwardResultSet;
import com.cloudera.hiveserver2.jdbc.common.SConnection;
import com.cloudera.hiveserver2.jdbc.common.SStatement;
import com.cloudera.hiveserver2.jdbc.jdbc42.S42PreparedStatement;
import com.cloudera.hiveserver2.support.LogUtilities;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

public class Hive42PreparedStatement
extends S42PreparedStatement {
    private HiveJDBCSettings m_settings;

    public Hive42PreparedStatement(String string, HiveJDBCStatement hiveJDBCStatement, SConnection sConnection, int n) throws SQLException {
        super(string, hiveJDBCStatement, sConnection, n);
        this.m_settings = hiveJDBCStatement.getSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() throws SQLException {
        super.cancel();
        Object object = this.m_cancelLock;
        synchronized (object) {
            if (this.m_statement instanceof HiveJDBCStatement && this.m_isInCancelableFunction) {
                ((HiveJDBCStatement)this.m_statement).cancel();
            }
        }
    }

    public boolean getAsyncExecution() {
        return ((HiveJDBCStatement)this.m_statement).getAsyncExecution();
    }

    public HiveJDBCSettings getSettings() throws SQLException {
        Connection connection = this.getConnection();
        if (connection instanceof HiveJDBCCommonConnection) {
            return ((HiveJDBCCommonConnection)((Object)connection)).getSettings();
        }
        return null;
    }

    @Override
    public synchronized void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        ((ParameterMetadata)this.m_parameterMetadata.get(n - 1)).setConvertInputToString(true);
        super.setBigDecimal(n, bigDecimal);
    }

    @Override
    public synchronized void setObject(int n, Object object) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, object);
        if (!CoreUtils.setBigDecimalObject(this, n, object, this.getSettings())) {
            super.setObject(n, object);
        }
    }

    @Override
    public synchronized void setObject(int n, Object object, int n2) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, object, n2);
        if (!CoreUtils.setBigDecimalObject(this, n, object, this.getSettings())) {
            super.setObject(n, object, n2);
        }
    }

    @Override
    protected ResultSet createResultSet(ExecutionResult executionResult) throws SQLException {
        ResultSet resultSet = null;
        if (this.m_settings.m_isEnableDataWrapperMaterialization && executionResult.getResult() instanceof HiveJDBCResultSet) {
            resultSet = new Hive42ForwardMaterializedResultSet(this, (HiveJDBCResultSet)executionResult.getResult(), this.m_logger, this.m_settings);
        } else if (this.getAsyncExecution() && executionResult.getResult() instanceof HiveJDBCResultSet) {
            resultSet = new Hive42ForwardResultSet((SStatement)this, (HiveJDBCResultSet)executionResult.getResult(), this.m_logger);
            resultSet.setFetchSize(this.getFetchSize());
        } else {
            resultSet = super.createResultSet(executionResult);
        }
        return resultSet;
    }
}

