/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.hivecommon.querytranslation;

import com.cloudera.hiveserver2.dsi.dataengine.utilities.TypeUtilities;
import com.cloudera.hiveserver2.hivecommon.IServerVersion;
import com.cloudera.hiveserver2.hivecommon.IServerVersionUtils;
import com.cloudera.hiveserver2.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.hiveserver2.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.IAENodeVisitor;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.ScalarFunctionID;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.value.AEScalarFn;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.value.AEValueExprList;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;
import java.util.EnumMap;
import java.util.Iterator;

public class ScalarFunctionTranslator {
    private static final EnumMap<ScalarFunctionID, String> s_scalarFnToHiveFnMap = new EnumMap(ScalarFunctionID.class);
    private IAENodeVisitor<String> m_baseVisitor;
    private final SERVER_TYPE m_serverType;
    private IServerVersion m_serverVersion;
    private IServerVersionUtils m_serverVersionUtils;

    public ScalarFunctionTranslator(IAENodeVisitor<String> iAENodeVisitor, SERVER_TYPE sERVER_TYPE, IServerVersionUtils iServerVersionUtils, IServerVersion iServerVersion) {
        this.m_serverType = sERVER_TYPE;
        this.m_baseVisitor = iAENodeVisitor;
        this.m_serverVersionUtils = iServerVersionUtils;
        this.m_serverVersion = iServerVersion;
    }

    public String translateScalarFunction(AEScalarFn aEScalarFn) throws ErrorException {
        AEValueExprList aEValueExprList = (AEValueExprList)aEScalarFn.getChildItr().next();
        switch (aEScalarFn.getScalarFnId()) {
            case MOD: {
                return this.translateMod(aEValueExprList);
            }
            case COT: {
                return this.translateCot(aEValueExprList);
            }
            case ATAN2: {
                return this.translateATan2(aEValueExprList);
            }
            case LENGTH: {
                return this.translateLength(aEValueExprList);
            }
            case INSERT: {
                return this.translateInsert(aEValueExprList);
            }
            case LEFT: {
                return this.translateLeft(aEValueExprList);
            }
            case RIGHT: {
                return this.translateRight(aEValueExprList);
            }
            case QUARTER: {
                return this.translateQuarter(aEValueExprList);
            }
            case MONTHNAME: {
                return this.translateMonthName(aEValueExprList);
            }
            case IFNULL: {
                return this.translateIfNull(aEValueExprList);
            }
            case CHAR: {
                return this.translateChar(aEValueExprList);
            }
            case REPLACE: {
                return this.translateReplace(aEValueExprList);
            }
            case CONVERT2: 
            case CONVERT3: 
            case CONVERT4: 
            case CAST2: 
            case CAST3: 
            case CAST4: {
                return this.translateCast(aEScalarFn);
            }
            case NOW: 
            case CURRENT_TIMESTAMP: {
                return this.translateCurrentTime();
            }
            case WEEK: {
                return this.translateWeek(aEValueExprList);
            }
            case DAYOFWEEK: {
                return this.translateDayOfWeek(aEValueExprList);
            }
            case DAYNAME: {
                return this.translateDayName(aEValueExprList);
            }
            case DAYOFYEAR: {
                return this.translateDayOfYear(aEValueExprList);
            }
            case CURRENT_DATE: {
                return this.translateCurrentDate();
            }
        }
        String string = s_scalarFnToHiveFnMap.get((Object)aEScalarFn.getScalarFnId());
        if (null == string) {
            throw new ErrorException("Error", "Scalar function cannot be mapped.", 0);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append('(');
        stringBuilder.append(aEValueExprList.acceptVisitor(this.m_baseVisitor));
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    private String translateATan2(AEValueExprList aEValueExprList) throws ErrorException {
        String string = ((AEValueExpr)aEValueExprList.getChild(0)).acceptVisitor(this.m_baseVisitor);
        String string2 = ((AEValueExpr)aEValueExprList.getChild(1)).acceptVisitor(this.m_baseVisitor);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("( CASE WHEN (").append(string2).append(" < 0) THEN ");
        stringBuilder.append("SIGN(2 * SIGN(").append(string).append(") + 1) * PI() + ");
        stringBuilder.append("ATAN(").append(string).append(" / ").append(string2).append(")");
        stringBuilder.append(" ELSE ATAN(").append(string).append(" / ").append(string2).append(")");
        stringBuilder.append(" END )");
        return stringBuilder.toString();
    }

    private String translateCast(AEScalarFn aEScalarFn) throws ErrorException {
        String string = ((AEValueExpr)aEScalarFn.getArguments().getChild(0)).acceptVisitor(this.m_baseVisitor);
        String string2 = ((AEValueExpr)aEScalarFn.getArguments().getChild(1)).acceptVisitor(this.m_baseVisitor);
        short s = aEScalarFn.getColumn().getTypeMetadata().getType();
        StringBuilder stringBuilder = new StringBuilder();
        if (TypeUtilities.isIntegerType(s)) {
            stringBuilder.append("CAST( ").append(string).append(" AS ");
            if (-6 == s) {
                stringBuilder.append("tinyint");
            } else if (5 == s) {
                stringBuilder.append("smallint");
            } else if (-5 == s) {
                stringBuilder.append("bigint");
            } else {
                stringBuilder.append("int");
            }
            stringBuilder.append(" )");
        } else if (TypeUtilities.isCharacterType(s)) {
            if (2 < aEScalarFn.getArguments().getNumChildren()) {
                if (s == 1) {
                    if (((AEValueExpr)aEScalarFn.getArguments().getChild(2)).acceptVisitor(this.m_baseVisitor).equals("0")) {
                        stringBuilder.append("CAST( ").append(string).append(" AS string )");
                    } else {
                        stringBuilder.append("CAST( ").append(string).append(" AS CHAR(").append(((AEValueExpr)aEScalarFn.getArguments().getChild(2)).acceptVisitor(this.m_baseVisitor)).append("))");
                    }
                } else if (s == 12) {
                    if (((AEValueExpr)aEScalarFn.getArguments().getChild(2)).acceptVisitor(this.m_baseVisitor).equals("0")) {
                        stringBuilder.append("CAST( ").append(string).append(" AS VARCHAR(1) )");
                    } else {
                        stringBuilder.append("CAST( ").append(string).append(" AS VARCHAR(").append(((AEValueExpr)aEScalarFn.getArguments().getChild(2)).acceptVisitor(this.m_baseVisitor)).append("))");
                    }
                } else {
                    stringBuilder.append("CAST( ").append(string).append(" AS string )");
                }
            } else {
                stringBuilder.append("CAST( ").append(string).append(" AS string )");
            }
        } else if (TypeUtilities.isApproximateNumericType(s) || TypeUtilities.isExactNumericType(s)) {
            stringBuilder.append("CAST( ").append(string).append(" AS ");
            if (6 == s) {
                stringBuilder.append("float");
            } else if (3 == s) {
                String string3;
                stringBuilder.append("decimal");
                boolean bl = true;
                try {
                    string3 = ((AEValueExpr)aEScalarFn.getArguments().getChild(2)).acceptVisitor(this.m_baseVisitor);
                    if (null != string3 && string3.length() != 0) {
                        stringBuilder.append(" (" + string3);
                    }
                }
                catch (Exception exception) {
                    bl = false;
                }
                if (bl) {
                    try {
                        string3 = ((AEValueExpr)aEScalarFn.getArguments().getChild(3)).acceptVisitor(this.m_baseVisitor);
                        if (null != string3 && string3.length() != 0) {
                            stringBuilder.append(", " + string3);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    stringBuilder.append(")");
                }
            } else {
                stringBuilder.append("double");
            }
            stringBuilder.append(" )");
        } else if (TypeUtilities.isDateTimeType(s)) {
            if (91 == s && this.m_serverVersionUtils.supportsTypeDate(this.m_serverVersion)) {
                stringBuilder.append("CAST( ").append(string).append(" AS date )");
            } else {
                stringBuilder.append("CAST( ").append(string).append(" AS timestamp )");
            }
        } else if (16 == s) {
            stringBuilder.append("CAST( ").append(string).append(" AS boolean )");
        } else {
            throw new ErrorException("Error", "Cannot cast to " + string2, 0);
        }
        return stringBuilder.toString();
    }

    private String translateChar(AEValueExprList aEValueExprList) throws ErrorException {
        String string = ((AEValueExpr)aEValueExprList.getChild(0)).acceptVisitor(this.m_baseVisitor);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CAST(UNHEX(HEX(CAST(").append(string).append(" AS int))) AS string)");
        return stringBuilder.toString();
    }

    private String translateCot(AEValueExprList aEValueExprList) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(1 / TAN(").append(((AEValueExpr)aEValueExprList.getChild(0)).acceptVisitor(this.m_baseVisitor)).append("))");
        return stringBuilder.toString();
    }

    private String translateCurrentDate() throws ErrorException {
        if (SERVER_TYPE.HIVE == this.m_serverType || SERVER_TYPE.IMPALA == this.m_serverType) {
            return "CURRENT_DATE()";
        }
        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_TRANSLATION_SCALARFN_NOT_SUPPORTED_ERR.name(), "CURRENT_DATE");
        throw errorException;
    }

    private String translateCurrentTime() {
        if (SERVER_TYPE.IMPALA == this.m_serverType) {
            return "NOW()";
        }
        return "CAST(UNIX_TIMESTAMP() AS TIMESTAMP)";
    }

    private String translateCustomFunctions(AEScalarFn aEScalarFn, AEValueExprList aEValueExprList) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        String string = aEScalarFn.getScalarFnName();
        Iterator iterator = aEValueExprList.getChildItr();
        stringBuilder.append(string).append("(");
        boolean bl = true;
        while (iterator.hasNext()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append(((AEValueExpr)iterator.next()).acceptVisitor(this.m_baseVisitor));
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private String translateDayName(AEValueExprList aEValueExprList) throws ErrorException {
        if (SERVER_TYPE.IMPALA == this.m_serverType) {
            String string = ((AEValueExpr)aEValueExprList.getChild(0)).acceptVisitor(this.m_baseVisitor);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("DAYNAME(").append(string).append(")");
            return stringBuilder.toString();
        }
        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_TRANSLATION_SCALARFN_NOT_SUPPORTED_ERR.name(), "DAYNAME");
        throw errorException;
    }

    private String translateDayOfWeek(AEValueExprList aEValueExprList) throws ErrorException {
        if (SERVER_TYPE.IMPALA == this.m_serverType) {
            String string = ((AEValueExpr)aEValueExprList.getChild(0)).acceptVisitor(this.m_baseVisitor);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("DAYOFWEEK(").append(string).append(")");
            return stringBuilder.toString();
        }
        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_TRANSLATION_SCALARFN_NOT_SUPPORTED_ERR.name(), "DAYOFWEEK");
        throw errorException;
    }

    private String translateDayOfYear(AEValueExprList aEValueExprList) throws ErrorException {
        if (SERVER_TYPE.IMPALA == this.m_serverType) {
            String string = ((AEValueExpr)aEValueExprList.getChild(0)).acceptVisitor(this.m_baseVisitor);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("DAYOFYEAR(").append(string).append(")");
            return stringBuilder.toString();
        }
        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_TRANSLATION_SCALARFN_NOT_SUPPORTED_ERR.name(), "DAYOFYEAR");
        throw errorException;
    }

    private String translateIfNull(AEValueExprList aEValueExprList) throws ErrorException {
        String string = ((AEValueExpr)aEValueExprList.getChild(0)).acceptVisitor(this.m_baseVisitor);
        String string2 = ((AEValueExpr)aEValueExprList.getChild(1)).acceptVisitor(this.m_baseVisitor);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(CASE WHEN ").append(string).append(" IS NULL THEN ").append(string2).append(" ELSE ").append(string).append(" END)");
        return stringBuilder.toString();
    }

    private String translateInsert(AEValueExprList aEValueExprList) throws ErrorException {
        String string = ((AEValueExpr)aEValueExprList.getChild(0)).acceptVisitor(this.m_baseVisitor);
        String string2 = ((AEValueExpr)aEValueExprList.getChild(1)).acceptVisitor(this.m_baseVisitor);
        String string3 = ((AEValueExpr)aEValueExprList.getChild(2)).acceptVisitor(this.m_baseVisitor);
        String string4 = ((AEValueExpr)aEValueExprList.getChild(3)).acceptVisitor(this.m_baseVisitor);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CONCAT(SUBSTR(").append(string).append(", 1, CAST(").append(string2).append(" -1 AS INT)), ").append(string4).append(", SUBSTR(").append(string).append(", CAST(").append(string2).append(" + ").append(string3).append(" AS INT), CAST(LENGTH(").append(string).append(") - ").append(string2).append(" + 1 - ").append(string3).append(" AS INT)))");
        return stringBuilder.toString();
    }

    private String translateLeft(AEValueExprList aEValueExprList) throws ErrorException {
        String string = ((AEValueExpr)aEValueExprList.getChild(0)).acceptVisitor(this.m_baseVisitor);
        String string2 = ((AEValueExpr)aEValueExprList.getChild(1)).acceptVisitor(this.m_baseVisitor);
        StringBuilder stringBuilder = new StringBuilder();
        if (this.m_serverVersionUtils.supportsLeftFunction(this.m_serverVersion)) {
            stringBuilder.append("LEFT(").append(string).append(", ").append(string2).append(")");
        } else {
            stringBuilder.append("SUBSTR(").append(string).append(", 1, ").append(string2);
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    private String translateLength(AEValueExprList aEValueExprList) throws ErrorException {
        String string = ((AEValueExpr)aEValueExprList.getChild(0)).acceptVisitor(this.m_baseVisitor);
        StringBuilder stringBuilder = new StringBuilder();
        short s = ((AEValueExpr)aEValueExprList.getChild(0)).getColumn().getTypeMetadata().getType();
        if (TypeUtilities.isCharacterType(s)) {
            stringBuilder.append("LENGTH(RTRIM(").append(string).append("))");
        } else if (16 == s) {
            stringBuilder.append("LENGTH(CAST(").append(string).append(" AS STRING))");
        } else {
            stringBuilder.append("LENGTH(").append(string).append(")");
        }
        return stringBuilder.toString();
    }

    private String translateMod(AEValueExprList aEValueExprList) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("( ").append(((AEValueExpr)aEValueExprList.getChild(0)).acceptVisitor(this.m_baseVisitor)).append(" % ").append(((AEValueExpr)aEValueExprList.getChild(1)).acceptVisitor(this.m_baseVisitor)).append(" )");
        return stringBuilder.toString();
    }

    private String translateMonthName(AEValueExprList aEValueExprList) throws ErrorException {
        String string = ((AEValueExpr)aEValueExprList.getChild(0)).acceptVisitor(this.m_baseVisitor);
        StringBuilder stringBuilder = new StringBuilder();
        if (this.m_serverVersionUtils.supportsMonthNameFunction(this.m_serverVersion)) {
            stringBuilder.append("MONTHNAME(").append(string).append(")");
        } else {
            stringBuilder.append("(CASE MONTH(").append(string).append(")").append(" WHEN 1 THEN 'January'").append(" WHEN 2 THEN 'February'").append(" WHEN 3 THEN 'March'").append(" WHEN 4 THEN 'April'").append(" WHEN 5 THEN 'May'").append(" WHEN 6 THEN 'June'").append(" WHEN 7 THEN 'July'").append(" WHEN 8 THEN 'August'").append(" WHEN 9 THEN 'September'").append(" WHEN 10 THEN 'October'").append(" WHEN 11 THEN 'November'").append(" WHEN 12 THEN 'December'").append(" END)");
        }
        return stringBuilder.toString();
    }

    private String translateQuarter(AEValueExprList aEValueExprList) throws ErrorException {
        String string = ((AEValueExpr)aEValueExprList.getChild(0)).acceptVisitor(this.m_baseVisitor);
        StringBuilder stringBuilder = new StringBuilder();
        if (this.m_serverVersionUtils.supportsQuarterFunction(this.m_serverVersion)) {
            stringBuilder.append("QUARTER(").append(string).append(")");
        } else {
            stringBuilder.append("(CASE MONTH(").append(string).append(")").append(" WHEN 1 THEN 1").append(" WHEN 2 THEN 1").append(" WHEN 3 THEN 1").append(" WHEN 4 THEN 2").append(" WHEN 5 THEN 2").append(" WHEN 6 THEN 2").append(" WHEN 7 THEN 3").append(" WHEN 8 THEN 3").append(" WHEN 9 THEN 3").append(" WHEN 10 THEN 4").append(" WHEN 11 THEN 4").append(" WHEN 12 THEN 4").append(" END)");
        }
        return stringBuilder.toString();
    }

    private String translateReplace(AEValueExprList aEValueExprList) throws ErrorException {
        Iterator iterator = aEValueExprList.getChildItr();
        String string = ((AEValueExpr)iterator.next()).acceptVisitor(this.m_baseVisitor);
        String string2 = ((AEValueExpr)iterator.next()).acceptVisitor(this.m_baseVisitor);
        String string3 = ((AEValueExpr)iterator.next()).acceptVisitor(this.m_baseVisitor);
        StringBuilder stringBuilder = new StringBuilder();
        if (this.m_serverType == SERVER_TYPE.IMPALA) {
            stringBuilder.append("REGEXP_REPLACE(").append(string).append(", ").append(string2);
            stringBuilder.append(", ").append("REGEXP_REPLACE(").append(string3).append(", '\\\\\\\\', '\\\\\\\\\\\\\\\\')");
            stringBuilder.append(")");
        } else {
            stringBuilder.append("REGEXP_REPLACE(").append(string);
            stringBuilder.append(", ").append("CONCAT('\\\\Q', ").append(string2).append(")");
            stringBuilder.append(", ").append("REGEXP_REPLACE(").append(string3).append(", ").append("'[\\\\.\\\\[\\\\]\\\\{\\\\}\\\\(\\\\)\\\\*\\\\+\\\\?\\\\|\\\\^\\\\$\\\\\\\\]'").append(", ").append("'\\\\\\\\$0'").append(")");
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    private String translateRight(AEValueExprList aEValueExprList) throws ErrorException {
        String string = ((AEValueExpr)aEValueExprList.getChild(0)).acceptVisitor(this.m_baseVisitor);
        String string2 = ((AEValueExpr)aEValueExprList.getChild(1)).acceptVisitor(this.m_baseVisitor);
        StringBuilder stringBuilder = new StringBuilder();
        if (this.m_serverVersionUtils.supportsRightFunction(this.m_serverVersion)) {
            stringBuilder.append("RIGHT(").append(string).append(", ").append(string2).append(")");
        } else {
            stringBuilder.append("SUBSTR(").append(string).append(", CASE WHEN LENGTH(").append(string).append(") < ").append(string2).append(" THEN 1 ELSE CAST(LENGTH(").append(string).append(") - ").append(string2).append(" + 1 AS INT) END)");
        }
        return stringBuilder.toString();
    }

    private String translateWeek(AEValueExprList aEValueExprList) throws ErrorException {
        String string = ((AEValueExpr)aEValueExprList.getChild(0)).acceptVisitor(this.m_baseVisitor);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.m_serverVersionUtils.supportsWeekFunction(this.m_serverVersion) ? "WEEK(" : "WEEKOFYEAR(").append(string).append(")");
        return stringBuilder.toString();
    }

    static {
        s_scalarFnToHiveFnMap.put(ScalarFunctionID.ASCII, "ASCII");
        s_scalarFnToHiveFnMap.put(ScalarFunctionID.CONCAT, "CONCAT");
        s_scalarFnToHiveFnMap.put(ScalarFunctionID.LCASE, "LOWER");
        s_scalarFnToHiveFnMap.put(ScalarFunctionID.LOWER, "LOWER");
        s_scalarFnToHiveFnMap.put(ScalarFunctionID.LEFT, "LEFT");
        s_scalarFnToHiveFnMap.put(ScalarFunctionID.LOCATE2, "LOCATE");
        s_scalarFnToHiveFnMap.put(ScalarFunctionID.LOCATE3, "LOCATE");
        s_scalarFnToHiveFnMap.put(ScalarFunctionID.REPEAT, "REPEAT");
        s_scalarFnToHiveFnMap.put(ScalarFunctionID.RIGHT, "RIGHT");
        s_scalarFnToHiveFnMap.put(ScalarFunctionID.SPACE, "SPACE");
        s_scalarFnToHiveFnMap.put(ScalarFunctionID.SUBSTRING2, "SUBSTR");
        s_scalarFnToHiveFnMap.put(ScalarFunctionID.SUBSTRING3, "SUBSTR");
        s_scalarFnToHiveFnMap.put(ScalarFunctionID.UCASE, "UPPER");
        s_scalarFnToHiveFnMap.put(ScalarFunctionID.UPPER, "UPPER");
        s_scalarFnToHiveFnMap.put(ScalarFunctionID.LTRIM, "LTRIM");
        s_scalarFnToHiveFnMap.put(ScalarFunctionID.RTRIM, "RTRIM");
        s_scalarFnToHiveFnMap.put(ScalarFunctionID.ABS, "ABS");
        s_scalarFnToHiveFnMap.put(ScalarFunctionID.ACOS, "ACOS");
        s_scalarFnToHiveFnMap.put(ScalarFunctionID.ASIN, "ASIN");
        s_scalarFnToHiveFnMap.put(ScalarFunctionID.ATAN, "ATAN");
        s_scalarFnToHiveFnMap.put(ScalarFunctionID.CEILING, "CEIL");
        s_scalarFnToHiveFnMap.put(ScalarFunctionID.COS, "COS");
        s_scalarFnToHiveFnMap.put(ScalarFunctionID.DEGREES, "DEGREES");
        s_scalarFnToHiveFnMap.put(ScalarFunctionID.EXP, "EXP");
        s_scalarFnToHiveFnMap.put(ScalarFunctionID.FLOOR, "FLOOR");
        s_scalarFnToHiveFnMap.put(ScalarFunctionID.LOG, "LN");
        s_scalarFnToHiveFnMap.put(ScalarFunctionID.LOG10, "LOG10");
        s_scalarFnToHiveFnMap.put(ScalarFunctionID.PI, "PI");
        s_scalarFnToHiveFnMap.put(ScalarFunctionID.POWER, "POW");
        s_scalarFnToHiveFnMap.put(ScalarFunctionID.RADIANS, "RADIANS");
        s_scalarFnToHiveFnMap.put(ScalarFunctionID.RAND0, "RAND");
        s_scalarFnToHiveFnMap.put(ScalarFunctionID.RAND1, "RAND");
        s_scalarFnToHiveFnMap.put(ScalarFunctionID.ROUND, "ROUND");
        s_scalarFnToHiveFnMap.put(ScalarFunctionID.SIN, "SIN");
        s_scalarFnToHiveFnMap.put(ScalarFunctionID.SQRT, "SQRT");
        s_scalarFnToHiveFnMap.put(ScalarFunctionID.TAN, "TAN");
        s_scalarFnToHiveFnMap.put(ScalarFunctionID.CONVERT2, "CONVERT");
        s_scalarFnToHiveFnMap.put(ScalarFunctionID.CONVERT3, "CONVERT");
        s_scalarFnToHiveFnMap.put(ScalarFunctionID.CONVERT4, "CONVERT");
        s_scalarFnToHiveFnMap.put(ScalarFunctionID.SIGN, "SIGN");
        s_scalarFnToHiveFnMap.put(ScalarFunctionID.DAYOFMONTH, "DAY");
        s_scalarFnToHiveFnMap.put(ScalarFunctionID.HOUR, "HOUR");
        s_scalarFnToHiveFnMap.put(ScalarFunctionID.MINUTE, "MINUTE");
        s_scalarFnToHiveFnMap.put(ScalarFunctionID.SECOND, "SECOND");
        s_scalarFnToHiveFnMap.put(ScalarFunctionID.MONTH, "MONTH");
        s_scalarFnToHiveFnMap.put(ScalarFunctionID.WEEK, "WEEK");
        s_scalarFnToHiveFnMap.put(ScalarFunctionID.YEAR, "YEAR");
    }

    public static enum SERVER_TYPE {
        HIVE,
        IMPALA;

    }
}

