/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.hivecommon.querytranslation.hql;

import com.cloudera.hiveserver2.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.hiveserver2.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.AEDefaultVisitor;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.IAENode;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.relation.AENamedRelationalExpr;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.relation.AETable;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;
import java.util.HashMap;
import java.util.Iterator;

public class TableAliasGenerator
extends AEDefaultVisitor<String> {
    private HashMap<AENamedRelationalExpr, String> m_generatedTableAlias;

    public TableAliasGenerator(IAENode iAENode) throws ErrorException {
        try {
            this.m_generatedTableAlias = new HashMap();
            this.defaultVisit(iAENode);
        }
        catch (ErrorException errorException) {
            ErrorException errorException2 = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_TRANSLATION_ERR.name(), "translation error");
            throw errorException2;
        }
    }

    public HashMap<AENamedRelationalExpr, String> getGeneratedTableAlias() {
        return this.m_generatedTableAlias;
    }

    @Override
    public String visit(AETable aETable) throws ErrorException {
        if (!aETable.hasCorrelationName()) {
            String string = aETable.getSchemaName() + "_" + aETable.getTableName();
            this.m_generatedTableAlias.put(aETable, string);
        }
        this.defaultVisit(aETable);
        return null;
    }

    @Override
    public String defaultVisit(IAENode iAENode) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<? extends IAENode> iterator = iAENode.getChildItr();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next().acceptVisitor(this));
        }
        return stringBuilder.toString();
    }
}

