/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.jdbc.common;

import com.cloudera.hiveserver2.dsi.core.interfaces.IConnection;
import com.cloudera.hiveserver2.dsi.dataengine.interfaces.IArray;
import com.cloudera.hiveserver2.dsi.dataengine.interfaces.future.IJDBCArray;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.TypeMetadata;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.TypeUtilities;
import com.cloudera.hiveserver2.dsi.exceptions.IncorrectTypeException;
import com.cloudera.hiveserver2.exceptions.ExceptionConverter;
import com.cloudera.hiveserver2.exceptions.JDBCMessageKey;
import com.cloudera.hiveserver2.support.ILogger;
import com.cloudera.hiveserver2.support.IWarningListener;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;
import com.cloudera.hiveserver2.support.exceptions.ExceptionType;
import com.cloudera.hiveserver2.utilities.conversion.TypeConverter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

public abstract class SArray
implements IJDBCArray {
    protected static final int RETRIEVE_ALL_DATA = -1;
    private IArray m_array;
    private IConnection m_parentConnection;
    private ILogger m_logger;
    private IWarningListener m_warningListener;

    public SArray(IArray iArray, IConnection iConnection, ILogger iLogger, IWarningListener iWarningListener) {
        this.m_array = iArray;
        this.m_parentConnection = iConnection;
        this.m_logger = iLogger;
        this.m_warningListener = iWarningListener;
    }

    @Override
    public Object getArray() throws SQLException {
        try {
            return this.createArray(1L, -1);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener());
        }
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.FEATURE_NOT_SUPPORTED, this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, "getArray(Map)");
    }

    @Override
    public Object getArray(long l, int n) throws SQLException {
        try {
            return this.createArray(l, n);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener());
        }
    }

    @Override
    public Object getArray(long l, int n, Map<String, Class<?>> map) throws SQLException {
        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.FEATURE_NOT_SUPPORTED, this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, "getArray(long,int,Map)");
    }

    @Override
    public int getBaseType() throws SQLException {
        try {
            TypeMetadata typeMetadata = this.m_array.getBaseColumn().getTypeMetadata();
            return TypeUtilities.mapDataTypes(typeMetadata.getType());
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        return this.m_array.getBaseColumn().getTypeMetadata().getTypeName();
    }

    public final int getUnmappedBaseType() throws SQLException {
        try {
            return this.m_array.getBaseColumn().getTypeMetadata().getType();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        try {
            return this.createResultSet(1L, -1);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.FEATURE_NOT_SUPPORTED, this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, "getResultSet(Map)");
    }

    @Override
    public ResultSet getResultSet(long l, int n) throws SQLException {
        try {
            return this.createResultSet(l, n);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public ResultSet getResultSet(long l, int n, Map<String, Class<?>> map) throws SQLException {
        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.FEATURE_NOT_SUPPORTED, this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, "getResultSet(long,int,Map)");
    }

    @Override
    public void free() throws SQLException {
        try {
            this.m_array.free();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    public String toString() {
        return this.getDSIArray().getStringRepresentation();
    }

    protected Object createArray(long l, int n) throws SQLException {
        try {
            Object object = this.getDSIArray().createArray(l - 1L, n);
            if (2003 == this.getBaseType()) {
                int n2 = TypeUtilities.getDimensionofArray(this.getDSIArray());
                Object object2 = this.createArrayHelper(n2, l, n, object);
                return object2;
            }
            return object;
        }
        catch (ErrorException errorException) {
            throw ExceptionConverter.getInstance().toSQLException(errorException, this.getWarningListener());
        }
    }

    protected abstract ResultSet createResultSet(long var1, int var3) throws SQLException;

    @Override
    public IArray getDSIArray() {
        return this.m_array;
    }

    protected ILogger getLogger() {
        return this.m_logger;
    }

    protected IConnection getParentConnection() {
        return this.m_parentConnection;
    }

    protected IWarningListener getWarningListener() {
        return this.m_warningListener;
    }

    protected Object createArrayHelper(int n, long l, int n2, Object object) throws SQLException, ErrorException {
        Object[] objectArray;
        if (n == 0) {
            try {
                objectArray = TypeConverter.convertToObjectArray(object);
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw ExceptionConverter.getInstance().toSQLException(incorrectTypeException, this.getWarningListener());
            }
        } else {
            IArray[] iArrayArray = (IArray[])object;
            int n3 = iArrayArray.length;
            objectArray = new Object[n3];
            for (int i = 0; i < n3; ++i) {
                if (null == iArrayArray[i]) continue;
                Object object2 = iArrayArray[i].createArray(l - 1L, n2);
                objectArray[i] = this.createArrayHelper(n - 1, l, n2, object2);
            }
        }
        return objectArray;
    }
}

