/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.jdbc.common;

import com.cloudera.hiveserver2.dsi.core.impl.DSIDriver;
import com.cloudera.hiveserver2.dsi.core.impl.DSIDriverSingleton;
import com.cloudera.hiveserver2.dsi.core.impl.DSILogger;
import com.cloudera.hiveserver2.dsi.core.interfaces.IBlobFactory;
import com.cloudera.hiveserver2.dsi.core.interfaces.IClobFactory;
import com.cloudera.hiveserver2.dsi.core.interfaces.IConnection;
import com.cloudera.hiveserver2.dsi.core.interfaces.IStatement;
import com.cloudera.hiveserver2.dsi.core.utilities.ClientInfoData;
import com.cloudera.hiveserver2.dsi.core.utilities.PropertyUtilities;
import com.cloudera.hiveserver2.dsi.core.utilities.Variant;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.ParameterGeneratedValues;
import com.cloudera.hiveserver2.dsi.exceptions.BadPropertyKeyException;
import com.cloudera.hiveserver2.dsi.exceptions.IncorrectTypeException;
import com.cloudera.hiveserver2.dsi.exceptions.NumericOverflowException;
import com.cloudera.hiveserver2.dsi.utilities.DSIMessageKey;
import com.cloudera.hiveserver2.exceptions.ExceptionConverter;
import com.cloudera.hiveserver2.exceptions.JDBCMessageKey;
import com.cloudera.hiveserver2.jdbc.common.BaseStatement;
import com.cloudera.hiveserver2.jdbc.common.JDBCObjectFactory;
import com.cloudera.hiveserver2.jdbc.common.SSavepoint;
import com.cloudera.hiveserver2.jdbc.common.STransactionStateListener;
import com.cloudera.hiveserver2.jdbc.common.SWarningListener;
import com.cloudera.hiveserver2.jdbc.common.utilities.WrapperUtilities;
import com.cloudera.hiveserver2.jdbc.interfaces.IDatabaseMetaData;
import com.cloudera.hiveserver2.jdbc.interfaces.IJDBCCallableStatement;
import com.cloudera.hiveserver2.jdbc.interfaces.IJDBCConnection;
import com.cloudera.hiveserver2.jdbc.interfaces.IJDBCObjectFactory;
import com.cloudera.hiveserver2.jdbc.interfaces.IJDBCPreparedStatement;
import com.cloudera.hiveserver2.jdbc.interfaces.IJDBCStatement;
import com.cloudera.hiveserver2.support.ILogger;
import com.cloudera.hiveserver2.support.IWarningListener;
import com.cloudera.hiveserver2.support.LogUtilities;
import com.cloudera.hiveserver2.support.Warning;
import com.cloudera.hiveserver2.support.exceptions.ClientInfoException;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;
import com.cloudera.hiveserver2.support.exceptions.ExceptionType;
import com.cloudera.hiveserver2.support.exceptions.FailedPropertiesReason;
import com.cloudera.hiveserver2.support.exceptions.GeneralException;
import com.cloudera.hiveserver2.utilities.FunctionID;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;

public abstract class SConnection
implements IJDBCConnection {
    protected int m_maxVarcharSize = 256;
    protected int m_maxVarbinarySize = 256;
    protected ILogger m_logger = null;
    private volatile boolean m_isClosed = false;
    protected final Object m_closingLock = new Object();
    private String m_URL = "";
    private Set<IJDBCStatement> m_stmtReferences = Collections.newSetFromMap(new WeakHashMap());
    private IDatabaseMetaData m_databaseMetaData = null;
    private final Object m_databaseMetadataLock = new Object();
    protected IConnection m_connection = null;
    protected SWarningListener m_warningListener = null;
    private boolean m_isInTransaction = false;
    private Stack<SSavepoint> m_savepoints = new Stack();
    private int m_savepointId = 1;
    private boolean m_allowTransactionCallbacks = true;
    protected final Object m_transactionLock = new Object();
    private boolean m_areMaxSizesAreSet = false;
    private boolean m_autoCommitDisabledInNotifyBegin = false;
    private final IJDBCObjectFactory m_jdbcObjectFactory;

    protected SConnection(IConnection iConnection, String string, IJDBCObjectFactory iJDBCObjectFactory) throws SQLException {
        if (iJDBCObjectFactory == null) {
            throw null;
        }
        try {
            this.m_logger = iConnection.getConnectionLog();
            if (null == this.m_logger) {
                this.m_logger = new DSILogger("SimbaJDBC_Connection.log");
            }
            LogUtilities.logFunctionEntrance(this.m_logger, iConnection);
            this.m_URL = string;
            this.m_connection = iConnection;
            this.m_jdbcObjectFactory = iJDBCObjectFactory;
            this.m_connection.registerTransactionStateListener(new STransactionStateListener(this));
            this.m_warningListener = new SWarningListener(this.m_connection.getMessageSource(), FunctionID.CONNECTION_UPDATE_SETTINGS);
            this.m_warningListener.setLocale(iConnection.getLocale());
            for (Warning object : this.m_connection.getWarningListener().getWarnings()) {
                this.m_warningListener.postWarning(object);
            }
            this.m_connection.registerWarningListener(this.m_warningListener);
            try {
                Variant variant = DSIDriverSingleton.getInstance().getProperty(5);
                LogUtilities.logInfo("Driver version is: " + variant.getString(), this.m_logger);
                Variant variant2 = this.m_connection.getProperty(170);
                LogUtilities.logInfo("Datasource version is: " + variant2.getString(), this.m_logger);
            }
            catch (ErrorException errorException) {
                LogUtilities.logInfo("Wasn't able to retrieve driver/datasource version.", this.m_logger);
                LogUtilities.logInfo(errorException, this.m_logger);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Deprecated
    protected SConnection(IConnection iConnection, String string) throws SQLException {
        this(iConnection, string, JDBCObjectFactory.getInstance());
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            this.m_warningListener.clear();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        Object object = this.m_closingLock;
        synchronized (object) {
            if (!this.m_isClosed) {
                this.abortInternal();
                this.m_isClosed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void commit() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.checkIfOpen();
        Object object = this.m_transactionLock;
        synchronized (object) {
            try {
                if (this.getAutoCommit()) {
                    if (!this.isDataSourceReadOnly()) throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.COMMIT_AUTOCOMMIT, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
                    return;
                }
                if (!this.m_isInTransaction) {
                    return;
                }
                this.m_allowTransactionCallbacks = false;
                this.m_savepoints.clear();
                this.handleTransactionBehavior(37);
                this.m_connection.commit();
                this.m_isInTransaction = false;
            }
            catch (Exception exception) {
                throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
            }
            finally {
                this.m_allowTransactionCallbacks = true;
            }
            return;
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return new StatementCreator<IJDBCStatement>(){

                @Override
                protected IJDBCStatement create(IStatement iStatement) throws SQLException {
                    return SConnection.this.getJDBCObjectFactory().newStatement(iStatement, SConnection.this, 1007);
                }
            }.create();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Statement createStatement(int n, final int n2) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, n2);
        this.checkIfOpen();
        if (1003 != n || this.getConcurrency() < n2 || n2 != 1007 && n2 != 1008) {
            SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
        try {
            return new StatementCreator<IJDBCStatement>(){

                @Override
                protected IJDBCStatement create(IStatement iStatement) throws SQLException {
                    return SConnection.this.getJDBCObjectFactory().newStatement(iStatement, SConnection.this, n2);
                }
            }.create();
        }
        catch (ErrorException errorException) {
            throw ExceptionConverter.getInstance().toSQLException(errorException, this.m_warningListener);
        }
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, n2, n3);
        this.checkIfOpen();
        if (this.getHoldability() == n3) {
            return this.createStatement(n, n2);
        }
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.m_logger);
        throw sQLException;
    }

    public Object getAttribute(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (!this.m_connection.isCustomProperty(n)) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_ATTRIBUTE, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, String.valueOf(n));
            }
            Variant variant = this.m_connection.getCustomProperty(n);
            switch (variant.getType()) {
                case 5: {
                    return variant.getShort();
                }
                case 2: {
                    return Character.valueOf(variant.getChar());
                }
                case 6: {
                    return variant.getInt();
                }
                case 3: 
                case 7: {
                    return variant.getLong();
                }
                case 4: {
                    return variant.getBigInteger();
                }
            }
            return variant.getString();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            Variant variant = this.m_connection.getProperty(19);
            return 1L == variant.getLong();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (!PropertyUtilities.hasCatalogSupport(this.m_connection)) {
                return null;
            }
            Variant variant = this.m_connection.getProperty(22);
            return variant.getString();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public IConnection getDSIConnection() {
        return this.m_connection;
    }

    public IConnection getConnection() {
        return this.m_connection;
    }

    public static int getHoldability(IConnection iConnection, IWarningListener iWarningListener) throws SQLException, BadPropertyKeyException, ErrorException, IncorrectTypeException, NumericOverflowException {
        long l = -1L;
        Variant variant = iConnection.getProperty(37);
        l = variant.getLong();
        if (1L == l || 0L == l) {
            return 2;
        }
        if (2L == l) {
            return 1;
        }
        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.UNKNOWN_HOLDABILITY, iWarningListener, ExceptionType.NON_TRANSIENT, String.valueOf(l));
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return SConnection.getHoldability(this.m_connection, this.m_warningListener);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    public final IJDBCObjectFactory getJDBCObjectFactory() {
        return this.m_jdbcObjectFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            Object object = this.m_databaseMetadataLock;
            synchronized (object) {
                if (null == this.m_databaseMetaData) {
                    this.m_databaseMetaData = this.getJDBCObjectFactory().newDatabaseMetaData(this, this.m_logger);
                }
                return this.m_databaseMetaData;
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            Variant variant = this.m_connection.getProperty(26);
            long l = variant.getLong();
            if (0L == l) {
                return 0;
            }
            if (2L == l) {
                return 2;
            }
            if (1L == l) {
                return 1;
            }
            if (4L == l) {
                return 4;
            }
            if (8L == l) {
                return 8;
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.UNKNOWN_ISOLATION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, String.valueOf(l));
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return new HashMap();
        }
        catch (SQLException sQLException) {
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.m_warningListener.getSQLWarnings();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public IWarningListener getWarningListener() {
        return this.m_warningListener;
    }

    @Override
    public boolean isClosed() {
        return this.m_isClosed;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            Variant variant = this.m_connection.getProperty(16);
            return variant.getLong() == Long.valueOf(1L).longValue();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string);
            this.checkIfOpen();
            return this.m_connection.toNativeSQL(string);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public CallableStatement prepareCall(final String string) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string);
            this.checkIfOpen();
            if (!PropertyUtilities.hasStoredProcedureSupport(this.m_connection)) {
                SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
                LogUtilities.logError(sQLException, this.m_logger);
                throw sQLException;
            }
            this.beginTransaction();
            return (CallableStatement)new StatementCreator<IJDBCCallableStatement>(){

                @Override
                protected IJDBCCallableStatement create(IStatement iStatement) throws SQLException {
                    return SConnection.this.getJDBCObjectFactory().newCallableStatement(string, iStatement, SConnection.this, 1007);
                }
            }.create();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public CallableStatement prepareCall(final String string, int n, final int n2) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, n, n2);
        this.checkIfOpen();
        if (!PropertyUtilities.hasStoredProcedureSupport(this.m_connection)) {
            SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
        if (1003 != n || this.getConcurrency() < n2 || n2 != 1007 && n2 != 1008) {
            SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
        try {
            this.beginTransaction();
            return (CallableStatement)new StatementCreator<IJDBCCallableStatement>(){

                @Override
                protected IJDBCCallableStatement create(IStatement iStatement) throws SQLException {
                    return SConnection.this.getJDBCObjectFactory().newCallableStatement(string, iStatement, SConnection.this, n2);
                }
            }.create();
        }
        catch (ErrorException errorException) {
            throw ExceptionConverter.getInstance().toSQLException(errorException, this.m_warningListener);
        }
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, n, n2, n3);
        this.checkIfOpen();
        if (!PropertyUtilities.hasStoredProcedureSupport(this.m_connection)) {
            SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
        if (this.getHoldability() == n3) {
            return this.prepareCall(string, n, n2);
        }
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.m_logger);
        throw sQLException;
    }

    @Override
    public IJDBCPreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(string, (ParameterGeneratedValues)null);
    }

    private IJDBCPreparedStatement prepareStatement(final String string, ParameterGeneratedValues parameterGeneratedValues) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string);
            this.checkIfOpen();
            this.beginTransaction();
            IJDBCPreparedStatement iJDBCPreparedStatement = (IJDBCPreparedStatement)new StatementCreator<IJDBCPreparedStatement>(){

                @Override
                protected IJDBCPreparedStatement create(IStatement iStatement) throws SQLException {
                    return SConnection.this.getJDBCObjectFactory().newPreparedStatement(string, iStatement, SConnection.this, 1007);
                }
            }.create();
            try {
                iJDBCPreparedStatement.setGeneratedValues(parameterGeneratedValues);
            }
            catch (Exception exception) {
                iJDBCPreparedStatement.close();
                throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener);
            }
            return iJDBCPreparedStatement;
        }
        catch (ErrorException errorException) {
            throw ExceptionConverter.getInstance().toSQLException(errorException, this.m_warningListener);
        }
    }

    @Override
    public IJDBCPreparedStatement prepareStatement(String string, int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, n);
            this.checkIfOpen();
            if (n != 1 && n != 2) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_OBJECT, (IWarningListener)this.m_warningListener, ExceptionType.DATA, new Object[0]);
            }
            if (this.getMetaData().supportsGetGeneratedKeys()) {
                return this.prepareStatement(string, new ParameterGeneratedValues(n));
            }
            if (n == 1) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
            }
            return this.prepareStatement(string);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public IJDBCPreparedStatement prepareStatement(final String string, int n, final int n2) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, n, n2);
        this.checkIfOpen();
        if (1003 != n || this.getConcurrency() < n2 || n2 != 1007 && n2 != 1008) {
            SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
        try {
            this.beginTransaction();
            return (IJDBCPreparedStatement)new StatementCreator<IJDBCPreparedStatement>(){

                @Override
                protected IJDBCPreparedStatement create(IStatement iStatement) throws SQLException {
                    return SConnection.this.getJDBCObjectFactory().newPreparedStatement(string, iStatement, SConnection.this, n2);
                }
            }.create();
        }
        catch (ErrorException errorException) {
            throw ExceptionConverter.getInstance().toSQLException(errorException, this.m_warningListener);
        }
    }

    @Override
    public IJDBCPreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, n, n2, n3);
        this.checkIfOpen();
        if (this.getHoldability() == n3) {
            return this.prepareStatement(string, n, n2);
        }
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.m_logger);
        throw sQLException;
    }

    @Override
    public IJDBCPreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, nArray);
            this.checkIfOpen();
            if (this.getMetaData().supportsGetGeneratedKeys()) {
                return this.prepareStatement(string, new ParameterGeneratedValues(nArray));
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public IJDBCPreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, stringArray);
            this.checkIfOpen();
            if (this.getMetaData().supportsGetGeneratedKeys()) {
                return this.prepareStatement(string, new ParameterGeneratedValues(stringArray));
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, savepoint);
        this.checkIfOpen();
        Object object = this.m_transactionLock;
        synchronized (object) {
            try {
                if (this.getAutoCommit()) {
                    if (this.isDataSourceReadOnly()) {
                        return;
                    }
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.ROLLBACK_AUTOCOMMIT, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
                }
                if (!this.m_savepoints.contains(savepoint)) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_SAVEPOINT, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
                }
                if (((SSavepoint)savepoint).isNamed()) {
                    this.m_connection.releaseSavepoint(savepoint.getSavepointName());
                } else {
                    this.m_connection.releaseSavepoint(String.valueOf(savepoint.getSavepointId()));
                }
                while (this.m_savepoints.pop() != savepoint) {
                }
            }
            catch (Exception exception) {
                throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void rollback() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.checkIfOpen();
        Object object = this.m_transactionLock;
        synchronized (object) {
            try {
                if (this.getAutoCommit()) {
                    if (!this.isDataSourceReadOnly()) throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.ROLLBACK_AUTOCOMMIT, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
                    return;
                }
                if (!this.m_isInTransaction) {
                    return;
                }
                this.m_allowTransactionCallbacks = false;
                this.m_savepoints.clear();
                this.handleTransactionBehavior(38);
                this.m_connection.rollback();
                this.m_isInTransaction = false;
            }
            catch (Exception exception) {
                throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
            }
            finally {
                this.m_allowTransactionCallbacks = true;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, savepoint);
        this.checkIfOpen();
        Object object = this.m_transactionLock;
        synchronized (object) {
            try {
                if (this.getAutoCommit()) {
                    if (this.isDataSourceReadOnly()) {
                        return;
                    }
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.ROLLBACK_AUTOCOMMIT, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
                }
                this.m_allowTransactionCallbacks = false;
                if (!this.m_savepoints.contains(savepoint)) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_SAVEPOINT, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
                }
                assert (this.m_isInTransaction);
                this.handleTransactionBehavior(38);
                if (((SSavepoint)savepoint).isNamed()) {
                    this.m_connection.rollback(savepoint.getSavepointName());
                } else {
                    this.m_connection.rollback(String.valueOf(savepoint.getSavepointId()));
                }
                while (this.m_savepoints.pop() != savepoint) {
                }
            }
            catch (Exception exception) {
                throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
            }
            finally {
                this.m_allowTransactionCallbacks = true;
            }
        }
    }

    public void setAttribute(int n, Object object) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (!this.m_connection.isCustomProperty(n)) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_ATTRIBUTE, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, String.valueOf(n));
            }
            int n2 = this.m_connection.getCustomPropertyType(n);
            this.m_connection.setCustomProperty(n, new Variant(n2, object));
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, bl);
        this.checkIfOpen();
        Object object = this.m_transactionLock;
        synchronized (object) {
            try {
                if (!bl && !this.getMetaData().supportsTransactions()) {
                    if (this.isDataSourceReadOnly()) {
                        return;
                    }
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
                }
                this.m_allowTransactionCallbacks = false;
                Long l = null;
                if (bl) {
                    l = 1L;
                    if (this.m_isInTransaction) {
                        this.handleTransactionBehavior(37);
                        this.m_connection.commit();
                    }
                    this.m_isInTransaction = false;
                } else {
                    l = 0L;
                }
                Variant variant = new Variant(3, l);
                this.m_warningListener.clearAndSetFunction(FunctionID.CONNECTION_SET_PROPERTY);
                this.m_connection.setProperty(19, variant);
            }
            catch (Exception exception) {
                throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
            }
            finally {
                this.m_allowTransactionCallbacks = true;
            }
        }
    }

    @Override
    public void setCatalog(String string) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string);
            this.checkIfOpen();
            if (!PropertyUtilities.hasCatalogSupport(this.m_connection)) {
                return;
            }
            Variant variant = null;
            variant = null == string ? new Variant(0, "") : new Variant(0, string);
            this.m_warningListener.clearAndSetFunction(FunctionID.CONNECTION_SET_PROPERTY);
            this.m_connection.setProperty(22, variant);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            if (!this.getMetaData().supportsResultSetHoldability(n)) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.UNSUPPORTED_HOLDABILITY, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, String.valueOf(n));
            }
            Character c = null;
            switch (n) {
                case 2: {
                    c = Character.valueOf('\u0001');
                    break;
                }
                case 1: {
                    c = Character.valueOf('\u0002');
                    break;
                }
                default: {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.UNKNOWN_HOLDABILITY, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, String.valueOf(n));
                }
            }
            Variant variant = new Variant(2, c);
            this.m_warningListener.clearAndSetFunction(FunctionID.CONNECTION_SET_PROPERTY);
            this.m_connection.setProperty(37, variant);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void setReadOnly(boolean bl) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, bl);
            this.checkIfOpen();
            if (this.m_isInTransaction) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.SETREADONLY_IN_TRANSACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            }
            Variant variant = bl ? new Variant(3, 1L) : new Variant(3, 0L);
            this.m_warningListener.clearAndSetFunction(FunctionID.CONNECTION_SET_PROPERTY);
            this.m_connection.setProperty(16, variant);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.checkIfOpen();
        Object object = this.m_transactionLock;
        synchronized (object) {
            try {
                if (this.getAutoCommit()) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.SAVEPOINT_AUTOCOMMIT, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
                }
                if (!this.m_isInTransaction && this.m_connection.getProperty(1009).getInt() == 0) {
                    this.m_connection.beginTransaction();
                    this.m_isInTransaction = true;
                }
                this.m_connection.createSavepoint(String.valueOf(this.m_savepointId));
                this.m_isInTransaction = true;
                SSavepoint sSavepoint = new SSavepoint(this.m_savepointId, this.m_logger, (IWarningListener)this.m_warningListener);
                ++this.m_savepointId;
                this.m_savepoints.push(sSavepoint);
                return sSavepoint;
            }
            catch (Exception exception) {
                throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
            }
        }
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        this.checkIfOpen();
        Object object = this.m_transactionLock;
        synchronized (object) {
            try {
                if (this.getAutoCommit()) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.SAVEPOINT_AUTOCOMMIT, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
                }
                if (!this.m_isInTransaction && this.m_connection.getProperty(1009).getInt() == 0) {
                    this.m_connection.beginTransaction();
                    this.m_isInTransaction = true;
                }
                this.m_connection.createSavepoint(string);
                this.m_isInTransaction = true;
                SSavepoint sSavepoint = new SSavepoint(string, this.m_logger, (IWarningListener)this.m_warningListener);
                ++this.m_savepointId;
                this.m_savepoints.push(sSavepoint);
                return sSavepoint;
            }
            catch (Exception exception) {
                throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
            }
        }
    }

    @Override
    public void setTransactionIsolation(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            Long l = null;
            DatabaseMetaData databaseMetaData = this.getMetaData();
            switch (n) {
                case 1: {
                    if (databaseMetaData.supportsTransactionIsolationLevel(1)) {
                        l = 1L;
                        break;
                    }
                }
                case 2: {
                    if (databaseMetaData.supportsTransactionIsolationLevel(2)) {
                        l = 2L;
                        break;
                    }
                }
                case 4: {
                    if (databaseMetaData.supportsTransactionIsolationLevel(4)) {
                        l = 4L;
                        break;
                    }
                }
                case 8: {
                    if (databaseMetaData.supportsTransactionIsolationLevel(8)) {
                        l = 8L;
                        break;
                    }
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.UNSUPPORTED_TXN_ISOLATION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, String.valueOf(n));
                }
                default: {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.UNKNOWN_ISOLATION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, String.valueOf(n));
                }
            }
            Variant variant = new Variant(3, l);
            this.m_warningListener.clearAndSetFunction(FunctionID.CONNECTION_SET_PROPERTY);
            this.m_connection.setProperty(26, variant);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, map);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, objectArray);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.m_logger);
        throw sQLException;
    }

    @Override
    public Blob createBlob() throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_connection instanceof IBlobFactory) {
            this.checkIfOpen();
            return ((IBlobFactory)((Object)this.m_connection)).createBlob();
        }
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.m_logger);
        throw sQLException;
    }

    @Override
    public Clob createClob() throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_connection instanceof IClobFactory) {
            this.checkIfOpen();
            return ((IClobFactory)((Object)this.m_connection)).createClob();
        }
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.m_logger);
        throw sQLException;
    }

    @Override
    public NClob createNClob() throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.m_logger);
        throw sQLException;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.m_logger);
        throw sQLException;
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, objectArray);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.m_logger);
        throw sQLException;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.checkIfOpen();
        Properties properties = new Properties();
        Set<String> set = this.m_connection.getClientInfoProperties().keySet();
        for (String string : set) {
            try {
                String string2 = this.m_connection.getClientInfo(string);
                if (null == string2) continue;
                properties.setProperty(string, string2);
            }
            catch (ErrorException errorException) {
                throw ExceptionConverter.getInstance().toSQLException(errorException, this.m_warningListener, this.m_logger);
            }
        }
        return properties;
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.checkIfOpen();
        try {
            return this.m_connection.getClientInfo(string);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean isValid(int var1_1) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return WrapperUtilities.isWrapperFor(clazz, this);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        Object object;
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            this.checkIfOpen();
        }
        catch (SQLException sQLException) {
            throw (SQLClientInfoException)ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONNECTION_CLOSED, (IWarningListener)this.m_warningListener, ExceptionType.CLIENT_INFO, new Object[0]);
        }
        Map<String, ClientInfoData> map = this.m_connection.getClientInfoProperties();
        for (Map.Entry<String, ClientInfoData> iterator : map.entrySet()) {
            object = iterator.getKey();
            if (null != properties && properties.containsKey(object)) {
                this.setClientInfo((String)object, properties.getProperty((String)object));
                properties.remove(object);
                continue;
            }
            this.setClientInfo((String)object, null);
        }
        if (null != properties && 0 != properties.size()) {
            HashMap hashMap = new HashMap();
            Iterator<Object> iterator = properties.keySet().iterator();
            if (iterator.hasNext()) {
                object = iterator.next();
                hashMap.put(object.toString(), FailedPropertiesReason.UNKNOWN_PROPERTY);
                throw (SQLClientInfoException)ExceptionConverter.getInstance().toSQLException(DSIDriver.s_DSIMessages.createClientInfoException(DSIMessageKey.INVALID_PROPKEY.name(), object.toString(), (Map<String, FailedPropertiesReason>)hashMap), this.m_warningListener, this.m_logger);
            }
        }
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            this.checkIfOpen();
        }
        catch (SQLException sQLException) {
            throw (SQLClientInfoException)ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONNECTION_CLOSED, (IWarningListener)this.m_warningListener, ExceptionType.CLIENT_INFO, new Object[0]);
        }
        try {
            this.m_connection.setClientInfoProperty(string, string2);
        }
        catch (ClientInfoException clientInfoException) {
            throw (SQLClientInfoException)ExceptionConverter.getInstance().toSQLException(clientInfoException, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return WrapperUtilities.unwrap(clazz, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginTransaction() throws SQLException {
        Object object = this.m_transactionLock;
        synchronized (object) {
            if (!this.getAutoCommit() && !this.m_isInTransaction) {
                try {
                    this.m_connection.beginTransaction();
                    this.m_isInTransaction = true;
                }
                catch (Exception exception) {
                    throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeChildObjects() {
        Object object = this.m_transactionLock;
        synchronized (object) {
            if (this.m_isInTransaction) {
                try {
                    this.rollback();
                }
                catch (SQLException sQLException) {
                    LogUtilities.logError(sQLException, this.m_logger);
                }
            }
        }
        this.closeChildStatements();
        object = this.m_databaseMetadataLock;
        synchronized (object) {
            if (null != this.m_databaseMetaData) {
                try {
                    this.m_databaseMetaData.close();
                }
                catch (Exception exception) {
                    LogUtilities.logError(exception, this.m_logger);
                }
                this.m_databaseMetaData = null;
            }
        }
    }

    String getURL() {
        return this.m_URL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isInTransaction() {
        Object object = this.m_transactionLock;
        synchronized (object) {
            return this.m_isInTransaction;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyBeginTransaction() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        Object object = this.m_transactionLock;
        synchronized (object) {
            try {
                if (!this.m_allowTransactionCallbacks) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.TRANSACTION_CALLBACKS_NOT_ALLOWED, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
                }
                if (this.m_isInTransaction) {
                    ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.TRANSACTION_ALREADY_STARTED, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
                }
                if (this.getAutoCommit()) {
                    Variant variant = new Variant(3, 0L);
                    this.m_autoCommitDisabledInNotifyBegin = true;
                    this.m_warningListener.clearAndSetFunction(FunctionID.CONNECTION_SET_PROPERTY);
                    this.m_connection.setProperty(19, variant);
                }
                this.m_isInTransaction = true;
            }
            catch (SQLException sQLException) {
                throw new GeneralException(sQLException.getLocalizedMessage(), sQLException.getErrorCode(), (Throwable)sQLException);
            }
            catch (Exception exception) {
                throw new GeneralException(exception.getLocalizedMessage(), 0, (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyCommit() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        Object object = this.m_transactionLock;
        synchronized (object) {
            try {
                if (!this.m_allowTransactionCallbacks) {
                    ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.TRANSACTION_CALLBACKS_NOT_ALLOWED, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
                }
                if (this.getAutoCommit()) {
                    if (this.isDataSourceReadOnly()) {
                        return;
                    }
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.COMMIT_AUTOCOMMIT, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
                }
                assert (this.m_isInTransaction);
                this.m_savepoints.clear();
                this.handleTransactionBehavior(37);
                this.finishTransaction();
            }
            catch (SQLException sQLException) {
                throw new GeneralException(sQLException.getLocalizedMessage(), sQLException.getErrorCode(), (Throwable)sQLException);
            }
            catch (Exception exception) {
                throw new GeneralException(exception.getLocalizedMessage(), 0, (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyCreateSavepoint(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        Object object = this.m_transactionLock;
        synchronized (object) {
            try {
                if (!this.m_allowTransactionCallbacks) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.TRANSACTION_CALLBACKS_NOT_ALLOWED, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
                }
                if (this.getAutoCommit()) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.SAVEPOINT_AUTOCOMMIT, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
                }
                assert (this.m_isInTransaction);
                this.m_savepoints.push(new SSavepoint(string, this.m_logger, (IWarningListener)this.m_warningListener));
                ++this.m_savepointId;
            }
            catch (SQLException sQLException) {
                throw new GeneralException(sQLException.getLocalizedMessage(), sQLException.getErrorCode(), (Throwable)sQLException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyReleaseSavepoint(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        Object object = this.m_transactionLock;
        synchronized (object) {
            try {
                if (!this.m_allowTransactionCallbacks) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.TRANSACTION_CALLBACKS_NOT_ALLOWED, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
                }
                if (this.getAutoCommit()) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.SAVEPOINT_AUTOCOMMIT, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
                }
                assert (this.m_isInTransaction);
                int n = this.getSavepointIndex(string);
                while (this.m_savepoints.size() > n) {
                    this.m_savepoints.pop();
                }
            }
            catch (SQLException sQLException) {
                throw new GeneralException(sQLException.getLocalizedMessage(), sQLException.getErrorCode(), (Throwable)sQLException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyRollback() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        Object object = this.m_transactionLock;
        synchronized (object) {
            try {
                if (!this.m_allowTransactionCallbacks) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.TRANSACTION_CALLBACKS_NOT_ALLOWED, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
                }
                if (this.getAutoCommit()) {
                    if (this.isDataSourceReadOnly()) {
                        return;
                    }
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.COMMIT_AUTOCOMMIT, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
                }
                assert (this.m_isInTransaction);
                this.m_savepoints.clear();
                this.handleTransactionBehavior(38);
                this.finishTransaction();
            }
            catch (SQLException sQLException) {
                throw new GeneralException(sQLException.getLocalizedMessage(), sQLException.getErrorCode(), (Throwable)sQLException);
            }
            catch (Exception exception) {
                throw new GeneralException(exception.getLocalizedMessage(), 0, (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyRollbackSavepoint(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        Object object = this.m_transactionLock;
        synchronized (object) {
            try {
                if (!this.m_allowTransactionCallbacks) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.TRANSACTION_CALLBACKS_NOT_ALLOWED, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
                }
                if (this.getAutoCommit()) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.SAVEPOINT_AUTOCOMMIT, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
                }
                assert (this.m_isInTransaction);
                int n = this.getSavepointIndex(string);
                this.handleTransactionBehavior(38);
                while (this.m_savepoints.size() > n) {
                    this.m_savepoints.pop();
                }
            }
            catch (SQLException sQLException) {
                throw new GeneralException(sQLException.getLocalizedMessage(), sQLException.getErrorCode(), (Throwable)sQLException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeStatement(BaseStatement<?> baseStatement) {
        Set<IJDBCStatement> set = this.m_stmtReferences;
        synchronized (set) {
            this.m_stmtReferences.remove(baseStatement);
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    private void finishTransaction() throws Exception {
        if (this.m_autoCommitDisabledInNotifyBegin) {
            Variant variant = new Variant(3, 1L);
            this.m_warningListener.clearAndSetFunction(FunctionID.CONNECTION_SET_PROPERTY);
            this.m_connection.setProperty(19, variant);
            this.m_autoCommitDisabledInNotifyBegin = false;
            this.m_isInTransaction = false;
        } else {
            this.m_connection.beginTransaction();
            this.m_isInTransaction = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setMaxTypeValues() throws SQLException {
        Object object;
        if (this.m_areMaxSizesAreSet) {
            return;
        }
        try {
            object = this.m_connection.getProperty(1004);
            this.m_maxVarbinarySize = ((Variant)object).getInt();
            object = this.m_connection.getProperty(1005);
            this.m_maxVarcharSize = ((Variant)object).getInt();
        }
        catch (Exception exception) {
            this.m_maxVarbinarySize = 0;
            this.m_maxVarcharSize = 0;
        }
        if (0 == this.m_maxVarbinarySize || 0 == this.m_maxVarcharSize) {
            object = this.getMetaData().getTypeInfo();
            try {
                while (object.next()) {
                    int n;
                    int n2 = object.getInt(2);
                    if (12 == n2) {
                        n = object.getInt(3);
                        if (!object.wasNull()) {
                            this.m_maxVarcharSize = n;
                        }
                        if (0 == this.m_maxVarbinarySize) continue;
                    } else {
                        if (-3 != n2) continue;
                        n = object.getInt(3);
                        if (!object.wasNull()) {
                            this.m_maxVarbinarySize = n;
                        }
                        if (0 == this.m_maxVarcharSize) continue;
                    }
                    break;
                }
            }
            finally {
                object.close();
            }
        }
        this.m_areMaxSizesAreSet = true;
    }

    protected void checkIfOpen() throws SQLException {
        if (this.isClosed()) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONNECTION_CLOSED, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT_CONNECTION, new Object[0]);
        }
    }

    protected synchronized void abortInternal() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            this.closeChildObjects();
        }
        finally {
            this.closeConnection();
        }
    }

    protected synchronized void markConnectionClosed() {
        this.m_isClosed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeChildStatements() {
        ArrayList<IJDBCStatement> arrayList;
        Set<IJDBCStatement> set = this.m_stmtReferences;
        synchronized (set) {
            arrayList = new ArrayList<IJDBCStatement>(this.m_stmtReferences);
            this.m_stmtReferences.clear();
        }
        for (IJDBCStatement iJDBCStatement : arrayList) {
            try {
                iJDBCStatement.close();
            }
            catch (Exception exception) {}
        }
    }

    private void closeConnection() throws SQLException {
        if (null != this.m_connection) {
            try {
                this.m_connection.disconnect();
            }
            catch (ErrorException errorException) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONNECTION_CLOSED, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT_CONNECTION, new Object[0]);
            }
            finally {
                this.m_connection.close();
                this.m_connection = null;
            }
        }
    }

    private int getConcurrency() throws SQLException {
        try {
            Variant variant = this.m_connection.getProperty(1001);
            if (0L != variant.getLong()) {
                return 1008;
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener);
        }
        return 1007;
    }

    private int getSavepointIndex(String string) throws SQLException {
        for (int i = this.m_savepoints.size() - 1; i >= 0; --i) {
            SSavepoint sSavepoint = (SSavepoint)this.m_savepoints.get(i);
            if ((!sSavepoint.isNamed() || !string.equals(sSavepoint.getSavepointName())) && (sSavepoint.isNamed() || !string.equals(String.valueOf(sSavepoint.getSavepointId())))) continue;
            return i;
        }
        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_SAVEPOINT, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTransactionBehavior(int n) throws SQLException {
        block11: {
            try {
                ArrayList<IJDBCStatement> arrayList;
                Variant variant = this.m_connection.getProperty(n);
                long l = variant.getLong();
                if (1L == l) {
                    Set<IJDBCStatement> set = this.m_stmtReferences;
                    synchronized (set) {
                        for (IJDBCStatement iJDBCStatement : this.m_stmtReferences) {
                            iJDBCStatement.closeAllResults();
                        }
                        break block11;
                    }
                }
                if (0L != l) break block11;
                Set<IJDBCStatement> set = this.m_stmtReferences;
                synchronized (set) {
                    arrayList = new ArrayList<IJDBCStatement>(this.m_stmtReferences);
                }
                for (IJDBCStatement iJDBCStatement : arrayList) {
                    iJDBCStatement.closeAllResults();
                    iJDBCStatement.closeIfIsPrepared();
                }
            }
            catch (Exception exception) {
                throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener);
            }
        }
    }

    private boolean isDataSourceReadOnly() {
        try {
            Variant variant = this.m_connection.getProperty(40);
            return variant.getString().equals("Y");
        }
        catch (ErrorException errorException) {
            LogUtilities.logError(errorException, this.m_logger);
            return true;
        }
    }

    private abstract class StatementCreator<T extends IJDBCStatement> {
        private StatementCreator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T create() throws SQLException, ErrorException {
            T t;
            try (IStatement iStatement = SConnection.this.m_connection.createStatement();){
                t = this.create(iStatement);
                iStatement = null;
            }
            Set set = SConnection.this.m_stmtReferences;
            synchronized (set) {
                SConnection.this.m_stmtReferences.add(t);
            }
            return t;
        }

        protected abstract T create(IStatement var1) throws SQLException;
    }

    protected static class Handler
    implements Callable<Boolean> {
        private IConnection m_connection;

        public Handler(IConnection iConnection) {
            this.m_connection = iConnection;
        }

        @Override
        public Boolean call() throws Exception {
            return this.m_connection.isAlive();
        }
    }
}

