/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.jdbc.jdbc42.future;

import com.cloudera.hiveserver2.dsi.core.interfaces.IStatement;
import com.cloudera.hiveserver2.dsi.core.utilities.Variant;
import com.cloudera.hiveserver2.exceptions.ExceptionConverter;
import com.cloudera.hiveserver2.exceptions.JDBCMessageKey;
import com.cloudera.hiveserver2.jdbc.common.BaseStatement;
import com.cloudera.hiveserver2.jdbc.common.SConnection;
import com.cloudera.hiveserver2.jdbc.jdbc41.future.S41Statement;
import com.cloudera.hiveserver2.support.IWarningListener;
import com.cloudera.hiveserver2.support.LogUtilities;
import com.cloudera.hiveserver2.support.exceptions.ExceptionType;
import com.cloudera.hiveserver2.utilities.JDBCVersion;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.util.Collections;

public class S42Statement
extends S41Statement {
    public S42Statement(IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        this(iStatement, sConnection, n, JDBCVersion.JDBC42);
    }

    public S42Statement(IStatement iStatement, SConnection sConnection, int n, JDBCVersion jDBCVersion) throws SQLException {
        super(iStatement, sConnection, n, jDBCVersion);
    }

    @Override
    public synchronized long[] executeLargeBatch() throws SQLException, BatchUpdateException {
        try {
            this.executeAnyBatch();
            return this.processLargeBatchResults(this.getResultsIterator(), Collections.emptyList(), BaseStatement.BaseBatchType.MULTI_STATEMENT);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String string) throws SQLException {
        try {
            return this.executeAnyUpdate(string);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String string, int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, n);
            this.checkIfOpen();
            if (n == 2 || !S42Statement.isInsertStatement(string)) {
                return this.executeLargeUpdate(string);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String string, int[] nArray) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, nArray);
            this.checkIfOpen();
            if (!S42Statement.isInsertStatement(string)) {
                return this.executeLargeUpdate(string);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String string, String[] stringArray) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, stringArray);
            this.checkIfOpen();
            if (!S42Statement.isInsertStatement(string)) {
                return this.executeLargeUpdate(string);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized long getLargeMaxRows() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            Variant variant = this.m_statement.getProperty(2);
            long l = variant.getLong();
            if (Long.MAX_VALUE < l || Long.MIN_VALUE > l) {
                return 0L;
            }
            return l;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized long getLargeUpdateCount() throws SQLException {
        return this.getAnyUpdateCount();
    }

    @Override
    public synchronized void setLargeMaxRows(long l) throws SQLException {
        this.setAnyMaxRows(l);
    }
}

