/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.relation;

import com.cloudera.hiveserver2.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.AEColumnInfo;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.AEQColumnName;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.IAEBinaryNode;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.IAENode;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;

public abstract class AEBinaryRelationalExpr
extends AERelationalExpr
implements IAEBinaryNode<AERelationalExpr, AERelationalExpr> {
    private AERelationalExpr m_left;
    private AERelationalExpr m_right;
    protected boolean[] m_dataNeeded;
    protected boolean m_shouldUpdateDNTracker = true;

    protected AEBinaryRelationalExpr(AERelationalExpr aERelationalExpr, AERelationalExpr aERelationalExpr2) {
        this.m_left = aERelationalExpr;
        this.m_left.setParent(this);
        this.m_right = aERelationalExpr2;
        this.m_right.setParent(this);
    }

    protected AEBinaryRelationalExpr(AEBinaryRelationalExpr aEBinaryRelationalExpr) {
        super(aEBinaryRelationalExpr);
        this.m_shouldUpdateDNTracker = true;
        this.m_left = aEBinaryRelationalExpr.m_left.copy();
        this.m_left.setParent(this);
        this.m_right = aEBinaryRelationalExpr.m_right.copy();
        this.m_right.setParent(this);
    }

    @Override
    public abstract AEBinaryRelationalExpr copy();

    @Override
    public AERelationalExpr getLeftOperand() {
        return this.m_left;
    }

    public Iterator<IAENode> getChildItr() {
        return this.asList().iterator();
    }

    protected abstract IAENode getChild(int var1);

    @Override
    public int findColumn(String string, boolean bl) {
        if (null == string || string.length() == 0) {
            throw new IllegalArgumentException("name cannot be null or empty.");
        }
        int n = this.getColumnCount();
        for (int i = 0; i < n; ++i) {
            String string2 = this.getColumn(i).getName();
            if (!(bl ? string.equals(string2) : string.equalsIgnoreCase(string2))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public AEColumnInfo findQColumn(AEQColumnName aEQColumnName, boolean bl) throws ErrorException {
        AEColumnInfo aEColumnInfo = this.getLeftOperand().findQColumn(aEQColumnName, bl);
        if (null != aEColumnInfo) {
            return aEColumnInfo;
        }
        return this.getRightOperand().findQColumn(aEQColumnName, bl);
    }

    public void setLeftOperand(AERelationalExpr aERelationalExpr) {
        aERelationalExpr.setParent(this);
        this.m_left = aERelationalExpr;
    }

    @Override
    public AERelationalExpr getRightOperand() {
        return this.m_right;
    }

    public void setRightOperand(AERelationalExpr aERelationalExpr) {
        aERelationalExpr.setParent(this);
        this.m_right = aERelationalExpr;
    }

    @Override
    public IColumn getColumn(int n) {
        int n2 = this.getLeftOperand().getColumnCount();
        if (n < n2) {
            return this.getLeftOperand().getColumn(n);
        }
        return this.getRightOperand().getColumn(n - n2);
    }

    @Override
    public int getColumnCount() {
        return this.getLeftOperand().getColumnCount() + this.getRightOperand().getColumnCount();
    }

    @Override
    public boolean getDataNeeded(int n) {
        if (this.m_shouldUpdateDNTracker) {
            this.m_dataNeeded = new boolean[this.getLeftOperand().getColumnCount() + this.getRightOperand().getColumnCount()];
            this.m_shouldUpdateDNTracker = false;
        }
        return this.m_dataNeeded[n];
    }

    @Override
    public int setDataNeeded(AERelationalExpr aERelationalExpr, int n) throws ErrorException {
        if (this.m_shouldUpdateDNTracker) {
            this.m_dataNeeded = new boolean[this.getLeftOperand().getColumnCount() + this.getRightOperand().getColumnCount()];
            this.m_shouldUpdateDNTracker = false;
        }
        if (aERelationalExpr.equals(this)) {
            this.m_dataNeeded[n] = true;
            if (n >= this.m_left.getColumnCount()) {
                this.m_right.setDataNeeded(this.m_right, n - this.m_left.getColumnCount());
            } else {
                this.m_left.setDataNeeded(this.m_left, n);
            }
            return n;
        }
        int n2 = this.m_left.setDataNeeded(aERelationalExpr, n);
        if (n2 == -1) {
            n2 = this.m_right.setDataNeeded(aERelationalExpr, n);
            if (n2 != -1) {
                this.m_dataNeeded[n2 += this.m_left.getColumnCount()] = true;
            }
        } else {
            this.m_dataNeeded[n2] = true;
        }
        return n2;
    }

    @Override
    public void setDataNeededOnChild() throws ErrorException {
        this.m_left.setDataNeededOnChild();
        this.m_right.setDataNeededOnChild();
    }

    private List<IAENode> asList() {
        return new AbstractList<IAENode>(){

            @Override
            public IAENode get(int n) {
                return AEBinaryRelationalExpr.this.getChild(n);
            }

            @Override
            public int size() {
                return AEBinaryRelationalExpr.this.getNumChildren();
            }
        };
    }
}

