/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.relation;

import com.cloudera.hiveserver2.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.IAENode;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.IAENodeVisitor;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.IAEUnaryNode;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.relation.AENamedRelationalExpr;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;

public class AESubQuery
extends AENamedRelationalExpr
implements IAEUnaryNode<AERelationalExpr> {
    private boolean m_isCorrelated;
    private boolean m_isInFrom;
    private AERelationalExpr m_operand;
    private boolean[] m_dataNeeded;
    protected boolean m_shouldUpdateDNTracker = true;

    public AESubQuery(AERelationalExpr aERelationalExpr, boolean bl, boolean bl2) {
        this.m_operand = aERelationalExpr;
        this.m_operand.setParent(this);
        this.m_isCorrelated = bl;
        this.m_isInFrom = bl2;
    }

    protected AESubQuery(AESubQuery aESubQuery) {
        super(aESubQuery);
        this.m_shouldUpdateDNTracker = true;
        this.m_operand = aESubQuery.getOperand().copy();
        this.m_operand.setParent(this);
        this.m_isCorrelated = aESubQuery.m_isCorrelated;
        this.m_isInFrom = aESubQuery.m_isInFrom;
    }

    @Override
    public <T> T acceptVisitor(IAENodeVisitor<T> iAENodeVisitor) throws ErrorException {
        return iAENodeVisitor.visit(this);
    }

    public boolean hasCorrelationName() {
        String string = this.getCorrelationName();
        return null != string && !"".equals(string);
    }

    @Override
    public int getNumChildren() {
        return 1;
    }

    public boolean isCorrelated() {
        return this.m_isCorrelated;
    }

    @Override
    public boolean isEquivalent(IAENode iAENode) {
        if (this == iAENode) {
            return true;
        }
        if (!(iAENode instanceof AESubQuery)) {
            return false;
        }
        return ((AESubQuery)iAENode).getOperand().isEquivalent(this.getOperand());
    }

    public boolean isInFromClause() {
        return this.m_isInFrom;
    }

    @Override
    public AESubQuery copy() {
        return new AESubQuery(this);
    }

    protected IAENode getChild(int n) {
        if (0 == n) {
            return this.getOperand();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Iterator<? extends IAENode> getChildItr() {
        return this.asList().iterator();
    }

    @Override
    public AERelationalExpr getOperand() {
        return this.m_operand;
    }

    @Override
    public String getCatalogName() {
        return "";
    }

    @Override
    public String getSchemaName() {
        return "";
    }

    @Override
    public String getTableName() {
        return this.getCorrelationName();
    }

    @Override
    public IColumn getBaseColumn(int n) {
        return this.m_operand.getColumn(n);
    }

    @Override
    public int getColumnCount() {
        return this.m_operand.getColumnCount();
    }

    @Override
    public boolean getDataNeeded(int n) {
        if (this.m_shouldUpdateDNTracker) {
            this.m_dataNeeded = new boolean[this.m_operand.getColumnCount()];
            this.m_shouldUpdateDNTracker = false;
        }
        return this.m_dataNeeded[n];
    }

    @Override
    public int setDataNeeded(AERelationalExpr aERelationalExpr, int n) throws ErrorException {
        if (this.m_shouldUpdateDNTracker) {
            this.m_dataNeeded = new boolean[this.m_operand.getColumnCount()];
            this.m_shouldUpdateDNTracker = false;
        }
        if (aERelationalExpr.equals(this)) {
            this.m_dataNeeded[n] = true;
            this.getOperand().setDataNeeded(this.getOperand(), n);
            return n;
        }
        this.getOperand().setDataNeeded(aERelationalExpr, n);
        return -1;
    }

    @Override
    public void setDataNeededOnChild() throws ErrorException {
        this.getOperand().setDataNeededOnChild();
    }

    public void setOperand(AERelationalExpr aERelationalExpr) {
        if (aERelationalExpr == null) {
            throw new NullPointerException("null is set for sub-query operand.");
        }
        this.m_operand = aERelationalExpr;
        this.m_operand.setParent(this);
    }

    private List<IAENode> asList() {
        return new AbstractList<IAENode>(){

            @Override
            public IAENode get(int n) {
                return AESubQuery.this.getChild(n);
            }

            @Override
            public int size() {
                return AESubQuery.this.getNumChildren();
            }
        };
    }
}

