/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.sqlengine.dsiext.dataengine;

import com.cloudera.hiveserver2.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.AEColumnInfo;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aemanipulator.AETreeManipulator;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.AEDefaultVisitor;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.IAENode;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.relation.AEProject;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.relation.AETable;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.value.AEAdd;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.value.AEColumnReference;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.value.AECustomScalarFn;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.value.AELiteral;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.value.AEMultiply;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.value.AENegate;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.value.AENull;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.value.AEParameter;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.value.AERename;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.value.AEScalarFn;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.value.AESearchedCase;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.value.AESimpleCase;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.value.AESubtract;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.value.AEValueExprList;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.value.AEValueSubQuery;
import com.cloudera.hiveserver2.sqlengine.dsiext.dataengine.DSIExtJResultSet;
import com.cloudera.hiveserver2.sqlengine.dsiext.dataengine.IProjectionHandler;
import com.cloudera.hiveserver2.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.hiveserver2.support.Pair;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class DSIExtAbstractProjectionHandler
implements IProjectionHandler {
    @Override
    public AERelationalExpr passdown(AEProject aEProject) {
        Pair<int[], Map<Integer, List<PDColumnInfo>>> pair;
        assert (aEProject.getOperand() instanceof AETable);
        try {
            pair = this.passdownProjectList(aEProject);
        }
        catch (ErrorException errorException) {
            return null;
        }
        int[] nArray = pair.key();
        Map<Integer, List<PDColumnInfo>> map = pair.value();
        DSIExtJResultSet dSIExtJResultSet = this.takeResult();
        if (null == dSIExtJResultSet) {
            return null;
        }
        AETable aETable = null;
        try {
            aETable = new AETable(dSIExtJResultSet);
        }
        catch (ErrorException errorException) {
            return null;
        }
        int[] nArray2 = new int[aETable.getColumnCount()];
        Arrays.fill(nArray2, -1);
        for (Integer n : map.keySet()) {
            for (PDColumnInfo object : map.get(n)) {
                assert (nArray2[object.m_num] == -1);
                if (null != object.m_renameName) continue;
                nArray2[object.m_num] = n;
            }
        }
        aETable.overrideCorrelationSpec((AETable)aEProject.getOperand(), nArray2);
        boolean bl = true;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= 0) continue;
            bl = false;
            break;
        }
        if (bl) {
            Iterator iterator = aEProject.getProjectionList().getChildItr();
            int n = 0;
            while (iterator.hasNext()) {
                IColumn iColumn = ((AEValueExpr)iterator.next()).getColumn();
                IColumn iColumn2 = aETable.getColumn(n);
                assert (iColumn.getTypeMetadata().equals(iColumn2.getTypeMetadata()));
                ++n;
            }
            return aETable;
        }
        if (this.updateProjectList(aEProject, aETable, nArray, map)) {
            aEProject.setOperand(aETable);
        }
        return null;
    }

    protected abstract DSIExtJResultSet takeResult();

    protected boolean passdownAdd(AEAdd aEAdd, String string) {
        return false;
    }

    protected abstract void passdownColumnRef(AEColumnReference var1, String var2) throws ErrorException;

    protected boolean passdownCustomScalarFn(AECustomScalarFn aECustomScalarFn, String string) {
        return false;
    }

    protected boolean passdownLiteral(AELiteral aELiteral, String string) {
        return false;
    }

    protected boolean passdownMultiply(AEMultiply aEMultiply, String string) {
        return false;
    }

    protected boolean passdownNegate(AENegate aENegate, String string) {
        return false;
    }

    protected boolean passdownNull(AENull aENull, String string) {
        return false;
    }

    protected boolean passdownParameter(AEParameter aEParameter, String string) {
        return false;
    }

    protected boolean passdownScalarFn(AEScalarFn aEScalarFn, String string) {
        return false;
    }

    protected boolean passdownSearchedCase(AESearchedCase aESearchedCase, String string) {
        return false;
    }

    protected boolean passdownSimpleCase(AESimpleCase aESimpleCase, String string) {
        return false;
    }

    protected boolean passdownSubtract(AESubtract aESubtract, String string) {
        return false;
    }

    protected boolean passdownValueSubquery(AEValueSubQuery aEValueSubQuery, String string) {
        return false;
    }

    private Pair<int[], Map<Integer, List<PDColumnInfo>>> passdownProjectList(AEProject aEProject) throws ErrorException {
        int[] nArray = new int[aEProject.getProjectionList().getNumChildren()];
        PDValueExprVisitor pDValueExprVisitor = new PDValueExprVisitor((AETable)aEProject.getOperand());
        Iterator iterator = aEProject.getProjectionList().getChildItr();
        int n = 0;
        while (iterator.hasNext()) {
            AEValueExpr aEValueExpr = this.ignoreRenames((AEValueExpr)iterator.next());
            boolean bl = aEValueExpr.acceptVisitor(pDValueExprVisitor);
            if (bl) {
                if (aEValueExpr instanceof AEColumnReference) {
                    List list = (List)pDValueExprVisitor.m_colRefToProjectMap.get(((AEColumnReference)aEValueExpr).getColumnNum());
                    nArray[n] = ((PDColumnInfo)list.get((int)(list.size() - 1))).m_num;
                } else {
                    nArray[n] = pDValueExprVisitor.m_counter++;
                }
            } else {
                nArray[n] = -1;
                this.passdownAllCols(aEValueExpr, pDValueExprVisitor);
            }
            ++n;
        }
        return new Pair<int[], Map<Integer, List<PDColumnInfo>>>(nArray, pDValueExprVisitor.m_colRefToProjectMap);
    }

    private AEValueExpr ignoreRenames(AEValueExpr aEValueExpr) {
        while (aEValueExpr instanceof AERename) {
            aEValueExpr = ((AERename)aEValueExpr).getOperand();
        }
        return aEValueExpr;
    }

    private void passdownAllCols(IAENode iAENode, final PDValueExprVisitor pDValueExprVisitor) throws ErrorException {
        if (iAENode instanceof AEColumnReference) {
            return;
        }
        AEDefaultVisitor<Void> aEDefaultVisitor = new AEDefaultVisitor<Void>(){

            @Override
            public Void visit(AEColumnReference aEColumnReference) throws ErrorException {
                if (!pDValueExprVisitor.m_colRefToProjectMap.containsKey(aEColumnReference.getColumnNum())) {
                    pDValueExprVisitor.visit(aEColumnReference);
                }
                return null;
            }

            @Override
            protected Void defaultVisit(IAENode iAENode) throws ErrorException {
                Iterator<? extends IAENode> iterator = iAENode.getChildItr();
                while (iterator.hasNext()) {
                    iterator.next().acceptVisitor(this);
                }
                return null;
            }
        };
        iAENode.acceptVisitor(aEDefaultVisitor);
    }

    private boolean updateProjectList(AEProject aEProject, final AETable aETable, int[] nArray, final Map<Integer, List<PDColumnInfo>> map) {
        AEValueExprList aEValueExprList = aEProject.getProjectionList().copy();
        for (int i = 0; i < aEValueExprList.getNumChildren(); ++i) {
            Object object;
            if (0 <= nArray[i]) {
                object = ((AEValueExpr)aEValueExprList.getChild(i)).getColumn();
                IColumn iColumn = aETable.getColumn(nArray[i]);
                assert (object.getTypeMetadata().equals(iColumn.getTypeMetadata()));
                aEValueExprList.replaceNode(new AEColumnReference(new AEColumnInfo(aETable, nArray[i], false)), i);
                continue;
            }
            object = new AEDefaultVisitor<Void>(){

                @Override
                public Void visit(AEColumnReference aEColumnReference) throws ErrorException {
                    if (map.containsKey(aEColumnReference.getColumnNum()) && !aEColumnReference.isOuterReference()) {
                        AEColumnReference aEColumnReference2 = new AEColumnReference(new AEColumnInfo(aETable, ((PDColumnInfo)((List)map.get((Object)Integer.valueOf((int)aEColumnReference.getColumnNum()))).get((int)0)).m_num, false));
                        assert (aEColumnReference.getColumn().getTypeMetadata().equals(aEColumnReference2.getColumn().getTypeMetadata()));
                        AETreeManipulator.replaceValueExpr(aEColumnReference, aEColumnReference2);
                    }
                    return null;
                }

                @Override
                protected Void defaultVisit(IAENode iAENode) throws ErrorException {
                    Iterator<? extends IAENode> iterator = iAENode.getChildItr();
                    while (iterator.hasNext()) {
                        iterator.next().acceptVisitor(this);
                    }
                    return null;
                }
            };
            try {
                ((AEValueExpr)aEValueExprList.getChild(i)).acceptVisitor(object);
                continue;
            }
            catch (ErrorException errorException) {
                return false;
            }
        }
        AEValueExprList aEValueExprList2 = aEProject.getProjectionList();
        for (int i = 0; i < aEValueExprList2.getNumChildren(); ++i) {
            aEValueExprList2.replaceNode(aEValueExprList.getChild(i), i);
        }
        return true;
    }

    private class PDColumnInfo {
        final String m_renameName;
        final int m_num;

        public PDColumnInfo(String string, int n) {
            this.m_renameName = string;
            this.m_num = n;
        }
    }

    private class PDValueExprVisitor
    extends AEDefaultVisitor<Boolean> {
        private final Map<Integer, List<PDColumnInfo>> m_colRefToProjectMap;
        private int m_counter;
        List<Boolean> m_renameTracker;
        private final AETable m_projectTable;

        public PDValueExprVisitor(AETable aETable) {
            this.m_projectTable = aETable;
            this.m_colRefToProjectMap = new HashMap<Integer, List<PDColumnInfo>>();
            this.m_counter = 0;
            this.m_renameTracker = new ArrayList<Boolean>();
        }

        @Override
        public Boolean visit(AEAdd aEAdd) {
            String string = this.checkAlias(aEAdd);
            boolean bl = DSIExtAbstractProjectionHandler.this.passdownAdd(aEAdd, string);
            if (bl) {
                this.m_renameTracker.add(string != null);
            }
            return bl;
        }

        @Override
        public Boolean visit(AEColumnReference aEColumnReference) throws ErrorException {
            if (this.m_projectTable != aEColumnReference.getNamedRelationalExpr()) {
                return false;
            }
            String string = this.checkAlias(aEColumnReference);
            DSIExtAbstractProjectionHandler.this.passdownColumnRef(aEColumnReference, string);
            if (!this.m_colRefToProjectMap.containsKey(aEColumnReference.getColumnNum())) {
                this.m_colRefToProjectMap.put(aEColumnReference.getColumnNum(), new ArrayList());
            }
            this.m_colRefToProjectMap.get(aEColumnReference.getColumnNum()).add(new PDColumnInfo(string, this.m_counter++));
            return true;
        }

        @Override
        public Boolean visit(AECustomScalarFn aECustomScalarFn) {
            return DSIExtAbstractProjectionHandler.this.passdownCustomScalarFn(aECustomScalarFn, this.checkAlias(aECustomScalarFn));
        }

        @Override
        public Boolean visit(AELiteral aELiteral) {
            return DSIExtAbstractProjectionHandler.this.passdownLiteral(aELiteral, this.checkAlias(aELiteral));
        }

        @Override
        public Boolean visit(AEMultiply aEMultiply) {
            return DSIExtAbstractProjectionHandler.this.passdownMultiply(aEMultiply, this.checkAlias(aEMultiply));
        }

        @Override
        public Boolean visit(AENegate aENegate) {
            return DSIExtAbstractProjectionHandler.this.passdownNegate(aENegate, this.checkAlias(aENegate));
        }

        @Override
        public Boolean visit(AENull aENull) {
            return DSIExtAbstractProjectionHandler.this.passdownNull(aENull, this.checkAlias(aENull));
        }

        @Override
        public Boolean visit(AEParameter aEParameter) {
            return DSIExtAbstractProjectionHandler.this.passdownParameter(aEParameter, this.checkAlias(aEParameter));
        }

        @Override
        public Boolean visit(AEScalarFn aEScalarFn) {
            return DSIExtAbstractProjectionHandler.this.passdownScalarFn(aEScalarFn, this.checkAlias(aEScalarFn));
        }

        @Override
        public Boolean visit(AESearchedCase aESearchedCase) {
            return DSIExtAbstractProjectionHandler.this.passdownSearchedCase(aESearchedCase, this.checkAlias(aESearchedCase));
        }

        @Override
        public Boolean visit(AESimpleCase aESimpleCase) {
            return DSIExtAbstractProjectionHandler.this.passdownSimpleCase(aESimpleCase, this.checkAlias(aESimpleCase));
        }

        @Override
        public Boolean visit(AESubtract aESubtract) {
            return DSIExtAbstractProjectionHandler.this.passdownSubtract(aESubtract, this.checkAlias(aESubtract));
        }

        @Override
        public Boolean visit(AEValueSubQuery aEValueSubQuery) {
            return DSIExtAbstractProjectionHandler.this.passdownValueSubquery(aEValueSubQuery, this.checkAlias(aEValueSubQuery));
        }

        @Override
        protected Boolean defaultVisit(IAENode iAENode) throws ErrorException {
            throw SQLEngineExceptionFactory.invalidAETreeForPassdown();
        }

        private String checkAlias(IAENode iAENode) {
            IAENode iAENode2;
            String string = null;
            while ((iAENode2 = iAENode.getParent()) instanceof AERename) {
                string = ((AERename)iAENode.getParent()).getQColumnName().getColName();
                iAENode = iAENode2;
            }
            return string;
        }
    }
}

