/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar;

import com.cloudera.hiveserver2.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.ETDataRequest;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.ETValueExpr;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETScalarFn;
import com.cloudera.hiveserver2.support.conv.ConverterConstants;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;
import java.sql.Time;
import java.util.GregorianCalendar;
import java.util.List;

public final class ETCurTimeFn
extends ETScalarFn {
    private int m_timePrecision;
    private long m_timeInMillis;

    public ETCurTimeFn(IColumn iColumn, List<ETValueExpr> list, List<IColumn> list2) throws ErrorException {
        super(iColumn, list, list2);
        assert (list.isEmpty() && list2.isEmpty());
        this.m_timePrecision = Math.min(iColumn.getTypeMetadata().getPrecision(), 3);
    }

    @Override
    public void open() throws ErrorException {
        super.open();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1970, 0, 1);
        long l = gregorianCalendar.getTimeInMillis();
        this.m_timeInMillis = l -= (long)ConverterConstants.MILLIS_MOD[this.m_timePrecision];
    }

    @Override
    public String getLogString() {
        return "ETCurTimeFn";
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        assert (this.isOpen());
        eTDataRequest.getData().setTime(new Time(this.m_timeInMillis));
        return false;
    }
}

