/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar;

import com.cloudera.hiveserver2.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver2.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.cloudera.hiveserver2.sqlengine.executor.etree.ETDataRequest;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.ETValueExpr;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETScalarFn;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;
import java.util.List;

public class ETIfNullFn
extends ETScalarFn {
    public ETIfNullFn(IColumn iColumn, List<ETValueExpr> list, List<IColumn> list2) throws ErrorException {
        super(iColumn, list, list2);
        assert (2 == list.size() && 2 == list2.size());
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        long l = eTDataRequest.getOffset();
        long l2 = eTDataRequest.getMaxSize();
        ISqlDataWrapper iSqlDataWrapper = this.getArgumentData(0, l, l2);
        boolean bl = this.hasMoreData(0);
        if (iSqlDataWrapper.isNull()) {
            iSqlDataWrapper = this.getArgumentData(1, l, l2);
            if (iSqlDataWrapper.isNull()) {
                eTDataRequest.getData().setNull();
                return false;
            }
            bl = this.hasMoreData(1);
        }
        switch (iSqlDataWrapper.getType()) {
            case -5: {
                eTDataRequest.getData().setBigInt(iSqlDataWrapper.getBigInt());
                break;
            }
            case 2: 
            case 3: {
                eTDataRequest.getData().setExactNumber(iSqlDataWrapper.getExactNumber());
                break;
            }
            case 6: 
            case 8: {
                eTDataRequest.getData().setDouble(iSqlDataWrapper.getDouble());
                break;
            }
            case 7: {
                eTDataRequest.getData().setReal(iSqlDataWrapper.getReal());
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                eTDataRequest.getData().setBinary(iSqlDataWrapper.getBinary());
                break;
            }
            case -7: 
            case 16: {
                eTDataRequest.getData().setBoolean(iSqlDataWrapper.getBoolean());
                break;
            }
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                eTDataRequest.getData().setChar(iSqlDataWrapper.getChar());
                break;
            }
            case 91: {
                eTDataRequest.getData().setDate(iSqlDataWrapper.getDate());
                break;
            }
            case 92: {
                eTDataRequest.getData().setTime(iSqlDataWrapper.getTime());
                break;
            }
            case 93: {
                eTDataRequest.getData().setTimestamp(iSqlDataWrapper.getTimestamp());
                break;
            }
            case -11: {
                eTDataRequest.getData().setGuid(iSqlDataWrapper.getGuid());
                break;
            }
            case 4: {
                eTDataRequest.getData().setInteger(iSqlDataWrapper.getInteger());
                break;
            }
            case 5: {
                eTDataRequest.getData().setSmallInt(iSqlDataWrapper.getSmallInt());
                break;
            }
            case -6: {
                eTDataRequest.getData().setTinyInt(iSqlDataWrapper.getTinyInt());
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid data type to IFNULL scalar: " + iSqlDataWrapper.getType());
            }
        }
        return bl;
    }
}

