/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.sqlengine.executor.materializer;

import com.cloudera.hiveserver2.dsi.core.utilities.Variant;
import com.cloudera.hiveserver2.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver2.dsi.exceptions.IncorrectTypeException;
import com.cloudera.hiveserver2.dsi.exceptions.NumericOverflowException;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.AETreeWalker;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.IAENode;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.relation.AETable;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.statement.AEInsert;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.statement.AEInsertDefaults;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.statement.AESetClause;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.statement.AESetClauseList;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.statement.AEUpdate;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.value.AEColumnReference;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.value.AEValueExprList;
import com.cloudera.hiveserver2.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.hiveserver2.sqlengine.executor.etree.bool.ETBooleanExpr;
import com.cloudera.hiveserver2.sqlengine.executor.etree.relation.ETRelationalCache;
import com.cloudera.hiveserver2.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.cloudera.hiveserver2.sqlengine.executor.etree.relation.ETTable;
import com.cloudera.hiveserver2.sqlengine.executor.etree.relation.ETTableConstructor;
import com.cloudera.hiveserver2.sqlengine.executor.etree.statement.ETInsert;
import com.cloudera.hiveserver2.sqlengine.executor.etree.statement.ETSearchedUpdate;
import com.cloudera.hiveserver2.sqlengine.executor.etree.statement.ETSetClause;
import com.cloudera.hiveserver2.sqlengine.executor.etree.statement.ETSetClauseList;
import com.cloudera.hiveserver2.sqlengine.executor.etree.statement.RowCountStatement;
import com.cloudera.hiveserver2.sqlengine.executor.etree.temptable.TemporaryTable;
import com.cloudera.hiveserver2.sqlengine.executor.etree.temptable.TemporaryTableBuilder;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.ETValueExpr;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.ETValueExprList;
import com.cloudera.hiveserver2.sqlengine.executor.materializer.ConvMaterializeUtil;
import com.cloudera.hiveserver2.sqlengine.executor.materializer.ETBoolExprMaterializer;
import com.cloudera.hiveserver2.sqlengine.executor.materializer.ETRelationalExprMaterializer;
import com.cloudera.hiveserver2.sqlengine.executor.materializer.ETTableMaterializer;
import com.cloudera.hiveserver2.sqlengine.executor.materializer.ETValueExprMaterializer;
import com.cloudera.hiveserver2.sqlengine.executor.materializer.MaterializerBase;
import com.cloudera.hiveserver2.sqlengine.executor.materializer.MaterializerContext;
import com.cloudera.hiveserver2.sqlengine.executor.queryplan.IQueryPlan;
import com.cloudera.hiveserver2.sqlengine.utilities.ExternalAlgorithmUtil;
import com.cloudera.hiveserver2.support.Pair;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ETDmlMaterializer
extends MaterializerBase<RowCountStatement> {
    public ETDmlMaterializer(IQueryPlan iQueryPlan, MaterializerContext materializerContext) {
        super(iQueryPlan, materializerContext);
    }

    @Override
    public RowCountStatement visit(AEInsert aEInsert) throws ErrorException {
        int n;
        AETable aETable = aEInsert.getTable();
        ETTable eTTable = new ETTableMaterializer(this.getQueryPlan(), this.getContext()).visit(aETable);
        AEValueExprList aEValueExprList = aEInsert.getInsertColumns();
        ArrayList<Pair<Integer, IColumn>> arrayList = new ArrayList<Pair<Integer, IColumn>>();
        if (aEValueExprList.getNumChildren() != 0) {
            for (n = 0; n < aEValueExprList.getNumChildren(); ++n) {
                AEColumnReference aEColumnReference = (AEColumnReference)aEValueExprList.getChild(n);
                arrayList.add(new Pair<Integer, IColumn>(aEColumnReference.getColumnNum(), aEColumnReference.getColumn()));
            }
        } else {
            for (n = 0; n < aETable.getColumnCount(); ++n) {
                arrayList.add(new Pair<Integer, IColumn>(n, aETable.getBaseColumn(n)));
            }
        }
        boolean[] blArray = new boolean[aEInsert.getRelationalExpr().getColumnCount()];
        for (int i = 0; i < blArray.length; ++i) {
            if (!aEInsert.getRelationalExpr().getDataNeeded(i)) continue;
            blArray[i] = true;
        }
        ETRelationalExprMaterializer eTRelationalExprMaterializer = new ETRelationalExprMaterializer(this.getQueryPlan(), this.getContext());
        eTRelationalExprMaterializer.setErrorOnTruncate(true);
        ETRelationalExpr eTRelationalExpr = aEInsert.getRelationalExpr().acceptVisitor(eTRelationalExprMaterializer);
        if (aEInsert.isRecursive() && !this.isCursorInsensitive()) {
            eTRelationalExpr = this.cacheRelation(eTRelationalExpr, blArray, aEInsert.getRelationalExpr().getResultSetColumns(), "INSERT");
        }
        ArrayList<IColumn> arrayList2 = new ArrayList<IColumn>(arrayList.size());
        for (Pair pair : arrayList) {
            arrayList2.add((IColumn)pair.value());
        }
        eTRelationalExpr = ConvMaterializeUtil.makeNewRelationConvertNode(arrayList2, eTRelationalExpr, blArray, true, this.getContext());
        return new ETInsert(eTTable, arrayList, eTRelationalExpr, this.getContext().getParameters());
    }

    @Override
    public RowCountStatement visit(AEInsertDefaults aEInsertDefaults) throws ErrorException {
        List<IColumn> list = Collections.emptyList();
        ETTableConstructor eTTableConstructor = new ETTableConstructor(new ETValueExprList(), list, new boolean[0]);
        ETTable eTTable = new ETTableMaterializer(this.getQueryPlan(), this.getContext()).visit(aEInsertDefaults.getTable());
        List<Pair<Integer, IColumn>> list2 = Collections.emptyList();
        return new ETInsert(eTTable, list2, eTTableConstructor, this.getContext().getParameters());
    }

    @Override
    public RowCountStatement visit(AEUpdate aEUpdate) throws ErrorException {
        Object object2;
        ETRelationalExprMaterializer eTRelationalExprMaterializer = new ETRelationalExprMaterializer(this.getQueryPlan(), this.getContext());
        AETable aETable = aEUpdate.getTable();
        AESetClauseList aESetClauseList = aEUpdate.getSetClauses();
        ETTable eTTable = eTRelationalExprMaterializer.visit(aETable);
        List<IColumn> list = aEUpdate.getTable().getResultSetColumns();
        boolean bl = aEUpdate.doInsertOnRc0();
        if (bl) {
            for (Object object2 : aESetClauseList) {
                AETreeWalker aETreeWalker = new AETreeWalker(((AESetClause)object2).getRightOperand());
                while (aETreeWalker.hasNext()) {
                    AEColumnReference aEColumnReference;
                    IAENode iAENode = aETreeWalker.next();
                    if (!(iAENode instanceof AEColumnReference) || (aEColumnReference = (AEColumnReference)iAENode).getNamedRelationalExpr() != aETable) continue;
                    throw SQLEngineExceptionFactory.invalidUpsertQueryException("Table columns are referenced in the set clause");
                }
            }
        }
        ETSetClauseList eTSetClauseList = this.materializeSetClauses(aESetClauseList, list);
        object2 = aEUpdate.getUpdateCondition().acceptVisitor(new ETBoolExprMaterializer(this.getQueryPlan(), this.getContext()));
        return new ETSearchedUpdate(eTTable, eTSetClauseList, (ETBooleanExpr)object2, bl, this.getContext().getParameters());
    }

    private ETSetClauseList materializeSetClauses(AESetClauseList aESetClauseList, List<IColumn> list) throws ErrorException {
        ETValueExprMaterializer eTValueExprMaterializer = new ETValueExprMaterializer(this.getQueryPlan(), this.getContext());
        ETSetClauseList eTSetClauseList = new ETSetClauseList();
        for (AESetClause aESetClause : aESetClauseList) {
            int n = aESetClause.getLeftOperand().getColumnNum();
            ETValueExpr eTValueExpr = aESetClause.getRightOperand().acceptVisitor(eTValueExprMaterializer);
            eTValueExpr = ConvMaterializeUtil.addConversionNodeWhenNeeded(eTValueExpr, aESetClause.getRightOperand().getColumn(), list.get(n), true, this.getContext());
            eTSetClauseList.add(new ETSetClause(eTValueExpr, n));
        }
        return eTSetClauseList;
    }

    private ETRelationalExpr cacheRelation(ETRelationalExpr eTRelationalExpr, boolean[] blArray, List<IColumn> list, String string) throws ErrorException {
        ExternalAlgorithmUtil.ExternalAlgorithmProperties externalAlgorithmProperties = this.getContext().getExternalAlgorithmProperties();
        TemporaryTableBuilder.TemporaryTableProperties temporaryTableProperties = new TemporaryTableBuilder.TemporaryTableProperties(externalAlgorithmProperties.getStorageDir(), externalAlgorithmProperties.getCellMemoryLimit(), externalAlgorithmProperties.getBlockSize(), ExternalAlgorithmUtil.calculateRowSize(list, blArray, externalAlgorithmProperties.getCellMemoryLimit()), externalAlgorithmProperties.getMaxNumOpenFiles(), externalAlgorithmProperties.getLogger(), string);
        return new ETRelationalCache(eTRelationalExpr, new TemporaryTable(list, temporaryTableProperties, blArray));
    }

    private boolean isCursorInsensitive() throws ErrorException {
        Variant variant = this.getContext().getDataEngineContext().getConnProperty(39);
        try {
            return 1L == variant.getLong();
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw new AssertionError((Object)incorrectTypeException);
        }
        catch (NumericOverflowException numericOverflowException) {
            throw new AssertionError((Object)numericOverflowException);
        }
    }
}

