/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.support;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class SimbaSupportClassLoader
extends ClassLoader {
    private JarFile m_jarFile = new JarFile(SimbaSupportClassLoader.class.getProtectionDomain().getCodeSource().getLocation().getPath());

    @Override
    public Class<?> findClass(String string) throws ClassNotFoundException {
        try {
            JarEntry jarEntry = this.m_jarFile.getJarEntry(string.replace(".", "/") + ".class");
            InputStream inputStream = this.m_jarFile.getInputStream(jarEntry);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = 0;
            while ((n = inputStream.read()) >= 0) {
                byteArrayOutputStream.write(n);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            String string2 = string.substring(0, string.lastIndexOf(46));
            if (this.getPackage(string2) == null) {
                this.definePackage(string2, "", "", "", "", "", "", null);
            }
            return this.defineClass(string, byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            throw new ClassNotFoundException("Class: " + string + " could not be found");
        }
    }

    @Override
    public synchronized Class<?> loadClass(String string) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(string);
        if (clazz == null) {
            try {
                clazz = this.findClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ClassLoader classLoader = this.getParent();
                clazz = classLoader == null ? SimbaSupportClassLoader.getSystemClassLoader().loadClass(string) : classLoader.loadClass(string);
            }
        }
        return clazz;
    }
}

