/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.config;

import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.config.LoggerConfig;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.config.Loggers;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.config.plugins.Plugin;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.config.plugins.PluginElement;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.config.plugins.PluginFactory;
import java.util.concurrent.ConcurrentHashMap;

@Plugin(name="Loggers", category="Core")
public final class LoggersPlugin {
    private LoggersPlugin() {
    }

    @PluginFactory
    public static Loggers createLoggers(@PluginElement(value="Loggers") LoggerConfig[] loggers) {
        ConcurrentHashMap<String, LoggerConfig> loggerMap = new ConcurrentHashMap<String, LoggerConfig>();
        LoggerConfig root = null;
        for (LoggerConfig logger : loggers) {
            if (logger == null) continue;
            if (logger.getName().isEmpty()) {
                if (root != null) {
                    throw new IllegalStateException("Configuration has multiple root loggers. There can be only one.");
                }
                root = logger;
            }
            loggerMap.put(logger.getName(), logger);
        }
        return new Loggers(loggerMap, root);
    }
}

