/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hive.jdbc42.internal.apache.zookeeper.server;

import com.cloudera.hive.jdbc42.internal.apache.zookeeper.common.Time;
import com.cloudera.hive.jdbc42.internal.slf4j.Logger;
import com.cloudera.hive.jdbc42.internal.slf4j.LoggerFactory;
import java.util.Random;

public class BlueThrottle {
    private static final Logger LOG = LoggerFactory.getLogger(BlueThrottle.class);
    private int maxTokens = DEFAULT_CONNECTION_THROTTLE_TOKENS;
    private int fillTime = DEFAULT_CONNECTION_THROTTLE_FILL_TIME;
    private int fillCount = DEFAULT_CONNECTION_THROTTLE_FILL_COUNT;
    private int tokens = this.maxTokens;
    private long lastTime = Time.currentElapsedTime();
    private int freezeTime = DEFAULT_CONNECTION_THROTTLE_FREEZE_TIME;
    private long lastFreeze = Time.currentElapsedTime();
    private double dropIncrease = DEFAULT_CONNECTION_THROTTLE_DROP_INCREASE;
    private double dropDecrease = DEFAULT_CONNECTION_THROTTLE_DROP_DECREASE;
    private double decreasePoint = DEFAULT_CONNECTION_THROTTLE_DECREASE_RATIO;
    private double drop = 0.0;
    Random rng = new Random();
    public static final String CONNECTION_THROTTLE_TOKENS = "zookeeper.connection_throttle_tokens";
    private static final int DEFAULT_CONNECTION_THROTTLE_TOKENS;
    public static final String CONNECTION_THROTTLE_FILL_TIME = "zookeeper.connection_throttle_fill_time";
    private static final int DEFAULT_CONNECTION_THROTTLE_FILL_TIME;
    public static final String CONNECTION_THROTTLE_FILL_COUNT = "zookeeper.connection_throttle_fill_count";
    private static final int DEFAULT_CONNECTION_THROTTLE_FILL_COUNT;
    public static final String CONNECTION_THROTTLE_FREEZE_TIME = "zookeeper.connection_throttle_freeze_time";
    private static final int DEFAULT_CONNECTION_THROTTLE_FREEZE_TIME;
    public static final String CONNECTION_THROTTLE_DROP_INCREASE = "zookeeper.connection_throttle_drop_increase";
    private static final double DEFAULT_CONNECTION_THROTTLE_DROP_INCREASE;
    public static final String CONNECTION_THROTTLE_DROP_DECREASE = "zookeeper.connection_throttle_drop_decrease";
    private static final double DEFAULT_CONNECTION_THROTTLE_DROP_DECREASE;
    public static final String CONNECTION_THROTTLE_DECREASE_RATIO = "zookeeper.connection_throttle_decrease_ratio";
    private static final double DEFAULT_CONNECTION_THROTTLE_DECREASE_RATIO;
    public static final String WEIGHED_CONNECTION_THROTTLE = "zookeeper.connection_throttle_weight_enabled";
    private static boolean connectionWeightEnabled;
    public static final String GLOBAL_SESSION_WEIGHT = "zookeeper.connection_throttle_global_session_weight";
    private static final int DEFAULT_GLOBAL_SESSION_WEIGHT;
    public static final String LOCAL_SESSION_WEIGHT = "zookeeper.connection_throttle_local_session_weight";
    private static final int DEFAULT_LOCAL_SESSION_WEIGHT;
    public static final String RENEW_SESSION_WEIGHT = "zookeeper.connection_throttle_renew_session_weight";
    private static final int DEFAULT_RENEW_SESSION_WEIGHT;

    protected static void setConnectionWeightEnabled(boolean enabled) {
        connectionWeightEnabled = enabled;
        BlueThrottle.logWeighedThrottlingSetting();
    }

    private static void logWeighedThrottlingSetting() {
        if (connectionWeightEnabled) {
            LOG.info("Weighed connection throttling is enabled. But it will only be effective if connection throttling is enabled");
            LOG.info("The weights for different session types are: global {} renew {} local {}", DEFAULT_GLOBAL_SESSION_WEIGHT, DEFAULT_RENEW_SESSION_WEIGHT, DEFAULT_LOCAL_SESSION_WEIGHT);
        } else {
            LOG.info("Weighed connection throttling is disabled");
        }
    }

    private static double getDoubleProp(String name, double def) {
        String val = System.getProperty(name);
        if (val != null) {
            return Double.parseDouble(val);
        }
        return def;
    }

    public synchronized void setMaxTokens(int max) {
        int deficit = this.maxTokens - this.tokens;
        this.maxTokens = max;
        this.tokens = max - deficit;
    }

    public synchronized void setFillTime(int time) {
        this.fillTime = time;
    }

    public synchronized void setFillCount(int count) {
        this.fillCount = count;
    }

    public synchronized void setFreezeTime(int time) {
        this.freezeTime = time;
    }

    public synchronized void setDropIncrease(double increase) {
        this.dropIncrease = increase;
    }

    public synchronized void setDropDecrease(double decrease) {
        this.dropDecrease = decrease;
    }

    public synchronized void setDecreasePoint(double ratio) {
        this.decreasePoint = ratio;
    }

    public synchronized int getMaxTokens() {
        return this.maxTokens;
    }

    public synchronized int getFillTime() {
        return this.fillTime;
    }

    public synchronized int getFillCount() {
        return this.fillCount;
    }

    public synchronized int getFreezeTime() {
        return this.freezeTime;
    }

    public synchronized double getDropIncrease() {
        return this.dropIncrease;
    }

    public synchronized double getDropDecrease() {
        return this.dropDecrease;
    }

    public synchronized double getDecreasePoint() {
        return this.decreasePoint;
    }

    public synchronized double getDropChance() {
        return this.drop;
    }

    public synchronized int getDeficit() {
        return this.maxTokens - this.tokens;
    }

    public int getRequiredTokensForGlobal() {
        return DEFAULT_GLOBAL_SESSION_WEIGHT;
    }

    public int getRequiredTokensForLocal() {
        return DEFAULT_LOCAL_SESSION_WEIGHT;
    }

    public int getRequiredTokensForRenew() {
        return DEFAULT_RENEW_SESSION_WEIGHT;
    }

    public boolean isConnectionWeightEnabled() {
        return connectionWeightEnabled;
    }

    public synchronized boolean checkLimit(int need) {
        if (this.maxTokens == 0) {
            return true;
        }
        long now = Time.currentElapsedTime();
        long diff = now - this.lastTime;
        if (diff > (long)this.fillTime) {
            long refill = diff * (long)this.fillCount / (long)this.fillTime;
            this.tokens = (int)Math.min((long)this.tokens + refill, (long)this.maxTokens);
            if (this.tokens < 0) {
                this.tokens = this.maxTokens;
                LOG.error("Throttle config values {}({}) and {}({}) are insane and cause long integer overflow after {}ms", CONNECTION_THROTTLE_FILL_TIME, this.fillTime, CONNECTION_THROTTLE_FILL_COUNT, this.fillCount, diff);
            }
            this.lastTime = now;
        }
        if (this.freezeTime != -1 && !this.checkBlue(now)) {
            return false;
        }
        if (this.tokens < need) {
            return false;
        }
        this.tokens -= need;
        return true;
    }

    public synchronized boolean checkBlue(long now) {
        int length = this.maxTokens - this.tokens;
        int limit = this.maxTokens;
        long diff = now - this.lastFreeze;
        long threshold = Math.round((double)this.maxTokens * this.decreasePoint);
        if (diff > (long)this.freezeTime) {
            if (length == limit && this.drop < 1.0) {
                this.drop = Math.min(this.drop + this.dropIncrease, 1.0);
            } else if ((long)length <= threshold && this.drop > 0.0) {
                this.drop = Math.max(this.drop - this.dropDecrease, 0.0);
            }
            this.lastFreeze = now;
        }
        return !(this.rng.nextDouble() < this.drop);
    }

    static {
        int tokens = Integer.getInteger(CONNECTION_THROTTLE_TOKENS, 0);
        int fillCount = Integer.getInteger(CONNECTION_THROTTLE_FILL_COUNT, 1);
        connectionWeightEnabled = Boolean.getBoolean(WEIGHED_CONNECTION_THROTTLE);
        int globalWeight = Integer.getInteger(GLOBAL_SESSION_WEIGHT, 3);
        int localWeight = Integer.getInteger(LOCAL_SESSION_WEIGHT, 1);
        int renewWeight = Integer.getInteger(RENEW_SESSION_WEIGHT, 2);
        if (globalWeight <= 0) {
            LOG.warn("Invalid global session weight {}. It should be larger than 0", (Object)globalWeight);
            DEFAULT_GLOBAL_SESSION_WEIGHT = 3;
        } else if (globalWeight < localWeight) {
            LOG.warn("The global session weight {} is less than the local session weight {}. Use the local session weight.", (Object)globalWeight, (Object)localWeight);
            DEFAULT_GLOBAL_SESSION_WEIGHT = localWeight;
        } else {
            DEFAULT_GLOBAL_SESSION_WEIGHT = globalWeight;
        }
        if (localWeight <= 0) {
            LOG.warn("Invalid local session weight {}. It should be larger than 0", (Object)localWeight);
            DEFAULT_LOCAL_SESSION_WEIGHT = 1;
        } else {
            DEFAULT_LOCAL_SESSION_WEIGHT = localWeight;
        }
        if (renewWeight <= 0) {
            LOG.warn("Invalid renew session weight {}. It should be larger than 0", (Object)renewWeight);
            DEFAULT_RENEW_SESSION_WEIGHT = 2;
        } else if (renewWeight < localWeight) {
            LOG.warn("The renew session weight {} is less than the local session weight {}. Use the local session weight.", (Object)renewWeight, (Object)localWeight);
            DEFAULT_RENEW_SESSION_WEIGHT = localWeight;
        } else {
            DEFAULT_RENEW_SESSION_WEIGHT = renewWeight;
        }
        DEFAULT_CONNECTION_THROTTLE_TOKENS = connectionWeightEnabled ? DEFAULT_GLOBAL_SESSION_WEIGHT * tokens : tokens;
        DEFAULT_CONNECTION_THROTTLE_FILL_TIME = Integer.getInteger(CONNECTION_THROTTLE_FILL_TIME, 1);
        DEFAULT_CONNECTION_THROTTLE_FILL_COUNT = connectionWeightEnabled ? DEFAULT_GLOBAL_SESSION_WEIGHT * fillCount : fillCount;
        DEFAULT_CONNECTION_THROTTLE_FREEZE_TIME = Integer.getInteger(CONNECTION_THROTTLE_FREEZE_TIME, -1);
        DEFAULT_CONNECTION_THROTTLE_DROP_INCREASE = BlueThrottle.getDoubleProp(CONNECTION_THROTTLE_DROP_INCREASE, 0.02);
        DEFAULT_CONNECTION_THROTTLE_DROP_DECREASE = BlueThrottle.getDoubleProp(CONNECTION_THROTTLE_DROP_DECREASE, 0.002);
        DEFAULT_CONNECTION_THROTTLE_DECREASE_RATIO = BlueThrottle.getDoubleProp(CONNECTION_THROTTLE_DECREASE_RATIO, 0.0);
        BlueThrottle.logWeighedThrottlingSetting();
    }
}

