/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hive.jdbc42.internal.apache.zookeeper.server.quorum;

import com.cloudera.hive.jdbc42.internal.apache.zookeeper.jmx.MBeanRegistry;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.jmx.ZKMBeanInfo;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.server.quorum.LearnerHandler;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.server.quorum.LearnerHandlerMXBean;
import com.cloudera.hive.jdbc42.internal.slf4j.Logger;
import com.cloudera.hive.jdbc42.internal.slf4j.LoggerFactory;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.management.ObjectName;

public class LearnerHandlerBean
implements LearnerHandlerMXBean,
ZKMBeanInfo {
    private static final Logger LOG = LoggerFactory.getLogger(LearnerHandlerBean.class);
    private final LearnerHandler learnerHandler;
    private final String remoteAddr;

    public LearnerHandlerBean(LearnerHandler learnerHandler, Socket socket) {
        this.learnerHandler = learnerHandler;
        InetSocketAddress sockAddr = (InetSocketAddress)socket.getRemoteSocketAddress();
        this.remoteAddr = sockAddr == null ? "Unknown" : sockAddr.getAddress().getHostAddress() + ":" + sockAddr.getPort();
    }

    @Override
    public String getName() {
        return MBeanRegistry.getInstance().makeFullPath("Learner_Connections", ObjectName.quote(this.remoteAddr), String.format("\"id:%d\"", this.learnerHandler.getSid()));
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public void terminateConnection() {
        LOG.info("terminating learner handler connection on demand {}", (Object)this.toString());
        this.learnerHandler.shutdown();
    }

    public String toString() {
        return "LearnerHandlerBean{remoteIP=" + this.remoteAddr + ",ServerId=" + this.learnerHandler.getSid() + "}";
    }
}

