/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.dsi.core.utilities.impl.future;

import com.cloudera.hiveserver1.dsi.core.utilities.future.IntervalConverter;
import com.cloudera.hiveserver1.dsi.core.utilities.future.NonTrivialJDBCConversions;
import com.cloudera.hiveserver1.dsi.core.utilities.impl.future.ConvertingJDBCDataSource;
import com.cloudera.hiveserver1.dsi.dataengine.interfaces.future.IJDBCExecution;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.DSIMonthSpan;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.TypeMetadata;
import com.cloudera.hiveserver1.dsi.exceptions.ConversionFailed;
import com.cloudera.hiveserver1.dsi.exceptions.IncorrectTypeException;
import com.cloudera.hiveserver1.support.IWarningListener;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import java.sql.SQLException;

public abstract class MonthSpanJDBCDataSource
extends ConvertingJDBCDataSource {
    private final int m_sqlType;
    private final int m_leadingFieldPrecision;

    public MonthSpanJDBCDataSource(IWarningListener iWarningListener, TypeMetadata typeMetadata) {
        super(iWarningListener);
        this.m_sqlType = typeMetadata.getType();
        switch (this.m_sqlType) {
            case 101: 
            case 102: 
            case 107: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected SQL type " + this.m_sqlType);
            }
        }
        this.m_leadingFieldPrecision = typeMetadata.getIntervalPrecision();
        assert (this.m_leadingFieldPrecision > 0 && this.m_leadingFieldPrecision <= 9);
    }

    protected IntervalConverter getIntervalConverter() {
        return IntervalConverter.INSTANCE;
    }

    protected final int getSqlType() {
        return this.m_sqlType;
    }

    protected final int getLeadingFieldPrecision() {
        return this.m_leadingFieldPrecision;
    }

    @Override
    public abstract DSIMonthSpan get() throws ErrorException;

    @Override
    public String getString() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        DSIMonthSpan dSIMonthSpan = this.get();
        if (dSIMonthSpan == null) {
            return null;
        }
        return NonTrivialJDBCConversions.monthSpanToString(dSIMonthSpan, this.m_sqlType, this.getIntervalConverter(), this.m_leadingFieldPrecision);
    }

    @Override
    protected boolean supportsConversionToRegisteredType(IJDBCExecution.OutputParameterRegistration outputParameterRegistration) {
        int n = this.getSqlTypeFromRegistration(outputParameterRegistration);
        switch (n) {
            case 101: 
            case 102: 
            case 107: 
            case 2000: {
                return true;
            }
        }
        return this.isCharType(n);
    }
}

