/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.hive.core;

import com.cloudera.hiveserver1.dsi.core.utilities.ConnSettingRequestMap;
import com.cloudera.hiveserver1.dsi.core.utilities.ConnSettingResponseMap;
import com.cloudera.hiveserver1.dsi.core.utilities.Variant;
import com.cloudera.hiveserver1.hive.core.HiveJDBCEnvironment;
import com.cloudera.hiveserver1.hive.core.HiveJDBCServerVersionUtils;
import com.cloudera.hiveserver1.hivecommon.AuthMech;
import com.cloudera.hiveserver1.hivecommon.HiveJDBCSettings;
import com.cloudera.hiveserver1.hivecommon.HiveServerType;
import com.cloudera.hiveserver1.hivecommon.ServiceDiscoveryMode;
import com.cloudera.hiveserver1.hivecommon.TransportMode;
import com.cloudera.hiveserver1.hivecommon.core.HiveJDBCCommonConnection;
import com.cloudera.hiveserver1.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.hiveserver1.hivecommon.dataengine.IHiveCustomScalarFnFactory;
import com.cloudera.hiveserver1.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.hiveserver1.jdbc.common.ProductInfoHandler;
import com.cloudera.hiveserver1.support.ILogger;
import com.cloudera.hiveserver1.support.LogUtilities;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import java.util.ArrayList;

public class HiveJDBCConnection
extends HiveJDBCCommonConnection {
    public HiveJDBCConnection(HiveJDBCEnvironment hiveJDBCEnvironment) throws ErrorException {
        super(hiveJDBCEnvironment);
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), hiveJDBCEnvironment);
    }

    @Override
    protected void setImplementationDefaultSettings() {
        this.m_settings.m_platformVersionUtils = new HiveJDBCServerVersionUtils();
        this.m_settings.m_platformDefaultUID = "hive";
        this.m_settings.m_platformDelegationUIDPropertyKey = "hive.server2.proxy.user";
        this.m_settings.m_platformCatalog = "Hive";
        this.m_settings.m_dbmsName = "Apache Hive";
        this.m_settings.m_enableDirectResults = false;
        this.m_settings.m_thriftHTTPSettings.m_enableSessionTag = false;
        this.m_settings.m_setKeyValueQueryResultSet = false;
        this.m_settings.m_cteQueryResultSet = false;
        this.m_settings.m_supportsNumRowsModified = false;
        this.m_settings.m_unrecognizedStmtReturnsQueryResult = false;
        this.m_settings.m_idleHttpConnectionExpiry = 15;
    }

    @Override
    protected void setSupportedHttpRetryType() {
        this.m_settings.m_supportedHttpRetryType = new ArrayList();
    }

    @Override
    protected ProductInfoHandler getProductInfoHandler() {
        String string = null;
        try {
            Variant variant = this.getProperty(170);
            string = variant.getString();
        }
        catch (Exception exception) {
            string = "";
        }
        return new ProductInfoHandler("SimbaApacheHiveJDBCDriver.lic", "Simba Apache Hive JDBC Driver", string, HiveJDBCCommonDriver.class);
    }

    @Override
    protected String getConnectionLogFileName() {
        return "HiveJDBC_connection_";
    }

    @Override
    public ILogger getConnectionLog() {
        if (null == this.m_log) {
            return ((HiveJDBCEnvironment)this.getParentEnvironment()).getLog();
        }
        return this.m_log;
    }

    @Override
    public ConnSettingResponseMap updateConnectionSettings(HiveJDBCSettings hiveJDBCSettings, ConnSettingRequestMap connSettingRequestMap, ConnSettingResponseMap connSettingResponseMap) {
        boolean bl = false;
        this.verifyOptionalSetting("HiveServerType", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("DecimalColumnScale", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("zk", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("transportMode", connSettingRequestMap, connSettingResponseMap);
        if (hiveJDBCSettings.m_serviceDiscoveryMode == ServiceDiscoveryMode.ZOOKEEPER) {
            hiveJDBCSettings.m_hiveServerType = HiveServerType.HiveServer2;
        } else {
            this.verifyRequiredSetting("HiveServerType", connSettingRequestMap, connSettingResponseMap);
        }
        if (null == hiveJDBCSettings.m_transportMode) {
            hiveJDBCSettings.m_transportMode = TransportMode.SASL;
        }
        if (null != hiveJDBCSettings.m_authMech) {
            bl = true;
        } else if (hiveJDBCSettings.m_transportMode.equals((Object)TransportMode.HTTP)) {
            if (AuthMech.UIDPWD != hiveJDBCSettings.m_authMech && AuthMech.SASL_KERBEROS != hiveJDBCSettings.m_authMech) {
                hiveJDBCSettings.m_authMech = AuthMech.UIDPWD;
            }
        } else if (hiveJDBCSettings.m_transportMode.equals((Object)TransportMode.SASL)) {
            hiveJDBCSettings.m_authMech = AuthMech.SASL_PLAIN_UID;
        }
        if (hiveJDBCSettings.m_transportMode.equals((Object)TransportMode.HTTP)) {
            this.verifyRequiredSetting("httpPath", connSettingRequestMap, connSettingResponseMap);
        }
        if (HiveServerType.HiveServer2 == hiveJDBCSettings.m_hiveServerType) {
            if (AuthMech.NOAUTH_SSL == hiveJDBCSettings.m_authMech) {
                hiveJDBCSettings.m_serverSSLSettings.m_enableSSL = true;
            }
            if (AuthMech.SASL_PLAIN_UIDPWD_SSL == hiveJDBCSettings.m_authMech) {
                hiveJDBCSettings.m_serverSSLSettings.m_enableSSL = true;
                hiveJDBCSettings.m_authMech = AuthMech.UIDPWD;
            }
            if (AuthMech.UIDPWD == hiveJDBCSettings.m_authMech) {
                if (bl) {
                    this.verifyRequiredSetting("UID", connSettingRequestMap, connSettingResponseMap);
                    this.verifyRequiredSetting("PWD", connSettingRequestMap, connSettingResponseMap);
                } else {
                    this.verifyOptionalSetting("UID", connSettingRequestMap, connSettingResponseMap);
                    this.verifyOptionalSetting("PWD", connSettingRequestMap, connSettingResponseMap);
                }
            }
            if (AuthMech.SASL_PLAIN_UID == hiveJDBCSettings.m_authMech) {
                if (bl) {
                    this.verifyRequiredSetting("UID", connSettingRequestMap, connSettingResponseMap);
                } else {
                    this.verifyOptionalSetting("UID", connSettingRequestMap, connSettingResponseMap);
                }
            }
            if (AuthMech.SASL_KERBEROS == hiveJDBCSettings.m_authMech) {
                this.verifyOptionalSetting("KrbRealm", connSettingRequestMap, connSettingResponseMap);
                this.verifyRequiredSetting("KrbHostFQDN", connSettingRequestMap, connSettingResponseMap);
                this.verifyRequiredSetting("KrbServiceName", connSettingRequestMap, connSettingResponseMap);
                this.verifyOptionalSetting("krbAuthType", connSettingRequestMap, connSettingResponseMap);
            }
            if (hiveJDBCSettings.m_serverSSLSettings.m_enableSSL) {
                this.verifyOptionalSetting("SSLKeyStore", connSettingRequestMap, connSettingResponseMap);
                this.verifyOptionalSetting("SSLKeyStorePwd", connSettingRequestMap, connSettingResponseMap);
                this.verifyOptionalSetting("SSLTrustStore", connSettingRequestMap, connSettingResponseMap);
                this.verifyOptionalSetting("SSLTrustStorePwd", connSettingRequestMap, connSettingResponseMap);
                this.verifyOptionalSetting("AllowSelfSignedCerts", connSettingRequestMap, connSettingResponseMap);
                this.verifyOptionalSetting("CAIssuedCertNamesMismatch", connSettingRequestMap, connSettingResponseMap);
                this.verifyOptionalSetting("AllowAllHostNames", connSettingRequestMap, connSettingResponseMap);
            }
        }
        return connSettingResponseMap;
    }

    @Override
    protected void doReset() throws ErrorException {
        this.setImplementationDefaultSettings();
    }

    @Override
    public IHiveCustomScalarFnFactory getScalarFnHelper() {
        return null;
    }

    @Override
    protected void setDefaultPort() {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
    }

    @Override
    protected boolean readServiceDiscoverySettings(String string, ConnSettingRequestMap connSettingRequestMap) throws ErrorException {
        Variant variant = this.getOptionalSetting("zk", connSettingRequestMap);
        if ((null != variant || ServiceDiscoveryMode.ZOOKEEPER.name().equalsIgnoreCase(string)) && this.m_factory.supportServiceDiscoveryMode(ServiceDiscoveryMode.ZOOKEEPER, this.getConnectionLog())) {
            this.setZookeeperServiceDiscovery(connSettingRequestMap, variant);
            return true;
        }
        return super.readServiceDiscoverySettings(string, connSettingRequestMap);
    }

    protected void setZookeeperServiceDiscovery(ConnSettingRequestMap connSettingRequestMap, Variant variant) throws ErrorException {
        String[] stringArray;
        this.m_definedSettings.put("zk", true);
        this.m_settings.m_serviceDiscoveryMode = ServiceDiscoveryMode.ZOOKEEPER;
        String string = variant.getString();
        this.m_definedSettings.put("HiveServerType", true);
        this.m_settings.m_hiveServerType = HiveServerType.HiveServer2;
        for (String string2 : stringArray = string.split(",")) {
            if (string2.matches("(.+):(\\d+)(/.+)")) continue;
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.ZOOKEEPER_QUORUM_FORMAT_ERROR.name(), string2);
            throw errorException;
        }
        this.m_settings.m_serviceDiscoveryEndpoints = stringArray;
    }
}

