/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.hivecommon.api;

import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TCancelDelegationTokenReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TCancelDelegationTokenResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TCancelOperationReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TCloseOperationReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TCloseOperationResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TCloseSessionReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TCloseSessionResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TExecuteStatementReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TExecuteStatementResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TFetchResultsReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TFetchResultsResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetCatalogsReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetCatalogsResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetColumnsReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetColumnsResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetDelegationTokenReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetDelegationTokenResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetFunctionsReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetFunctionsResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetInfoReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetInfoResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetOperationStatusReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetOperationStatusResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetResultSetMetadataReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetResultSetMetadataResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetSchemasReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetSchemasResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetTableTypesReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetTableTypesResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetTablesReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetTablesResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetTypeInfoReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetTypeInfoResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TOpenSessionReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TOpenSessionResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TRenewDelegationTokenReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TRenewDelegationTokenResp;
import com.cloudera.hive.jdbc42.internal.apache.thrift.TException;
import com.cloudera.hive.jdbc42.internal.apache.thrift.protocol.TProtocol;
import com.cloudera.hive.jdbc42.internal.apache.thrift.transport.TTransportException;
import com.cloudera.hiveserver1.dsi.core.impl.DSIDriverSingleton;
import com.cloudera.hiveserver1.hivecommon.HiveJDBCSettings;
import com.cloudera.hiveserver1.hivecommon.api.HS2ClientWrapper;
import com.cloudera.hiveserver1.hivecommon.api.TETHttpClient;
import com.cloudera.hiveserver1.hivecommon.api.WebBrowserOAuthClient;
import com.cloudera.hiveserver1.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.hiveserver1.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.hiveserver1.hivecommon.exceptions.TETokenExpirationException;
import com.cloudera.hiveserver1.hivecommon.utils.OAuthTokenCache;
import com.cloudera.hiveserver1.jdbc.common.OAuthFlow;
import com.cloudera.hiveserver1.jdbc.oauth.OAuthFactory;
import com.cloudera.hiveserver1.jdbc.oauth.RefreshTokenExpiredException;
import com.cloudera.hiveserver1.support.ILogger;
import com.cloudera.hiveserver1.support.LogUtilities;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.Random;

public class HS2OAuthClientWrapper
extends HS2ClientWrapper {
    public static final String AUTHORIZATION_KEY = "Authorization";
    public static final String TOKEN_TYPE_BEARER = "Bearer ";
    private static String OAUTH2_CODE_RESPONSE_TYPE_STR = "response_type=code&";
    private static String HTTP_LOCALHOST_PREFIX = "http://localhost:";
    private static String OAUTH2_CLIENT_ID_STR = "client_id";
    private static String OAUTH2_CLIENT_SECRET_STR = "client_secret";
    private static String OAUTH2_REDIRECTURL_STR = "redirect_uri";
    private static String OAUTH2_CODE_CHALLENGE_STR = "code_challenge";
    private static String OAUTH2_CODE_CHALLENGE_METHOD_STR = "code_challenge_method";
    private static String OAUTH2_SCOPE_STR = "scope";
    private static String OAUTH2_STATE_STR = "state";
    private static int OAUTH2_CODE_VERIFIER_GEN_LENGTH = 200;
    private static int OAUTH2_CODE_VERIFIER_MIN_LENGTH = 50;
    private static String OAUTH2_REFRESH_TOKEN = "refresh";
    private static String OAUTH2_ACCESS_TOKEN = "access";
    protected ILogger m_logger;
    protected HiveJDBCSettings m_settings;
    private WebBrowserOAuthClient m_browserClient = null;
    private OAuthTokenCache m_refreshTokenCache;
    private OAuthTokenCache m_accessTokenCache;
    private String m_codeVerifier;
    private boolean m_updateToken = false;

    public HS2OAuthClientWrapper(TProtocol tProtocol, ILogger iLogger, HiveJDBCSettings hiveJDBCSettings) throws ErrorException {
        super(tProtocol, iLogger, hiveJDBCSettings);
        LogUtilities.logFunctionEntrance(iLogger, tProtocol, iLogger, hiveJDBCSettings);
        this.m_logger = iLogger;
        this.m_settings = hiveJDBCSettings;
        if (OAuthFlow.BROWSER == hiveJDBCSettings.m_oAuthSettings.m_authFlow) {
            this.m_refreshTokenCache = new OAuthTokenCache(iLogger, hiveJDBCSettings, OAUTH2_REFRESH_TOKEN);
            this.m_accessTokenCache = new OAuthTokenCache(iLogger, hiveJDBCSettings, OAUTH2_ACCESS_TOKEN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TCancelDelegationTokenResp CancelDelegationToken(TCancelDelegationTokenReq tCancelDelegationTokenReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tCancelDelegationTokenReq);
        HS2OAuthClientWrapper hS2OAuthClientWrapper = this;
        synchronized (hS2OAuthClientWrapper) {
            try {
                return super.CancelDelegationToken(tCancelDelegationTokenReq);
            }
            catch (TETokenExpirationException tETokenExpirationException) {
                this.handleTokenExpiration(tETokenExpirationException);
                return super.CancelDelegationToken(tCancelDelegationTokenReq);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TCloseOperationResp CloseOperation(TCloseOperationReq tCloseOperationReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tCloseOperationReq);
        HS2OAuthClientWrapper hS2OAuthClientWrapper = this;
        synchronized (hS2OAuthClientWrapper) {
            try {
                return super.CloseOperation(tCloseOperationReq);
            }
            catch (TETokenExpirationException tETokenExpirationException) {
                this.handleTokenExpiration(tETokenExpirationException);
                return super.CloseOperation(tCloseOperationReq);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TCloseSessionResp CloseSession(TCloseSessionReq tCloseSessionReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tCloseSessionReq);
        HS2OAuthClientWrapper hS2OAuthClientWrapper = this;
        synchronized (hS2OAuthClientWrapper) {
            try {
                return super.CloseSession(tCloseSessionReq);
            }
            catch (TETokenExpirationException tETokenExpirationException) {
                this.handleTokenExpiration(tETokenExpirationException);
                return super.CloseSession(tCloseSessionReq);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TExecuteStatementResp ExecuteStatement(TExecuteStatementReq tExecuteStatementReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tExecuteStatementReq);
        HS2OAuthClientWrapper hS2OAuthClientWrapper = this;
        synchronized (hS2OAuthClientWrapper) {
            try {
                return super.ExecuteStatement(tExecuteStatementReq);
            }
            catch (TETokenExpirationException tETokenExpirationException) {
                this.handleTokenExpiration(tETokenExpirationException);
                return super.ExecuteStatement(tExecuteStatementReq);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TFetchResultsResp FetchResults(TFetchResultsReq tFetchResultsReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tFetchResultsReq);
        HS2OAuthClientWrapper hS2OAuthClientWrapper = this;
        synchronized (hS2OAuthClientWrapper) {
            try {
                return super.FetchResults(tFetchResultsReq);
            }
            catch (TETokenExpirationException tETokenExpirationException) {
                this.handleTokenExpiration(tETokenExpirationException);
                return super.FetchResults(tFetchResultsReq);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TGetCatalogsResp GetCatalogs(TGetCatalogsReq tGetCatalogsReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tGetCatalogsReq);
        HS2OAuthClientWrapper hS2OAuthClientWrapper = this;
        synchronized (hS2OAuthClientWrapper) {
            try {
                return super.GetCatalogs(tGetCatalogsReq);
            }
            catch (TETokenExpirationException tETokenExpirationException) {
                this.handleTokenExpiration(tETokenExpirationException);
                return super.GetCatalogs(tGetCatalogsReq);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TGetColumnsResp GetColumns(TGetColumnsReq tGetColumnsReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tGetColumnsReq);
        HS2OAuthClientWrapper hS2OAuthClientWrapper = this;
        synchronized (hS2OAuthClientWrapper) {
            try {
                return super.GetColumns(tGetColumnsReq);
            }
            catch (TETokenExpirationException tETokenExpirationException) {
                this.handleTokenExpiration(tETokenExpirationException);
                return super.GetColumns(tGetColumnsReq);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TGetDelegationTokenResp GetDelegationToken(TGetDelegationTokenReq tGetDelegationTokenReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tGetDelegationTokenReq);
        HS2OAuthClientWrapper hS2OAuthClientWrapper = this;
        synchronized (hS2OAuthClientWrapper) {
            try {
                return super.GetDelegationToken(tGetDelegationTokenReq);
            }
            catch (TETokenExpirationException tETokenExpirationException) {
                this.handleTokenExpiration(tETokenExpirationException);
                return super.GetDelegationToken(tGetDelegationTokenReq);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TGetFunctionsResp GetFunctions(TGetFunctionsReq tGetFunctionsReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tGetFunctionsReq);
        HS2OAuthClientWrapper hS2OAuthClientWrapper = this;
        synchronized (hS2OAuthClientWrapper) {
            try {
                return super.GetFunctions(tGetFunctionsReq);
            }
            catch (TETokenExpirationException tETokenExpirationException) {
                this.handleTokenExpiration(tETokenExpirationException);
                return super.GetFunctions(tGetFunctionsReq);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TGetInfoResp GetInfo(TGetInfoReq tGetInfoReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tGetInfoReq);
        HS2OAuthClientWrapper hS2OAuthClientWrapper = this;
        synchronized (hS2OAuthClientWrapper) {
            try {
                return super.GetInfo(tGetInfoReq);
            }
            catch (TETokenExpirationException tETokenExpirationException) {
                this.handleTokenExpiration(tETokenExpirationException);
                return super.GetInfo(tGetInfoReq);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TGetOperationStatusResp GetOperationStatus(TGetOperationStatusReq tGetOperationStatusReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tGetOperationStatusReq);
        HS2OAuthClientWrapper hS2OAuthClientWrapper = this;
        synchronized (hS2OAuthClientWrapper) {
            try {
                return super.GetOperationStatus(tGetOperationStatusReq);
            }
            catch (TETokenExpirationException tETokenExpirationException) {
                this.handleTokenExpiration(tETokenExpirationException);
                return super.GetOperationStatus(tGetOperationStatusReq);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TGetResultSetMetadataResp GetResultSetMetadata(TGetResultSetMetadataReq tGetResultSetMetadataReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tGetResultSetMetadataReq);
        HS2OAuthClientWrapper hS2OAuthClientWrapper = this;
        synchronized (hS2OAuthClientWrapper) {
            try {
                return super.GetResultSetMetadata(tGetResultSetMetadataReq);
            }
            catch (TETokenExpirationException tETokenExpirationException) {
                this.handleTokenExpiration(tETokenExpirationException);
                return super.GetResultSetMetadata(tGetResultSetMetadataReq);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TGetSchemasResp GetSchemas(TGetSchemasReq tGetSchemasReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tGetSchemasReq);
        HS2OAuthClientWrapper hS2OAuthClientWrapper = this;
        synchronized (hS2OAuthClientWrapper) {
            try {
                return super.GetSchemas(tGetSchemasReq);
            }
            catch (TETokenExpirationException tETokenExpirationException) {
                this.handleTokenExpiration(tETokenExpirationException);
                return super.GetSchemas(tGetSchemasReq);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TGetTableTypesResp GetTableTypes(TGetTableTypesReq tGetTableTypesReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tGetTableTypesReq);
        HS2OAuthClientWrapper hS2OAuthClientWrapper = this;
        synchronized (hS2OAuthClientWrapper) {
            try {
                return super.GetTableTypes(tGetTableTypesReq);
            }
            catch (TETokenExpirationException tETokenExpirationException) {
                this.handleTokenExpiration(tETokenExpirationException);
                return super.GetTableTypes(tGetTableTypesReq);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TGetTablesResp GetTables(TGetTablesReq tGetTablesReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tGetTablesReq);
        HS2OAuthClientWrapper hS2OAuthClientWrapper = this;
        synchronized (hS2OAuthClientWrapper) {
            try {
                return super.GetTables(tGetTablesReq);
            }
            catch (TETokenExpirationException tETokenExpirationException) {
                this.handleTokenExpiration(tETokenExpirationException);
                return super.GetTables(tGetTablesReq);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TGetTypeInfoResp GetTypeInfo(TGetTypeInfoReq tGetTypeInfoReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tGetTypeInfoReq);
        HS2OAuthClientWrapper hS2OAuthClientWrapper = this;
        synchronized (hS2OAuthClientWrapper) {
            try {
                return super.GetTypeInfo(tGetTypeInfoReq);
            }
            catch (TETokenExpirationException tETokenExpirationException) {
                this.handleTokenExpiration(tETokenExpirationException);
                return super.GetTypeInfo(tGetTypeInfoReq);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TOpenSessionResp OpenSession(TOpenSessionReq tOpenSessionReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tOpenSessionReq);
        HS2OAuthClientWrapper hS2OAuthClientWrapper = this;
        synchronized (hS2OAuthClientWrapper) {
            try {
                this.validateTokens();
                return super.OpenSession(tOpenSessionReq);
            }
            catch (TETokenExpirationException tETokenExpirationException) {
                this.handleTokenExpiration(tETokenExpirationException);
                return super.OpenSession(tOpenSessionReq);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TRenewDelegationTokenResp RenewDelegationToken(TRenewDelegationTokenReq tRenewDelegationTokenReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tRenewDelegationTokenReq);
        HS2OAuthClientWrapper hS2OAuthClientWrapper = this;
        synchronized (hS2OAuthClientWrapper) {
            try {
                return super.RenewDelegationToken(tRenewDelegationTokenReq);
            }
            catch (TETokenExpirationException tETokenExpirationException) {
                this.handleTokenExpiration(tETokenExpirationException);
                return super.RenewDelegationToken(tRenewDelegationTokenReq);
            }
        }
    }

    @Override
    public void send_CancelDelegationToken(TCancelDelegationTokenReq tCancelDelegationTokenReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.validateTokens();
        super.send_CancelDelegationToken(tCancelDelegationTokenReq);
    }

    @Override
    public void send_CancelOperation(TCancelOperationReq tCancelOperationReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.validateTokens();
        super.send_CancelOperation(tCancelOperationReq);
    }

    @Override
    public void send_CloseOperation(TCloseOperationReq tCloseOperationReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.validateTokens();
        super.send_CloseOperation(tCloseOperationReq);
    }

    @Override
    public void send_CloseSession(TCloseSessionReq tCloseSessionReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.validateTokens();
        super.send_CloseSession(tCloseSessionReq);
    }

    @Override
    public void send_ExecuteStatement(TExecuteStatementReq tExecuteStatementReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.validateTokens();
        super.send_ExecuteStatement(tExecuteStatementReq);
    }

    @Override
    public void send_FetchResults(TFetchResultsReq tFetchResultsReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.validateTokens();
        super.send_FetchResults(tFetchResultsReq);
    }

    @Override
    public void send_GetCatalogs(TGetCatalogsReq tGetCatalogsReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.validateTokens();
        super.send_GetCatalogs(tGetCatalogsReq);
    }

    @Override
    public void send_GetColumns(TGetColumnsReq tGetColumnsReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.validateTokens();
        super.send_GetColumns(tGetColumnsReq);
    }

    @Override
    public void send_GetDelegationToken(TGetDelegationTokenReq tGetDelegationTokenReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.validateTokens();
        super.send_GetDelegationToken(tGetDelegationTokenReq);
    }

    @Override
    public void send_GetFunctions(TGetFunctionsReq tGetFunctionsReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.validateTokens();
        super.send_GetFunctions(tGetFunctionsReq);
    }

    @Override
    public void send_GetInfo(TGetInfoReq tGetInfoReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.validateTokens();
        super.send_GetInfo(tGetInfoReq);
    }

    @Override
    public void send_GetOperationStatus(TGetOperationStatusReq tGetOperationStatusReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.validateTokens();
        super.send_GetOperationStatus(tGetOperationStatusReq);
    }

    @Override
    public void send_GetResultSetMetadata(TGetResultSetMetadataReq tGetResultSetMetadataReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.validateTokens();
        super.send_GetResultSetMetadata(tGetResultSetMetadataReq);
    }

    @Override
    public void send_GetSchemas(TGetSchemasReq tGetSchemasReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.validateTokens();
        super.send_GetSchemas(tGetSchemasReq);
    }

    @Override
    public void send_GetTableTypes(TGetTableTypesReq tGetTableTypesReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.validateTokens();
        super.send_GetTableTypes(tGetTableTypesReq);
    }

    @Override
    public void send_GetTables(TGetTablesReq tGetTablesReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.validateTokens();
        super.send_GetTables(tGetTablesReq);
    }

    @Override
    public void send_GetTypeInfo(TGetTypeInfoReq tGetTypeInfoReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.validateTokens();
        super.send_GetTypeInfo(tGetTypeInfoReq);
    }

    @Override
    public void send_OpenSession(TOpenSessionReq tOpenSessionReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.validateTokens();
        super.send_OpenSession(tOpenSessionReq);
    }

    @Override
    public void send_RenewDelegationToken(TRenewDelegationTokenReq tRenewDelegationTokenReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.validateTokens();
        super.send_RenewDelegationToken(tRenewDelegationTokenReq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void AuthenticateTokenPassThroughFlow() throws TException {
        if (this.m_settings.m_oAuthSettings.m_accessToken != null && this.m_settings.m_oAuthSettings.m_refreshToken == null) {
            this.m_updateToken = true;
            return;
        }
        if (this.m_settings.m_oAuthSettings.m_accessToken != null && !OAuthFactory.isAccessTokenExpired(this.m_settings.m_oAuthSettings.m_accessToken, this.m_settings.m_oAuthSettings.m_tokenExpiryBuffer)) {
            this.m_updateToken = true;
            return;
        }
        if (this.m_settings.m_oAuthSettings.m_refreshToken != null) {
            block13: {
                try {
                    this.m_updateToken = OAuthFactory.getAccessTokenFromRefresh(this.m_settings, this.m_logger);
                }
                catch (ErrorException errorException) {
                    if (this.m_settings.m_oAuthSettings.m_accessToken != null) {
                        this.m_updateToken = true;
                        LogUtilities.logError("Error occured during access token request using refresh token.", this.m_logger);
                        if (errorException.getMessageParams() != null && errorException.getMessageParams().length > 0) {
                            for (String string : errorException.getMessageParams()) {
                                LogUtilities.logError("Following error occured while getting the new access token. " + string, this.m_logger);
                            }
                        }
                        break block13;
                    }
                    String string = this.getDetailedErrorExceptionMessage(errorException);
                    TException tException = new TException(string, errorException.getCause());
                    throw tException;
                }
                finally {
                    if (!this.m_updateToken && this.m_settings.m_oAuthSettings.m_accessToken != null) {
                        this.m_updateToken = true;
                    }
                }
            }
            return;
        }
        if (this.m_settings.m_oAuthSettings.m_accessToken != null) {
            this.m_updateToken = true;
            return;
        }
        throw new TTransportException("No access token or refresh token provided");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateTokens() throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HS2OAuthClientWrapper hS2OAuthClientWrapper = this;
        synchronized (hS2OAuthClientWrapper) {
            if (null == this.m_settings || null == this.m_settings.m_oAuthSettings) {
                throw new TTransportException("Failed driver Initialization");
            }
            if (OAuthFlow.TOKEN_PASSTHROUGH == this.m_settings.m_oAuthSettings.m_authFlow) {
                this.AuthenticateTokenPassThroughFlow();
            } else if (OAuthFlow.CLIENT_CREDENTIALS == this.m_settings.m_oAuthSettings.m_authFlow) {
                if (null != this.m_settings.m_oAuthSettings.m_accessToken && System.currentTimeMillis() <= this.m_settings.m_oAuthSettings.m_expiryTime) {
                    LogUtilities.logDebug("The current access token is still valid.", this.m_logger);
                    return false;
                }
                this.executeClientCredentialAuthFlow();
            } else if (OAuthFlow.BROWSER == this.m_settings.m_oAuthSettings.m_authFlow) {
                if (null != this.m_settings.m_oAuthSettings.m_accessToken && System.currentTimeMillis() <= this.m_settings.m_oAuthSettings.m_expiryTime) {
                    LogUtilities.logDebug("The current access token is still valid.", this.m_logger);
                    return false;
                }
                this.executeBrowserAuthFlow();
            }
            if (this.m_updateToken && this.getOutputProtocol().getTransport() instanceof TETHttpClient) {
                ((TETHttpClient)this.getOutputProtocol().getTransport()).setCustomHeader(AUTHORIZATION_KEY, TOKEN_TYPE_BEARER + this.m_settings.m_oAuthSettings.m_accessToken);
                this.m_updateToken = false;
                return true;
            }
            return false;
        }
    }

    private String getDetailedErrorExceptionMessage(ErrorException errorException) {
        StringBuilder stringBuilder = new StringBuilder();
        if (errorException.hasMessageParams() && errorException.getMessageParams().length > 0) {
            for (String string : errorException.getMessageParams()) {
                stringBuilder.append(string + " ");
            }
        }
        return stringBuilder.toString();
    }

    private void getBrowserSSODetails() throws TTransportException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.m_browserClient = new WebBrowserOAuthClient(this.m_settings, this.m_logger);
            this.checkDriverConfigurations();
            String string = String.valueOf(this.m_browserClient.getPort());
            String string2 = this.generateBrowserConnectionString(string);
            this.m_browserClient.setSSOUri(new URI(string2.replace(" ", "%20")));
            this.m_browserClient.doBrowserSSO();
            if (this.m_browserClient.isSuccess()) {
                if (!this.m_settings.m_enableTestOverrideAuthorizationUrl.booleanValue()) {
                    this.m_settings.m_oAuthSettings.m_authorizationUrl = this.m_settings.m_oAuthSettings.m_Oauth2TokenEndpointKey;
                }
            } else {
                if (this.m_browserClient.hasResponse()) {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.SSO_BROWSER_AUTH_FAILED_WITH_MSG.name(), "");
                    throw errorException;
                }
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.SSO_RESPONSE_TIMEOUT.name());
                throw errorException;
            }
            this.m_settings.m_oAuthSettings.m_code = this.m_browserClient.getCode();
            this.m_settings.m_oAuthSettings.m_redirectUri = HTTP_LOCALHOST_PREFIX + string;
            this.m_settings.m_oAuthSettings.m_codeVerifier = this.m_codeVerifier;
        }
        catch (ErrorException errorException) {
            errorException.loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), DSIDriverSingleton.getInstance().getLocale());
            throw new TTransportException(errorException);
        }
        catch (URISyntaxException uRISyntaxException) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.SSO_INVALID_URL_RECEIVED.name());
            String string = this.getDetailedErrorExceptionMessage(errorException);
            TException tException = new TException(string, uRISyntaxException.getCause());
            throw new TTransportException(tException);
        }
    }

    protected void handleClientCredentials() throws ErrorException {
        this.m_settings.m_oAuthSettings.m_accessToken = OAuthFactory.clientCredentialOAuth(this.m_settings, this.m_settings.m_oAuthSettings.m_tokenEndpointSSLSettings, this.m_logger);
    }

    private String generateCodeChallenge() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_codeVerifier = "";
        String string = "";
        try {
            Object object;
            Object object2;
            while (OAUTH2_CODE_VERIFIER_MIN_LENGTH > this.m_codeVerifier.length()) {
                object2 = new byte[OAUTH2_CODE_VERIFIER_GEN_LENGTH];
                new Random().nextBytes((byte[])object2);
                object = new String((byte[])object2, Charset.forName("UTF-8"));
                this.m_codeVerifier = this.m_codeVerifier + ((String)object).replaceAll("[^a-zA-Z0-9]+", "");
            }
            object2 = MessageDigest.getInstance("SHA-256");
            object = ((MessageDigest)object2).digest(this.m_codeVerifier.getBytes(Charset.forName("UTF-8")));
            byte[] byArray = Base64.getEncoder().encode((byte[])object);
            string = new String(byArray);
            string = string.replaceAll("\\+", "-");
            string = string.replaceAll("/", "_");
            while (Character.compare(string.charAt(string.length() - 1), '=') == 0) {
                string = string.replace("=", "");
            }
        }
        catch (Exception exception) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.OAUTH_FAILED_CODE_CHALLENGE.name(), exception.getMessage());
            throw errorException;
        }
        return string;
    }

    private String generateBrowserConnectionString(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        String string2 = this.generateCodeChallenge();
        String string3 = this.m_codeVerifier.substring(this.m_codeVerifier.length() / 2);
        String string4 = this.m_settings.m_oAuthSettings.m_Oauth2AuthorizeEndpoint + "?" + OAUTH2_CODE_RESPONSE_TYPE_STR + OAUTH2_CLIENT_ID_STR + "=" + this.m_settings.m_oAuthSettings.m_authClientID + "&" + OAUTH2_CODE_CHALLENGE_STR + "=" + string2 + "&" + OAUTH2_REDIRECTURL_STR + "=" + HTTP_LOCALHOST_PREFIX + string + "&" + OAUTH2_SCOPE_STR + "=" + this.m_settings.m_oAuthSettings.m_authScope + "&" + OAUTH2_CODE_CHALLENGE_METHOD_STR + "=" + this.m_settings.m_oAuthSettings.m_OAuth2CodeChallengeMethod + "&" + OAUTH2_STATE_STR + "=" + string3;
        if (this.m_settings.m_oAuthSettings.m_authClientSecret != null) {
            string4 = string4 + "&" + OAUTH2_CLIENT_SECRET_STR + "=" + this.m_settings.m_oAuthSettings.m_authClientSecret;
        }
        if (this.m_settings.m_oAuthSettings.m_authAudience != null) {
            string4 = string4 + "&audience=" + this.m_settings.m_oAuthSettings.m_authAudience;
        }
        return string4;
    }

    private void checkDriverConfigurations() throws ErrorException {
        if (!this.m_settings.m_serverSSLSettings.m_enableSSL) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.SSL_NOT_ENABLED.name(), this.m_settings.m_authMech.getDisplayName());
            throw errorException;
        }
    }

    private void handleTokenExpiration(TETokenExpirationException tETokenExpirationException) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (!this.m_settings.m_expiredCachedAccessTokenTest.isEmpty() || !this.m_settings.m_expiredCachedRefreshTokenTest.isEmpty()) {
            this.m_settings.m_expiredCachedAccessTokenTest = "";
            this.m_settings.m_expiredCachedRefreshTokenTest = "";
        }
        if ((OAuthFlow.CLIENT_CREDENTIALS == this.m_settings.m_oAuthSettings.m_authFlow || OAuthFlow.BROWSER == this.m_settings.m_oAuthSettings.m_authFlow) && this.validateTokens()) {
            LogUtilities.logInfo("Trying again as previous call failed beacuse access token was expired.", this.m_logger);
            return;
        }
        throw tETokenExpirationException;
    }

    private void executeClientCredentialAuthFlow() throws TException {
        if (!this.m_settings.m_enableTestOverrideAuthorizationUrl.booleanValue()) {
            this.m_settings.m_oAuthSettings.m_authorizationUrl = this.m_settings.m_oAuthSettings.m_Oauth2TokenEndpointKey;
        }
        try {
            this.handleClientCredentials();
            this.m_updateToken = true;
        }
        catch (ErrorException errorException) {
            String string = this.getDetailedErrorExceptionMessage(errorException);
            TException tException = new TException(string, errorException.getCause());
            throw tException;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void executeBrowserAuthFlow() throws TException {
        var1_1 = false;
        var2_2 = this.m_settings.m_host + ".accesskey";
        var3_3 = this.m_settings.m_host;
        if (this.m_settings.m_enableTokenCache.booleanValue()) {
            try {
                var4_4 = null;
                var5_7 = null;
                try {
                    var4_4 = this.m_accessTokenCache.getTokenCache().getValue(var2_2);
                    var5_7 = this.m_refreshTokenCache.getTokenCache().getValue(var3_3);
                }
                catch (Exception var6_9) {
                    LogUtilities.logWarning(String.format("Got an Exception while retrieving Token Cache. Exception: %s", new Object[]{var6_9.getMessage()}), this.m_logger);
                }
                if (this.m_settings.m_oAuthSettings.m_accessToken != null && System.currentTimeMillis() < this.m_settings.m_oAuthSettings.m_expiryTime) ** GOTO lbl66
                if (!this.m_settings.m_expiredCachedAccessTokenTest.isEmpty()) {
                    LogUtilities.logDebug("Expired Cached Access Token Test is enabled.This code is for test purpose.", this.m_logger);
                    this.m_settings.m_oAuthSettings.m_accessToken = this.m_settings.m_expiredCachedAccessTokenTest;
                    this.m_updateToken = true;
                }
                if (var4_4 != null && !OAuthFactory.isAccessTokenExpired(var4_4, this.m_settings.m_oAuthSettings.m_tokenExpiryBuffer)) {
                    LogUtilities.logDebug("Cached access token is still valid. Driver will try to use this access token.", this.m_logger);
                    this.m_settings.m_oAuthSettings.m_accessToken = var4_4;
                    this.m_updateToken = true;
                }
                try {
                    if (!this.m_settings.m_expiredCachedRefreshTokenTest.isEmpty() || var5_7 != null) {
                        if (!this.m_settings.m_expiredCachedRefreshTokenTest.isEmpty()) {
                            LogUtilities.logDebug("Expired Cached Access Token Test is enabled.This code is for test purpose.", this.m_logger);
                            this.m_settings.m_oAuthSettings.m_refreshToken = this.m_settings.m_expiredCachedRefreshTokenTest;
                        } else {
                            LogUtilities.logDebug("Setting cached refresh token to get access token.", this.m_logger);
                            this.m_settings.m_oAuthSettings.m_refreshToken = var5_7;
                        }
                        if (this.m_settings.m_enableTestOverrideAuthorizationUrl.booleanValue()) {
                            this.m_settings.m_oAuthSettings.m_Oauth2TokenEndpointKey = this.m_settings.m_oAuthSettings.m_authorizationUrl;
                        }
                        OAuthFactory.getAccessTokenFromRefresh(this.m_settings, this.m_logger);
                        OAuthFactory.cacheToken(this.m_settings.m_oAuthSettings, this.m_refreshTokenCache, var3_3, this.m_accessTokenCache, var2_2, this.m_logger);
                        this.m_updateToken = true;
                    }
                    var1_1 = true;
                }
                catch (ErrorException var6_10) {
                    if (var6_10 instanceof RefreshTokenExpiredException) {
                        var1_1 = true;
                        LogUtilities.logError("Error occured during access token request using refresh token.", this.m_logger);
                        if (var6_10.getMessageParams() != null && var6_10.getMessageParams().length > 0) {
                            for (String var10_18 : var6_10.getMessageParams()) {
                                LogUtilities.logError("Following error occured while getting the new access token. " + var10_18, this.m_logger);
                            }
                        }
                        try {
                            if (this.m_refreshTokenCache.getTokenCache().getValue(var3_3) == null) ** GOTO lbl66
                            this.m_refreshTokenCache.getTokenCache().setValue(var3_3, this.m_refreshTokenCache.getTokenCache().getValue(var3_3), 0L);
                        }
                        catch (Exception var7_13) {
                            LogUtilities.logWarning(String.format("Got an Exception while retrieving and setting Token Cache. Exception: %s", new Object[]{var7_13.getMessage()}), this.m_logger);
                        }
                    }
                    var7_14 = this.getDetailedErrorExceptionMessage(var6_10);
                    var8_16 = new TException(var7_14, var6_10.getCause());
                    throw var8_16;
                }
            }
            catch (Exception var4_5) {
                var5_8 = new TException(var4_5.getMessage(), var4_5.getCause());
                throw var5_8;
            }
        } else if (null == this.m_settings.m_oAuthSettings.m_accessToken || System.currentTimeMillis() >= this.m_settings.m_oAuthSettings.m_expiryTime) {
            var1_1 = true;
        }
lbl66:
        // 11 sources

        if (var1_1) {
            try {
                this.getBrowserSSODetails();
                OAuthFactory.browerCredentialOauth(this.m_logger, this.m_settings, this.m_refreshTokenCache, var3_3, this.m_accessTokenCache, var2_2);
                this.m_updateToken = true;
            }
            catch (ErrorException var4_6) {
                var5_7 = this.getDetailedErrorExceptionMessage(var4_6);
                var6_11 = new TException(var5_7, var4_6.getCause());
                throw var6_11;
            }
        }
    }
}

