/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.hivecommon.api;

import com.cloudera.hive.jdbc42.internal.apache.zookeeper.KeeperException;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.WatchedEvent;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.Watcher;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.ZooKeeper;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.data.Stat;
import java.io.IOException;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ZookeeperDynamicDiscovery {
    private static final String PARSE_REGEX = ".*serverUri=(.+);version.+";
    private static final int DEFAULT_CONNECTION_TIMEOUT = 3000;
    private static final String HOST_PORT_SEPERATOR = ":";
    private CountDownLatch m_connectedSignal = new CountDownLatch(1);

    public Stack<String> retrieveInfoFromZooKeeper(String string, int n, String string2, int n2) throws KeeperException, IOException, InterruptedException, NumberFormatException {
        Stack<String> stack = new Stack<String>();
        List<String> list = this.connect(string, n, n2, string2);
        Pattern pattern = Pattern.compile(PARSE_REGEX);
        for (String string3 : list) {
            String string4;
            Matcher matcher = pattern.matcher(string3);
            if (!matcher.matches() || !(string4 = matcher.group(1)).contains(HOST_PORT_SEPERATOR)) continue;
            stack.push(string4);
        }
        return stack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> connect(String string, int n, int n2, String string2) throws KeeperException, IOException, InterruptedException {
        Stat stat;
        List<String> list = null;
        this.m_connectedSignal = new CountDownLatch(1);
        if (0 >= n2) {
            n2 = 3000;
        }
        String string3 = string + HOST_PORT_SEPERATOR + n;
        try (ZooKeeper zooKeeper = new ZooKeeper(string3, n2, new Watcher(){

            @Override
            public void process(WatchedEvent watchedEvent) {
                if (watchedEvent.getState() == Watcher.Event.KeeperState.SyncConnected) {
                    ZookeeperDynamicDiscovery.this.m_connectedSignal.countDown();
                }
            }
        });){
            stat = zooKeeper.exists(string2, false);
            list = zooKeeper.getChildren(string2, false);
        }
        return null != stat ? list : null;
    }
}

